set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-10-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '1424213',
      1,
      1.847524,
      2,
      1,
      '3303',
      2.130968,
      NULL,
      NULL,
      NULL,
      ' 2-11-1985',
      10,
      NULL,
      5,
      0.000701,
      1,
      ' 7-16-1981',
      18.026335,
      NULL,
      6.830071,
      93.158737,
      NULL,
      '11- 3-2002',
      ' 4- 0-2002',
      NULL,
      2,
      2,
      NULL,
      0,
      1.589405,
      2,
      2,
      0,
      1.402046,
      4.350307,
      NULL,
      NULL,
      0.963725,
      13.477739,
      30.816930,
      4.680479,
      17,
      2.854428,
      0.355171,
      6,
      1.070031,
      1.479708,
      1,
      2.449944,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.801905,
      1,
      1.879496,
      1.554087,
      NULL,
      1,
      1,
      0.414600,
      0,
      NULL,
      NULL,
      1.504750,
      NULL,
      NULL,
      0.651807,
      0.300576,
      1.109077,
      0,
      1.758064,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.744619,
      0,
      3,
      1,
      NULL,
      1,
      0,
      0,
      0.249603,
      NULL,
      1,
      0.219625,
      NULL,
      1,
      3,
      1.864953,
      NULL,
      1,
      NULL,
      0,
      7,
      2,
      0.818544,
      3,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.768814,
      1.390010,
      1.241296,
      NULL,
      NULL,
      0,
      1.387757,
      1.666611,
      1,
      1,
      0.708650,
      NULL,
      1,
      0,
      1.558231,
      NULL,
      1.180401,
      0.074746,
      1,
      NULL,
      0.184310,
      0.233613,
      2,
      1.361709,
      0.946253,
      1,
      0,
      1,
      1.209757,
      0.803497,
      1,
      0,
      0.934063,
      NULL,
      1.423341,
      NULL,
      NULL,
      2,
      NULL,
      4.425249,
      1,
      1,
      2,
      1.454716,
      0,
      0.316296,
      NULL,
      2,
      ' 4-26-1978',
      268.118407,
      ' 8-25-1991',
      174.002369,
      0,
      1.069655,
      0.423326,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.436866,
      1.053773,
      0.714243,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      8,
      NULL,
      1,
      0,
      1.929375,
      1.736484,
      0.128246,
      NULL,
      NULL,
      10,
      1,
      0.620052,
      0.561531,
      NULL,
      NULL,
      NULL,
      0.914230,
      1,
      NULL,
      NULL,
      1.934655,
      1.803451,
      5.874395,
      1.277063,
      NULL,
      NULL,
      1.609521,
      7.578311,
      0.920935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      0,
      0,
      1.790353,
      1,
      NULL,
      37.407092,
      2,
      1.708311,
      NULL,
      NULL,
      NULL,
      3,
      0.579198,
      3.822513,
      2,
      NULL,
      0.145301,
      3,
      NULL,
      0,
      2.001696,
      2,
      NULL,
      2,
      1.307934,
      NULL,
      2,
      0.765764,
      0.611341,
      0.993064,
      3.521884,
      NULL,
      NULL,
      NULL,
      1.404362,
      1.331826,
      NULL,
      132,
      161.352425,
      0.705625,
      1,
      1.232635,
      0,
      5,
      6.422702,
      1,
      8,
      8,
      3,
      3.266425,
      3.173948,
      3,
      1.459311,
      2,
      0,
      41.070531,
      NULL,
      2.316751,
      NULL,
      16.547517,
      9.737341,
      19,
      1,
      0,
      2.332306,
      '42333',
      '',
      NULL,
      1,
      NULL,
      NULL,
      '',
      0.878371,
      '',
      '',
      '',
      1.359799,
      31.749742,
      18.281803,
      7.807457,
      NULL,
      33,
      4.117706,
      3.273027,
      NULL,
      0,
      NULL,
      NULL,
      1.477306,
      3,
      NULL,
      0.596802,
      3,
      0.083576,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1.015955,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0.808885,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      2,
      0.931952,
      3,
      1.047772,
      NULL,
      2.271682,
      1,
      1,
      0.335091,
      NULL,
      NULL,
      2,
      0.262275,
      0,
      NULL,
      3.208587,
      1,
      5.190911,
      4,
      NULL,
      1.295474,
      1.655287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.548151,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.550130,
      5.507958,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.217531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353712,
      NULL,
      NULL,
      1.793220,
      NULL,
      NULL,
      0.258482,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.334278,
      NULL,
      NULL,
      1.368335,
      NULL,
      1.223770,
      2,
      4.763435,
      0,
      2,
      NULL,
      NULL,
      1.186648,
      NULL,
      NULL,
      2,
      0.336208,
      1.975427,
      0,
      1,
      1.401548,
      4,
      0,
      4,
      1,
      NULL,
      3,
      2,
      2,
      NULL,
      1,
      2,
      3,
      3,
      2,
      0,
      NULL,
      7.832711,
      9.181242,
      4,
      4.351237,
      1.629182,
      1.095683,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1.515414,
      NULL,
      NULL,
      NULL,
      0.613080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.191173,
      NULL,
      NULL,
      1.618713,
      NULL,
      NULL,
      0.511951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.331821,
      1.155621,
      0,
      0.734981,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.570187,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.340261,
      NULL,
      NULL,
      NULL,
      0.548658,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.271420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.452169,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.776039,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.649775,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0.929131,
      NULL,
      NULL,
      NULL,
      1.741785,
      87.092909,
      3,
      3,
      5.413979,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      1.450567,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      157,
      NULL,
      1.419370,
      0,
      1.876577,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1.912594,
      0.928829,
      NULL,
      0,
      0,
      1.503647,
      1.287254,
      0.885734,
      0.149237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.808281,
      0.148502,
      0.587809,
      1.490659,
      0,
      1,
      5,
      NULL,
      2.781078,
      0.157560,
      0,
      NULL,
      NULL,
      0.209526,
      NULL,
      NULL,
      1.177054,
      0.004944,
      NULL,
      1,
      1,
      NULL,
      3.016850,
      3.238954,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.559873,
      NULL,
      1.549346,
      1,
      NULL,
      0,
      1,
      NULL,
      1.521711,
      0,
      NULL,
      0,
      0,
      NULL,
      3,
      1.753933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728580,
      NULL,
      1,
      NULL,
      2.596710,
      1,
      1.716172,
      1,
      NULL,
      NULL,
      55.506756,
      79.744480,
      1.314352,
      0,
      1,
      '14213',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


