set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9535111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '1311303',
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1.392386,
      NULL,
      NULL,
      ' 3-27-1983',
      NULL,
      NULL,
      0.400414,
      1,
      1.744949,
      NULL,
      21,
      0,
      179,
      111,
      1.703063,
      NULL,
      ' 4-17-1977',
      ' 2-16-1986',
      2,
      3.578167,
      NULL,
      1,
      1.564445,
      0,
      0.596378,
      0.779608,
      NULL,
      NULL,
      NULL,
      4,
      3,
      5.166943,
      4,
      0,
      5.801852,
      3.230029,
      2,
      3,
      1.661163,
      0,
      0,
      0,
      1.597179,
      1,
      0,
      0.520627,
      1,
      0,
      0.873235,
      2.295320,
      4.721559,
      2.569073,
      0,
      5.697844,
      0.800029,
      2.654916,
      0.174157,
      3.437049,
      1,
      2.865931,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4.582921,
      1.113874,
      4,
      1.324794,
      1,
      0.111130,
      NULL,
      NULL,
      1.830253,
      NULL,
      NULL,
      5.923842,
      1,
      1.803815,
      0.629131,
      0.294252,
      1.823414,
      1.914543,
      0.982443,
      NULL,
      3,
      1.135817,
      0,
      NULL,
      0,
      1,
      NULL,
      1.892699,
      3.838610,
      1,
      1.982909,
      0.693255,
      0,
      0.178883,
      0,
      1.495680,
      0,
      1.065432,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.630628,
      1.914988,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507108,
      NULL,
      0.610075,
      0.606470,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1.761933,
      NULL,
      0.634680,
      6.334725,
      6.096872,
      1.724162,
      4.313225,
      2.269364,
      NULL,
      7.003876,
      1.240869,
      NULL,
      NULL,
      6,
      5.567023,
      5,
      6.275029,
      3.615950,
      NULL,
      NULL,
      NULL,
      2.778537,
      1.398103,
      3,
      ' 6-16-1980',
      153.392723,
      NULL,
      161.124850,
      1.180384,
      0,
      0.704649,
      3.456466,
      0.640844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.571063,
      NULL,
      0.533033,
      NULL,
      1.286675,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8.643034,
      NULL,
      3,
      NULL,
      1,
      0,
      3,
      NULL,
      2.074168,
      NULL,
      0.376279,
      NULL,
      2.156793,
      3,
      1.797711,
      1,
      NULL,
      4,
      7,
      3,
      0,
      6.875140,
      1,
      3,
      3.752967,
      0,
      8,
      1.211535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.768506,
      0,
      1,
      2.760540,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117629,
      4.432628,
      NULL,
      3,
      2,
      3,
      2.250249,
      NULL,
      0,
      0.387369,
      NULL,
      1.937956,
      0,
      0,
      2.269159,
      1,
      NULL,
      1,
      0,
      0.686750,
      1,
      1.791623,
      0,
      NULL,
      0.043349,
      1,
      0.668575,
      1,
      3,
      1,
      8.068476,
      NULL,
      7,
      2.203369,
      5,
      1.340052,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      15,
      1.467059,
      3,
      NULL,
      28.525522,
      NULL,
      14,
      2,
      NULL,
      4.180846,
      '12110',
      '13222',
      NULL,
      0,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      NULL,
      25,
      48.527374,
      9,
      0,
      22.515428,
      NULL,
      NULL,
      0,
      0.398411,
      1.063430,
      1.248150,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.021363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001090,
      3.061424,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.515313,
      NULL,
      NULL,
      1.134739,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      7,
      6.459112,
      1.184876,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.229956,
      NULL,
      1,
      3.533104,
      0.752988,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861710,
      1.660041,
      NULL,
      0.417851,
      0,
      2,
      1.093907,
      1,
      NULL,
      0.256467,
      0,
      1,
      0.608720,
      0.136511,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.847090,
      NULL,
      NULL,
      NULL,
      0.465016,
      NULL,
      NULL,
      NULL,
      0.742736,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.865404,
      NULL,
      NULL,
      2,
      2.339706,
      1.375838,
      1,
      NULL,
      NULL,
      5.830454,
      1.933367,
      1,
      0.029641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.345885,
      NULL,
      NULL,
      1.713166,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.629970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.868129,
      0.191119,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.988224,
      5.431664,
      1.726841,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.037573,
      1.598331,
      0,
      0.551391,
      NULL,
      2.739121,
      1,
      NULL,
      2,
      3.319921,
      1.600697,
      3,
      0.021065,
      2.984804,
      NULL,
      1.052422,
      1.455909,
      NULL,
      1,
      3.813858,
      3,
      10.041790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.737349,
      0,
      1.071286,
      NULL,
      0.531221,
      1.030793,
      1.889914,
      NULL,
      NULL,
      2.048263,
      NULL,
      NULL,
      16.387405,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.386739,
      NULL,
      NULL,
      0.859523,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.147749,
      NULL,
      NULL,
      0,
      NULL,
      0.205221,
      NULL,
      0.263000,
      2.828658,
      0.201963,
      NULL,
      NULL,
      6.443416,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.847004,
      NULL,
      NULL,
      NULL,
      2.861931,
      NULL,
      NULL,
      NULL,
      1.155429,
      NULL,
      NULL,
      NULL,
      1.474711,
      NULL,
      NULL,
      NULL,
      2.544080,
      NULL,
      NULL,
      NULL,
      3.123328,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.502599,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.041691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.039352,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8.639193,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      0.655231,
      NULL,
      NULL,
      1,
      0.145706,
      13,
      NULL,
      0.915139,
      NULL,
      NULL,
      0.015985,
      14.064420,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      68,
      NULL,
      3.189634,
      3.237051,
      NULL,
      0.851061,
      0.326898,
      NULL,
      NULL,
      3.543272,
      1.330564,
      NULL,
      0,
      NULL,
      0,
      1,
      1.565944,
      1.149029,
      2.338295,
      1.007002,
      0.281640,
      0,
      0.408509,
      0,
      0,
      NULL,
      0,
      3.105557,
      0.392229,
      3,
      5.391499,
      2,
      NULL,
      2.233307,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.577778,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0.734546,
      0.981382,
      1,
      1,
      NULL,
      0.211039,
      1,
      0,
      1.956166,
      1,
      0,
      0,
      0,
      0.735818,
      0,
      0.360006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.634610,
      2,
      3.317378,
      NULL,
      NULL,
      3.976617,
      1,
      NULL,
      4,
      1.458665,
      1,
      1.614290,
      0,
      0,
      NULL,
      1,
      3,
      NULL,
      1.061155,
      3.837930,
      NULL,
      1,
      1.371241,
      NULL,
      0.330016,
      1.466122,
      NULL,
      0.435437,
      0,
      NULL,
      2.528976,
      1.319290,
      NULL,
      2,
      0,
      NULL,
      0.281684,
      0,
      NULL,
      0.528077,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.537768,
      0.311406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.919772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935643,
      NULL,
      1.857005,
      NULL,
      3,
      7.927627,
      1,
      3.662155,
      NULL,
      3,
      NULL,
      6.089633,
      2,
      NULL,
      3.762157,
      '22334',
      '12023',
      '',
      1.052017,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


