set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9888127';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      1.219450,
      4.674572,
      0,
      2,
      2,
      0.130606,
      NULL,
      '01030042',
      28.950454,
      15,
      '3422121',
      0.490945,
      1.158079,
      1,
      3,
      '1222',
      3,
      1.450287,
      NULL,
      NULL,
      '10- 1-1993',
      14.785375,
      244.245639,
      NULL,
      0,
      3.621259,
      ' 2-22-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '11-21-1988',
      3,
      1,
      1,
      1,
      1,
      3.187319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.662554,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      NULL,
      1.293728,
      0.120243,
      1,
      1.181506,
      1,
      1,
      NULL,
      1,
      1.901549,
      0.091141,
      1.845851,
      NULL,
      1.819970,
      3.677195,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      4.143237,
      7.601362,
      2,
      4.267287,
      4.150615,
      3.671782,
      0,
      0,
      NULL,
      1.625411,
      5.766541,
      NULL,
      NULL,
      NULL,
      1.695192,
      NULL,
      NULL,
      0,
      2.484764,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869355,
      0,
      0.431319,
      1.476949,
      NULL,
      0.051424,
      0,
      0,
      0,
      0.656996,
      0.858806,
      0,
      1,
      1.477579,
      0.329106,
      1,
      1.311258,
      0.413018,
      0,
      NULL,
      1.393461,
      1.179186,
      NULL,
      0.094621,
      0.037939,
      1,
      0.501316,
      0.407362,
      1.115049,
      0.360398,
      3,
      0,
      4,
      4,
      NULL,
      NULL,
      1,
      4,
      3.839666,
      3,
      2.610429,
      NULL,
      4.140147,
      1,
      0,
      NULL,
      3,
      3.212178,
      ' 5-18-1996',
      264.386607,
      ' 4-14-2000',
      8,
      NULL,
      0,
      0.260087,
      0,
      0.543351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285289,
      NULL,
      1,
      0.764237,
      0.241574,
      0.285474,
      1,
      1.433211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461158,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.168560,
      1.382591,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469127,
      NULL,
      1.240359,
      NULL,
      NULL,
      0.419436,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.898754,
      1.114147,
      NULL,
      0.667443,
      NULL,
      1.955391,
      2,
      82.342153,
      NULL,
      0.817821,
      NULL,
      NULL,
      NULL,
      2.746993,
      0.616104,
      NULL,
      3.489345,
      3,
      NULL,
      2.789696,
      3.084689,
      2.033403,
      2.344020,
      1.722557,
      0.137277,
      3.244321,
      NULL,
      2.799232,
      3,
      3,
      0,
      1,
      1.374799,
      0,
      0,
      1.055650,
      NULL,
      0.618328,
      1.066974,
      NULL,
      1.441644,
      1.909306,
      2,
      5,
      0.368070,
      5.916908,
      7,
      3,
      NULL,
      10,
      1.353763,
      0,
      3,
      0.417370,
      1.252689,
      1.538546,
      2.217558,
      65,
      1,
      0,
      NULL,
      NULL,
      30,
      NULL,
      1,
      3,
      NULL,
      '12430',
      '',
      '',
      0,
      '',
      '',
      '',
      1.313816,
      NULL,
      NULL,
      '',
      2.351956,
      41.418121,
      NULL,
      20,
      0,
      31.610701,
      1,
      NULL,
      7,
      0.369475,
      1.650504,
      0.532639,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.887763,
      0.107698,
      0,
      1,
      NULL,
      NULL,
      1.114345,
      0,
      0.661023,
      1,
      NULL,
      0.367569,
      0.152315,
      1,
      0.260763,
      3.134782,
      0.459166,
      1.541062,
      2,
      1,
      1.486838,
      0.079013,
      1.842679,
      0.836563,
      2,
      NULL,
      0,
      6.986235,
      4.256050,
      NULL,
      1.341567,
      0.700840,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.150665,
      NULL,
      1,
      0.898037,
      3.345614,
      0,
      0.810774,
      3.561686,
      1,
      1,
      1,
      NULL,
      NULL,
      3.646951,
      1.069062,
      NULL,
      3.462065,
      3,
      0,
      NULL,
      2.807054,
      1.650942,
      2,
      1,
      NULL,
      NULL,
      3.026356,
      1.266323,
      1.716119,
      0.751495,
      0,
      0.357691,
      1.065591,
      0.429919,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.749882,
      3.183394,
      0,
      1.717242,
      0.919652,
      NULL,
      NULL,
      7,
      1.496857,
      1.598927,
      1.938452,
      NULL,
      NULL,
      0.768739,
      NULL,
      NULL,
      1.944376,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.740721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.266417,
      NULL,
      NULL,
      0.963690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.918443,
      1.205545,
      4,
      3,
      0,
      1.371444,
      NULL,
      NULL,
      2.016660,
      2,
      1,
      3.166741,
      2,
      1,
      0.931272,
      NULL,
      NULL,
      4.432898,
      2.856976,
      3,
      2.203946,
      0.391711,
      1.572157,
      NULL,
      1,
      0.847513,
      NULL,
      3.558493,
      NULL,
      3,
      NULL,
      2,
      3.450771,
      1,
      0.204023,
      NULL,
      3,
      NULL,
      1.175793,
      1,
      0.400919,
      0.258925,
      NULL,
      0,
      3.016862,
      NULL,
      NULL,
      0.091104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405632,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.756517,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.429848,
      NULL,
      NULL,
      0.819098,
      NULL,
      NULL,
      0,
      1.076770,
      0,
      0.084166,
      1.466943,
      NULL,
      1.420991,
      NULL,
      NULL,
      0.019025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154107,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.156810,
      NULL,
      NULL,
      NULL,
      3.499072,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.918275,
      NULL,
      NULL,
      NULL,
      1.413954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.729353,
      NULL,
      NULL,
      NULL,
      1.249750,
      NULL,
      NULL,
      NULL,
      3,
      8.922577,
      1,
      0,
      13,
      0.274007,
      NULL,
      NULL,
      NULL,
      0.422205,
      5.126207,
      3.039732,
      1.092742,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.640016,
      1,
      0,
      0,
      1,
      0.985519,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1.964810,
      0,
      NULL,
      0.750764,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.197801,
      3.976585,
      1,
      2,
      1,
      0,
      3.353374,
      3.201182,
      NULL,
      1.847842,
      0,
      1,
      NULL,
      0.280275,
      0.212859,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.065710,
      1,
      NULL,
      1.790913,
      1.509915,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.827410,
      NULL,
      1.731168,
      0,
      NULL,
      NULL,
      3.836622,
      NULL,
      0.527480,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9,
      1.427618,
      0,
      0.694142,
      NULL,
      NULL,
      18.919618,
      129.848914,
      2,
      1.820879,
      3,
      '02444',
      '',
      '',
      1.388983,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


