set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9888127';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      7,
      NULL,
      3,
      3.840785,
      4,
      3.381591,
      5,
      NULL,
      '244',
      NULL,
      68.472815,
      54,
      '4123112',
      5.733017,
      0,
      1,
      NULL,
      '0111',
      0.552506,
      0,
      NULL,
      NULL,
      ' 2-14-1985',
      157.988585,
      41.774427,
      NULL,
      0,
      0.631710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158991,
      0.441720,
      2,
      1,
      1,
      NULL,
      1.918495,
      0,
      3,
      0.523203,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.815405,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.630368,
      NULL,
      2,
      3.717182,
      2.477958,
      0,
      0.883931,
      1,
      0,
      1.937666,
      2.044901,
      0.796537,
      0.768404,
      1,
      1,
      1,
      NULL,
      1.285292,
      2.767617,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.719493,
      NULL,
      NULL,
      0,
      1,
      1.638359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.701134,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426614,
      0.811394,
      0.806486,
      0.300978,
      NULL,
      0,
      1,
      NULL,
      1.527327,
      1.203751,
      0.155763,
      0.157338,
      0.891047,
      1,
      0.583121,
      1.402108,
      0,
      0.906714,
      1.574419,
      NULL,
      0.212037,
      NULL,
      0,
      1.450542,
      1,
      1.792413,
      1,
      0,
      5.181583,
      4,
      0,
      0.100934,
      1,
      4,
      0.274846,
      0.418432,
      0,
      2,
      2,
      4,
      0,
      0.315767,
      6,
      2,
      0,
      2,
      NULL,
      0.650194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725531,
      0.366440,
      0,
      0.506346,
      1.183442,
      NULL,
      0,
      0.906759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094673,
      NULL,
      NULL,
      3.209273,
      0,
      5,
      1,
      0,
      0.300394,
      0,
      1,
      1.198257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436481,
      0.973890,
      0,
      4,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0.008841,
      1,
      0.777304,
      NULL,
      0,
      0.156486,
      NULL,
      NULL,
      NULL,
      0,
      1.381828,
      2,
      1,
      0.182194,
      2.396778,
      2.471898,
      3.963117,
      3,
      NULL,
      0,
      3,
      2.537021,
      1,
      4,
      5,
      6,
      1,
      0,
      1,
      NULL,
      0,
      0.464854,
      0.898888,
      0.506717,
      2,
      1.000125,
      0,
      NULL,
      NULL,
      NULL,
      1.581054,
      NULL,
      1.947694,
      2,
      NULL,
      0.718420,
      2,
      0.340451,
      NULL,
      6.732227,
      NULL,
      0.498301,
      2.430458,
      23.345522,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      NULL,
      1.113079,
      1,
      0,
      '00022',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.781619,
      '',
      '',
      '',
      NULL,
      NULL,
      4.789339,
      73.250026,
      0,
      21.728531,
      2,
      0,
      NULL,
      0.488672,
      2,
      3.457248,
      0.789708,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0.077036,
      0.979384,
      NULL,
      NULL,
      0.639972,
      1,
      0,
      NULL,
      NULL,
      2.570645,
      2,
      NULL,
      1.404344,
      1.273689,
      1.675193,
      1.608275,
      0.469897,
      1.600299,
      1,
      3,
      NULL,
      0.109432,
      0.558322,
      0.075264,
      1.339207,
      7,
      2,
      3,
      1.461684,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.725767,
      1.215401,
      NULL,
      NULL,
      0,
      3.555795,
      NULL,
      0.373010,
      1.486094,
      0.052088,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.932169,
      0,
      2,
      NULL,
      NULL,
      2,
      NULL,
      3,
      3.392769,
      1,
      NULL,
      NULL,
      0,
      1.248042,
      0.360701,
      3.037516,
      1,
      1.491989,
      NULL,
      0.428510,
      0.150341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.138203,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      0.156422,
      1.737286,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.371657,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.955886,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      4.071607,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.721801,
      3,
      2,
      NULL,
      1,
      0,
      NULL,
      3.120456,
      3,
      5.421690,
      NULL,
      0,
      NULL,
      0,
      3,
      2,
      3.514377,
      NULL,
      3,
      1.242355,
      0.080981,
      3.572927,
      NULL,
      3.539856,
      4,
      1.756400,
      1,
      0,
      3.687116,
      3,
      4,
      0.704500,
      1.874548,
      1.010788,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.674101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920850,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.210730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866226,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5.790414,
      NULL,
      NULL,
      1.785737,
      1.605389,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.458887,
      NULL,
      NULL,
      NULL,
      1.114531,
      NULL,
      NULL,
      NULL,
      1.843563,
      NULL,
      NULL,
      0.357168,
      0,
      NULL,
      NULL,
      0.247287,
      NULL,
      NULL,
      NULL,
      0.229894,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.282392,
      1,
      NULL,
      NULL,
      1.310361,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.415719,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354570,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      47.294896,
      5.362882,
      2,
      43.080876,
      0.081466,
      NULL,
      NULL,
      NULL,
      NULL,
      38.266860,
      19.026171,
      1,
      NULL,
      NULL,
      0.728805,
      NULL,
      NULL,
      0,
      NULL,
      1.222495,
      0,
      1.281439,
      0,
      0.385942,
      1,
      1.595460,
      NULL,
      NULL,
      0.476480,
      NULL,
      NULL,
      0,
      1.519104,
      NULL,
      0.985400,
      0.636335,
      1,
      1.522809,
      1.177318,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.872333,
      0,
      0,
      NULL,
      NULL,
      0.333158,
      1.827146,
      0.825962,
      4.999488,
      1.892775,
      2.703498,
      3,
      0,
      0,
      1.998716,
      0,
      0,
      0.024201,
      NULL,
      NULL,
      2.932567,
      0.285264,
      0,
      1,
      3.994347,
      NULL,
      2,
      1.820902,
      NULL,
      NULL,
      NULL,
      2.743394,
      1,
      0.274823,
      3,
      NULL,
      1.105521,
      1,
      0.677242,
      NULL,
      2.981375,
      3.594908,
      3.414094,
      3.227084,
      0,
      2,
      3.576886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.832283,
      0.735348,
      0.413717,
      9.299273,
      6,
      7,
      1,
      NULL,
      NULL,
      2.509358,
      55,
      2,
      2,
      1,
      '23301',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.113052,
      '',
      '',
      NULL);
commit;
end;
/


