set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9522082';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '3132001',
      3.154297,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      ' 6- 4-1989',
      126,
      NULL,
      5.316570,
      3.916890,
      5.923074,
      '10-26-1974',
      28,
      NULL,
      140,
      126.311496,
      1.905541,
      ' 7-18-1987',
      ' 0-22-1988',
      ' 8-11-1998',
      1.176059,
      1,
      3.990672,
      NULL,
      1.539910,
      NULL,
      3.481277,
      1,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      26.864172,
      7.068185,
      4,
      0,
      NULL,
      1,
      6,
      1.269287,
      NULL,
      NULL,
      1,
      1,
      1.648710,
      NULL,
      NULL,
      NULL,
      0,
      0.542321,
      2,
      3,
      1,
      1,
      5.006095,
      1.603873,
      0,
      NULL,
      NULL,
      1,
      2,
      2,
      1,
      NULL,
      1.066724,
      0.432755,
      7,
      NULL,
      1,
      NULL,
      0.497650,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.932145,
      NULL,
      0.100830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.883749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448824,
      4.624148,
      0.342489,
      1.832497,
      4,
      3.263019,
      5.448189,
      1.522818,
      0.390632,
      NULL,
      4.873612,
      0,
      0.709028,
      4,
      0,
      0,
      NULL,
      NULL,
      0.550954,
      NULL,
      NULL,
      7.004323,
      3.638496,
      1,
      1,
      3.336260,
      0.064949,
      2,
      1,
      2,
      6,
      1,
      0.159916,
      0,
      1,
      0,
      NULL,
      3,
      4.109948,
      4.036731,
      1.273541,
      NULL,
      4.212129,
      3,
      NULL,
      4.465085,
      3.936240,
      1,
      NULL,
      246,
      ' 6-18-1996',
      NULL,
      NULL,
      0.131366,
      0,
      NULL,
      1.437389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860610,
      1,
      NULL,
      2,
      NULL,
      0.552361,
      3.765014,
      1.436132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0,
      0.884717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.960373,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192899,
      1,
      1,
      1.177543,
      1.107348,
      NULL,
      1,
      NULL,
      7,
      1,
      1.816978,
      NULL,
      NULL,
      NULL,
      0.781814,
      0.019833,
      0.705771,
      1.655643,
      0.277742,
      2.126883,
      3,
      0.563035,
      2.258515,
      NULL,
      0.154066,
      NULL,
      3.534711,
      0.697131,
      0.655353,
      NULL,
      0,
      0,
      1,
      0,
      1.937266,
      1,
      NULL,
      1,
      0.226552,
      NULL,
      1.202970,
      1.629928,
      0,
      1.315851,
      3,
      NULL,
      2.094049,
      6.174709,
      5.070742,
      3.439537,
      4.175844,
      2.708007,
      2,
      1.370897,
      1.485524,
      NULL,
      3.654649,
      0.379871,
      15,
      3,
      NULL,
      NULL,
      8,
      58.462002,
      35.299222,
      3,
      0,
      2.193106,
      '04234',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      45.110559,
      NULL,
      16.980454,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.993885,
      3.619043,
      1.155524,
      NULL,
      NULL,
      0.720893,
      NULL,
      NULL,
      0.163278,
      1.191828,
      1.165986,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.498073,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.544005,
      NULL,
      NULL,
      1,
      4.846466,
      2,
      1.400020,
      0.378241,
      NULL,
      NULL,
      NULL,
      1.728000,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.125724,
      NULL,
      NULL,
      0.945307,
      NULL,
      NULL,
      0.855408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      2,
      2.251689,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.004032,
      0.362448,
      2.274736,
      NULL,
      3,
      2.650911,
      2.106457,
      1.766943,
      1.902123,
      1,
      0.323524,
      1.579453,
      1.894229,
      NULL,
      NULL,
      1.788413,
      NULL,
      NULL,
      0.875393,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.564747,
      NULL,
      NULL,
      0.569291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.121599,
      2,
      1,
      NULL,
      NULL,
      1.016065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.603280,
      NULL,
      NULL,
      0.186017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.199649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.381325,
      0.685009,
      1.326599,
      NULL,
      NULL,
      NULL,
      0.547995,
      1,
      1.886094,
      1.099959,
      0.569758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.027327,
      0,
      1,
      0.566513,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.332688,
      NULL,
      NULL,
      0.591256,
      NULL,
      NULL,
      0.267431,
      NULL,
      NULL,
      1.265350,
      NULL,
      NULL,
      1.438821,
      NULL,
      NULL,
      0.988397,
      NULL,
      NULL,
      599.277026,
      NULL,
      0,
      NULL,
      0.648426,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1.152672,
      0,
      0,
      1.736950,
      0.172859,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.019125,
      1.991880,
      1.831991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341361,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.687978,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.761745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543345,
      2,
      NULL,
      1,
      NULL,
      0.102608,
      NULL,
      NULL,
      NULL,
      0.793773,
      NULL,
      0,
      NULL,
      1.639133,
      NULL,
      0.518975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.224772,
      0.396124,
      NULL,
      2,
      1,
      1.599676,
      2,
      3.923908,
      2.040878,
      NULL,
      0.672748,
      1,
      NULL,
      0.401817,
      NULL,
      NULL,
      0.150662,
      3,
      NULL,
      NULL,
      1.645967,
      NULL,
      1.714937,
      1.570437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180762,
      2.477399,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.971553,
      NULL,
      3.074826,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.290527,
      NULL,
      0.940362,
      NULL,
      0.369736,
      1.630873,
      7.166937,
      NULL,
      NULL,
      NULL,
      103.986758,
      NULL,
      2.588920,
      0,
      1,
      NULL,
      '',
      NULL,
      0.198552,
      '',
      '',
      NULL,
      1.770553,
      '',
      '',
      '');
commit;
end;
/


