set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9425957';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '1302',
      3.624580,
      1.649331,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.477030,
      1.544365,
      3,
      ' 0- 9-1993',
      25.035728,
      NULL,
      3.606063,
      83.508614,
      NULL,
      NULL,
      ' 6- 8-1992',
      NULL,
      NULL,
      3.765069,
      2.950532,
      1.791827,
      NULL,
      NULL,
      NULL,
      1.870348,
      NULL,
      39,
      3.325121,
      NULL,
      5.586708,
      10,
      20.131783,
      6,
      7,
      2,
      3.420067,
      9.043623,
      0,
      1.274228,
      1.172645,
      1.262183,
      0.567192,
      1,
      1.786589,
      1.162006,
      NULL,
      NULL,
      0,
      NULL,
      1.217039,
      5,
      2.644272,
      7.973220,
      NULL,
      4.610987,
      0.562124,
      1.233417,
      3.190220,
      3,
      NULL,
      4,
      NULL,
      2,
      NULL,
      0.493697,
      NULL,
      4.082850,
      0.829862,
      1.293868,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149454,
      1.414771,
      1,
      0.513315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958064,
      0,
      3.032245,
      5.667306,
      0.354734,
      0.634772,
      0.159526,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      9,
      0,
      9.092766,
      2.633418,
      3,
      NULL,
      0,
      11.836214,
      0,
      NULL,
      1.047033,
      2.477852,
      1.714930,
      1.482912,
      NULL,
      1,
      0.965052,
      NULL,
      0.485679,
      1.842652,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      3.603433,
      4.599252,
      0.181647,
      2.925227,
      5,
      4.441929,
      1.619924,
      1.839312,
      6,
      3.491459,
      NULL,
      7.315385,
      NULL,
      0.930256,
      NULL,
      4.853120,
      0.480918,
      0,
      NULL,
      2.891256,
      NULL,
      197.862338,
      ' 5-14-1993',
      NULL,
      NULL,
      1,
      0,
      7,
      0.165973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061925,
      1.136768,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866369,
      NULL,
      2.982535,
      NULL,
      1,
      NULL,
      1.859227,
      0,
      0.007492,
      1.070522,
      NULL,
      3,
      NULL,
      2,
      1.928315,
      NULL,
      0.422760,
      0,
      0.673258,
      NULL,
      NULL,
      3,
      2.229278,
      5,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.772479,
      0,
      0.245379,
      1.274563,
      0.110185,
      1,
      3.594929,
      NULL,
      0.720150,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      3.508299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      4,
      0.161924,
      2.330861,
      NULL,
      0.008533,
      0,
      0.806282,
      NULL,
      NULL,
      NULL,
      0.039039,
      0.954518,
      0,
      0,
      NULL,
      13,
      3.819331,
      0,
      4,
      2,
      3.419251,
      5.995474,
      5,
      6,
      NULL,
      NULL,
      5,
      1.071956,
      0,
      0,
      27.919672,
      NULL,
      2.729543,
      NULL,
      NULL,
      35.480707,
      NULL,
      5,
      5,
      2.167202,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.389381,
      '',
      '',
      NULL,
      2.948610,
      NULL,
      136.880109,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.350557,
      3.221589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599125,
      NULL,
      NULL,
      0.223556,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0.113445,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.508366,
      1.373528,
      5,
      0.912655,
      0.693792,
      NULL,
      NULL,
      NULL,
      1.775913,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.889909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.743102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.283403,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.311422,
      NULL,
      NULL,
      1.895135,
      NULL,
      NULL,
      2,
      1.161850,
      NULL,
      2,
      1.813066,
      2,
      NULL,
      NULL,
      1,
      0.683346,
      NULL,
      NULL,
      0.935191,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.906013,
      0,
      2.547901,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      2,
      3,
      3,
      0,
      1.661105,
      0.654904,
      1,
      0,
      2.668242,
      2,
      2.292467,
      3,
      3.580779,
      2.110524,
      NULL,
      1.530426,
      0.523479,
      2,
      1,
      0.496863,
      1.852798,
      3,
      6,
      1,
      NULL,
      NULL,
      1.831513,
      NULL,
      NULL,
      0,
      NULL,
      1.351326,
      0,
      0.010972,
      0.412654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.315344,
      NULL,
      0.773773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.142118,
      2.321857,
      0.426364,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.083734,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      22,
      6,
      NULL,
      0.187117,
      NULL,
      0.246307,
      0.286008,
      0,
      1.674049,
      NULL,
      1,
      NULL,
      1.857282,
      NULL,
      1.646388,
      0.805023,
      NULL,
      1,
      0,
      1.095698,
      NULL,
      0.901733,
      NULL,
      0.813238,
      NULL,
      1.640859,
      NULL,
      NULL,
      NULL,
      3.437255,
      NULL,
      1.818588,
      NULL,
      9,
      3,
      6,
      1.932669,
      NULL,
      NULL,
      NULL,
      0.530478,
      NULL,
      3.390514,
      NULL,
      NULL,
      NULL,
      0.761946,
      NULL,
      2.725863,
      NULL,
      1.003953,
      NULL,
      0.210224,
      NULL,
      0.120794,
      NULL,
      3.046751,
      NULL,
      0.443817,
      NULL,
      0.727863,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.862381,
      NULL,
      1.950618,
      0.758715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.913471,
      0.712900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867410,
      3,
      NULL,
      0,
      NULL,
      1.325922,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.619446,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.941211,
      NULL,
      9.987940,
      NULL,
      2.198508,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      42,
      27,
      1.874730,
      NULL,
      NULL,
      NULL,
      2,
      1.827831,
      1.723084,
      0.789590,
      4,
      3,
      1,
      2,
      4,
      2.596204,
      NULL,
      1,
      2,
      1,
      NULL,
      3,
      1.834735,
      NULL,
      1.300195,
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      3,
      1.440833,
      NULL,
      1.049094,
      1.166608,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      2.371033,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      0.310618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707486,
      NULL,
      1,
      NULL,
      1.604232,
      4.426306,
      4.675929,
      0,
      NULL,
      NULL,
      107,
      36.565578,
      4.462171,
      4.188854,
      0.155206,
      '42244',
      '13321',
      '',
      0.855661,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


