set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '1143213',
      1.493381,
      1.731993,
      4,
      3,
      '2030',
      NULL,
      1.202513,
      NULL,
      NULL,
      '10-15-1994',
      60,
      NULL,
      5,
      1,
      NULL,
      ' 2- 0-1975',
      44.522097,
      NULL,
      170.164204,
      159,
      2.868989,
      ' 5- 9-1999',
      ' 0-21-1996',
      '10-20-1978',
      3.040929,
      0.237901,
      NULL,
      NULL,
      1.682123,
      1.032706,
      2,
      0,
      NULL,
      NULL,
      NULL,
      6,
      4.379932,
      12,
      26,
      4.324879,
      NULL,
      2.872353,
      2.573234,
      1.392467,
      NULL,
      1,
      0.357125,
      NULL,
      0,
      1,
      1,
      0.895715,
      1.539655,
      2,
      0,
      11.680152,
      2.352922,
      NULL,
      2.375980,
      6,
      1,
      0,
      1.788378,
      1,
      0,
      1.839389,
      8.615728,
      NULL,
      0,
      4,
      0.884132,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      8.302977,
      1.289391,
      1.433272,
      1.845362,
      0,
      2.081098,
      3,
      NULL,
      1.651238,
      3,
      1.256207,
      3,
      NULL,
      0,
      2.771086,
      1,
      1.006639,
      1.804238,
      0,
      1.753184,
      1.221773,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3.095075,
      1.601903,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      0.344937,
      NULL,
      0,
      1,
      4.049935,
      1,
      3.517889,
      1.099004,
      4,
      3,
      0,
      0,
      3,
      1,
      0,
      NULL,
      1,
      5,
      1.437461,
      1,
      5,
      7.185124,
      1,
      0.906262,
      1,
      NULL,
      3.841470,
      1,
      5.045183,
      NULL,
      ' 6-16-1997',
      47,
      ' 7- 0-1974',
      9,
      NULL,
      0.372093,
      1,
      3,
      0.581532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.860266,
      1,
      0,
      0,
      NULL,
      0.189616,
      3.503259,
      2.422327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.128978,
      1,
      3.617570,
      1.519467,
      0,
      0.129983,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.055618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.689605,
      NULL,
      1,
      NULL,
      0.953727,
      2.196353,
      NULL,
      3.654639,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.685771,
      2,
      4.018401,
      3,
      1.858006,
      1,
      NULL,
      NULL,
      1.165417,
      NULL,
      NULL,
      NULL,
      NULL,
      2.886988,
      NULL,
      NULL,
      1,
      4.987193,
      1.019231,
      0,
      1.651429,
      0,
      1,
      0,
      1.965468,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      3.640249,
      7,
      4.585754,
      4.503454,
      2.129533,
      4,
      0,
      NULL,
      2.407950,
      0.814550,
      1.391081,
      53,
      3.155864,
      3,
      NULL,
      45.801987,
      48,
      NULL,
      NULL,
      0.288531,
      NULL,
      '34131',
      '',
      NULL,
      0.096324,
      '',
      '',
      '',
      0.326104,
      NULL,
      '',
      NULL,
      1.878162,
      40,
      112,
      15.662414,
      1.016212,
      NULL,
      3,
      3,
      0,
      0,
      0,
      1,
      0.123760,
      NULL,
      NULL,
      0.144170,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.992549,
      NULL,
      NULL,
      0,
      1,
      1,
      1.681495,
      0,
      0.826607,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434665,
      1,
      1,
      1,
      NULL,
      NULL,
      7,
      5.736859,
      2,
      1.458858,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.961402,
      3,
      NULL,
      NULL,
      0,
      1,
      0,
      0.297341,
      0.632882,
      0,
      NULL,
      NULL,
      1,
      1.897437,
      1.416443,
      0,
      NULL,
      NULL,
      0.334390,
      0.167815,
      NULL,
      3.328333,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3.105098,
      0.881470,
      NULL,
      NULL,
      1.872096,
      NULL,
      NULL,
      0.429159,
      NULL,
      NULL,
      NULL,
      0.482081,
      0,
      1.993731,
      1.879546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.393227,
      NULL,
      NULL,
      0,
      1,
      1.684813,
      3,
      0.835915,
      1,
      1,
      NULL,
      NULL,
      4.236805,
      1,
      0,
      2,
      0.530002,
      0,
      NULL,
      NULL,
      NULL,
      7.750387,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.060904,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.484427,
      1,
      1,
      NULL,
      0.671035,
      1.294107,
      0.500576,
      4.874395,
      3,
      1,
      0.408334,
      NULL,
      NULL,
      2.235308,
      1.493866,
      0.951304,
      3,
      0,
      1.806283,
      0.854789,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.008291,
      1,
      3,
      NULL,
      0.675509,
      2,
      1.936264,
      NULL,
      0,
      2.778831,
      0,
      3.315989,
      7.095405,
      0,
      2,
      NULL,
      1.643629,
      0.315571,
      1.994858,
      3,
      1,
      0.221609,
      0,
      1.424692,
      1.088115,
      0,
      NULL,
      NULL,
      0.464795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293603,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.493009,
      0.739398,
      3.357398,
      1.960935,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      0.995495,
      NULL,
      6.094263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.004491,
      1.142405,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398845,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      0,
      1.217065,
      0,
      NULL,
      3.944141,
      2,
      NULL,
      NULL,
      1.524851,
      0,
      0.504125,
      NULL,
      1.235218,
      1.286578,
      NULL,
      NULL,
      NULL,
      0.370308,
      1.695311,
      NULL,
      0.311633,
      1,
      1,
      NULL,
      7,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      47.281747,
      NULL,
      0,
      3,
      3,
      0.371591,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1.343722,
      1,
      NULL,
      NULL,
      1.440721,
      NULL,
      1.236580,
      1.229170,
      0,
      NULL,
      NULL,
      1.380155,
      0,
      1,
      0,
      0,
      1.132022,
      0,
      1.074678,
      0,
      0,
      0.685109,
      0.113059,
      1.685822,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530801,
      0.690101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661497,
      0.403203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522413,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1.441030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702162,
      NULL,
      0.096431,
      0.483596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092561,
      2.468778,
      NULL,
      NULL,
      0.033637,
      0.155004,
      3,
      4,
      9,
      3,
      1.296825,
      2,
      0.616373,
      1,
      1.004275,
      NULL,
      0,
      0.143403,
      0.320363,
      2,
      0.804885,
      1,
      1.020977,
      NULL,
      0.274873,
      NULL,
      1.081438,
      0,
      1,
      0.204242,
      NULL,
      1,
      1,
      1,
      1.612759,
      NULL,
      1,
      NULL,
      1.020553,
      0,
      NULL,
      1,
      0.992146,
      0.377993,
      NULL,
      1.944140,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946726,
      1,
      1,
      1.252954,
      NULL,
      1.540248,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.567799,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      23.174768,
      0,
      NULL,
      NULL,
      0,
      0,
      0.574163,
      0.240478,
      NULL,
      3,
      NULL,
      3.760699,
      0.042156,
      NULL,
      NULL,
      48.966279,
      112,
      NULL,
      0,
      1.111538,
      '24213',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.927081,
      '',
      '',
      '');
commit;
end;
/


