set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016046';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '2403230',
      1,
      0,
      2,
      NULL,
      '0342',
      0.766787,
      0.107408,
      NULL,
      NULL,
      ' 4-23-1980',
      56.767570,
      NULL,
      NULL,
      1,
      2,
      ' 1- 1-1997',
      9.526172,
      NULL,
      361.731394,
      NULL,
      0.390531,
      ' 6-28-1995',
      '11- 3-1982',
      ' 7-24-1977',
      2.788911,
      2,
      NULL,
      3.253156,
      0,
      1.184636,
      3,
      2.627189,
      NULL,
      NULL,
      NULL,
      4,
      1.147371,
      18,
      1.424794,
      0,
      19,
      1,
      0.336621,
      NULL,
      1.386768,
      0.606801,
      3.842734,
      0,
      0,
      1,
      NULL,
      1.918400,
      NULL,
      1,
      1,
      4,
      3,
      NULL,
      2,
      9.216577,
      0.745078,
      3.573356,
      4.789220,
      1,
      1,
      2,
      1,
      NULL,
      0,
      1.534041,
      0,
      5,
      NULL,
      4.299320,
      4,
      2,
      0,
      NULL,
      NULL,
      0.539313,
      NULL,
      NULL,
      2.861434,
      1,
      0,
      3,
      1.615687,
      0.858125,
      3.710620,
      0.101205,
      0,
      0,
      3,
      1.848165,
      1,
      2.496629,
      1,
      1.973578,
      3,
      1.895975,
      NULL,
      1,
      1,
      3,
      5.606066,
      3.110457,
      0.897665,
      1,
      1.408577,
      NULL,
      NULL,
      0.459598,
      NULL,
      NULL,
      1.023229,
      1.783914,
      0.955410,
      1.312411,
      NULL,
      1,
      5.599019,
      1.309035,
      1.276792,
      0,
      0.591303,
      0,
      0.639999,
      7.227598,
      0.128224,
      1,
      0.757452,
      1,
      1.105364,
      NULL,
      NULL,
      0,
      0,
      NULL,
      4.003822,
      1.019440,
      2,
      9.816728,
      2,
      1,
      8.857772,
      4.666784,
      3,
      5,
      NULL,
      9.164267,
      1,
      NULL,
      4,
      0.426806,
      11.551015,
      1.150211,
      NULL,
      3.710235,
      5.866328,
      1.127088,
      1.004674,
      0,
      NULL,
      61,
      NULL,
      2,
      1,
      NULL,
      1.906723,
      7.225456,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.140648,
      2.232673,
      6,
      1.794820,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058163,
      NULL,
      0,
      3.010899,
      2.279838,
      8,
      NULL,
      1.898564,
      2,
      2.408517,
      7,
      1,
      1.501324,
      0,
      NULL,
      0,
      2,
      0.743376,
      0,
      4.445342,
      6,
      0.039050,
      5.736975,
      3.414427,
      NULL,
      NULL,
      NULL,
      0.561423,
      9,
      1.153733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.450900,
      NULL,
      1,
      0,
      NULL,
      0.999008,
      0.132098,
      3,
      4.209732,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.959000,
      0.588526,
      1.011041,
      0.910979,
      3,
      4.775660,
      NULL,
      4,
      1,
      2,
      5.022760,
      1.026614,
      5,
      0,
      3.665980,
      0,
      1,
      1,
      0,
      4.321300,
      1,
      0.954732,
      1.203188,
      NULL,
      0.011592,
      NULL,
      NULL,
      1.618656,
      0,
      0.648996,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      5.414469,
      0,
      1,
      NULL,
      6.552162,
      NULL,
      NULL,
      2.197182,
      NULL,
      2.818912,
      1.188847,
      NULL,
      12.926318,
      4.270953,
      NULL,
      4,
      0.525923,
      3,
      '04013',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.868546,
      NULL,
      NULL,
      NULL,
      1.482232,
      NULL,
      NULL,
      1.662944,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641571,
      NULL,
      1,
      1,
      1.912299,
      0.109501,
      1,
      NULL,
      1,
      1,
      1.661775,
      NULL,
      0.101415,
      0.827071,
      1.427852,
      0,
      1.173833,
      1.173414,
      1.577285,
      1.132286,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.836837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385102,
      1.102781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.344600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.081445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.560663,
      1.733258,
      0,
      NULL,
      NULL,
      NULL,
      1.404601,
      1,
      0,
      NULL,
      1.655579,
      1,
      1.096171,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.552197,
      NULL,
      2.730513,
      8.977222,
      0.993401,
      NULL,
      2.689319,
      2,
      10,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.283576,
      0.282815,
      NULL,
      NULL,
      1,
      NULL,
      3.802061,
      1.853218,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.169623,
      1.003997,
      NULL,
      2.262770,
      1.473465,
      NULL,
      NULL,
      3.190975,
      NULL,
      0,
      1,
      1.465519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.135974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.283830,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.344527,
      1.151765,
      0.663404,
      '11214',
      '',
      NULL,
      1.280739,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


