set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5713594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '3103021',
      2,
      NULL,
      0,
      1,
      '4402',
      1,
      1.698040,
      NULL,
      NULL,
      ' 3- 3-1996',
      58,
      NULL,
      NULL,
      1.278321,
      0.618025,
      ' 6-29-1977',
      17,
      0,
      195.536064,
      NULL,
      1.242357,
      ' 4-26-1987',
      ' 8- 6-1992',
      ' 1- 9-1987',
      NULL,
      3,
      NULL,
      1,
      0.958240,
      1.993808,
      1.626630,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      13.582561,
      13,
      NULL,
      14,
      5,
      9,
      4.435126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.107328,
      0,
      0.560908,
      0.051406,
      1,
      1,
      0.931357,
      1,
      1.041048,
      0.709670,
      0,
      1.269500,
      0.617068,
      0,
      NULL,
      0,
      0.997157,
      5.330716,
      0.412672,
      2.344269,
      0,
      NULL,
      NULL,
      3.558996,
      1,
      NULL,
      11,
      0.508076,
      1,
      0.826432,
      1.665515,
      0.538831,
      1.868925,
      0.349307,
      NULL,
      2,
      1,
      0,
      NULL,
      2.026276,
      0.354735,
      NULL,
      1.699889,
      2,
      0,
      1.737412,
      NULL,
      4,
      0,
      1,
      1.933708,
      2,
      NULL,
      NULL,
      NULL,
      3.910786,
      3,
      0.092011,
      NULL,
      6.457928,
      9.695786,
      NULL,
      NULL,
      1.611308,
      1.264365,
      1.462664,
      1,
      1,
      4,
      1,
      1.223618,
      3,
      0.013521,
      0,
      0,
      0.260256,
      1.563002,
      NULL,
      1.377989,
      3,
      0,
      NULL,
      5,
      NULL,
      0.137767,
      7.271906,
      7.917439,
      0,
      0.204146,
      7,
      9.899519,
      6,
      NULL,
      2.279351,
      2.706684,
      2.569787,
      2.476847,
      2.806831,
      6,
      2,
      1.124982,
      8.922619,
      1.771858,
      NULL,
      2,
      1.492788,
      ' 3-18-1975',
      637.727548,
      ' 3-20-2000',
      112,
      NULL,
      0.108435,
      NULL,
      4,
      1.542261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.985646,
      0.809391,
      NULL,
      1,
      0,
      1.389153,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      10,
      0,
      NULL,
      1.901779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.049666,
      0,
      1.206406,
      1.444481,
      3,
      3,
      8,
      NULL,
      2,
      3,
      4,
      4,
      4,
      0,
      NULL,
      NULL,
      1.078093,
      8.290365,
      3.431833,
      3,
      NULL,
      4,
      5,
      ' 3-10-2000',
      714.202199,
      ' 8- 1-1975',
      95.359213,
      0,
      0,
      1,
      3,
      NULL,
      0.623220,
      0,
      1,
      NULL,
      0,
      3.644638,
      25.568650,
      1.004995,
      1,
      NULL,
      NULL,
      NULL,
      2.641884,
      NULL,
      0.400612,
      0,
      2,
      3.583333,
      0,
      0.170340,
      1,
      0.711631,
      NULL,
      3,
      1,
      2,
      NULL,
      1,
      4.761913,
      2,
      0.978673,
      2.427112,
      1,
      0.439367,
      0.118300,
      1,
      1,
      0.916596,
      1,
      0.060600,
      0.992925,
      0.591967,
      5,
      NULL,
      3,
      8,
      5.780228,
      0.646695,
      NULL,
      NULL,
      3,
      NULL,
      6.102708,
      1.275627,
      NULL,
      1.791290,
      13.053506,
      3.477026,
      1,
      NULL,
      40,
      23,
      NULL,
      3,
      0.213062,
      4.793240,
      '11244',
      '30421',
      '',
      0,
      '',
      '',
      '',
      5.581910,
      '34032',
      '24334',
      '',
      NULL,
      3,
      378,
      31.937242,
      1.255762,
      21,
      4,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.460541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224385,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.983257,
      NULL,
      NULL,
      1.800174,
      NULL,
      NULL,
      8.642198,
      3.599360,
      2,
      1.187006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.277520,
      1,
      2,
      0,
      0,
      1.589673,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.066639,
      1.288953,
      2,
      3,
      1.844494,
      3,
      2.147222,
      1.176820,
      0,
      0.541632,
      0.770090,
      1.745022,
      1.571363,
      2.766266,
      2,
      1.605126,
      NULL,
      NULL,
      1.552529,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.453018,
      NULL,
      6.081054,
      1,
      0.437581,
      NULL,
      NULL,
      NULL,
      2.603065,
      1,
      0.532989,
      0,
      1.503753,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.525809,
      NULL,
      NULL,
      1.843758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652740,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808357,
      1.039422,
      1,
      0,
      NULL,
      NULL,
      0.471142,
      0.271711,
      NULL,
      9.456768,
      2.839467,
      6,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.660102,
      NULL,
      0.521119,
      1.223483,
      0,
      0,
      6.264786,
      0.731603,
      6,
      2,
      1,
      2,
      2.034212,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      1.998679,
      3.070805,
      3,
      1.374066,
      1.021082,
      NULL,
      0.996935,
      1,
      NULL,
      1,
      5.890028,
      1.743280,
      0,
      0,
      0.623237,
      0.617536,
      2.765784,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338883,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.060358,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.128117,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.369567,
      NULL,
      NULL,
      3.430871,
      3.686242,
      NULL,
      NULL,
      1.255718,
      1,
      0,
      NULL,
      NULL,
      4.449605,
      NULL,
      99,
      NULL,
      166.566353,
      NULL,
      3.439229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.246726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831979,
      NULL,
      0.140761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.534697,
      NULL,
      1.213069,
      NULL,
      0,
      NULL,
      0.681841,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.869861,
      NULL,
      NULL,
      NULL,
      2.907476,
      NULL,
      1.245020,
      NULL,
      0.744344,
      NULL,
      3,
      NULL,
      2,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.358973,
      13.033145,
      6.040255,
      2,
      103.612227,
      11,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.777410,
      0.407404,
      NULL,
      NULL,
      0.154125,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      1,
      0,
      1.332814,
      0,
      0.017550,
      0.967469,
      1,
      1,
      1,
      0.515490,
      0,
      NULL,
      NULL,
      NULL,
      0.746811,
      1,
      1.888768,
      2.875704,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.964845,
      31.952792,
      14.358127,
      1.960970,
      0.617423,
      NULL,
      NULL,
      0.130070,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.898572,
      NULL,
      1.924004,
      NULL,
      0.556687,
      NULL,
      1.001319,
      NULL,
      1.285962,
      NULL,
      0.795685,
      NULL,
      1.636049,
      NULL,
      1,
      NULL,
      1.479316,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.479344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.356163,
      0.443814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.833752,
      NULL,
      NULL,
      NULL,
      0.719348,
      NULL,
      2,
      NULL,
      0.837381,
      NULL,
      0.232264,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.843388,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.640766,
      NULL,
      0.769217,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.935502,
      2,
      NULL,
      1,
      0.857019,
      3,
      1.729742,
      NULL,
      18.908914,
      0.664086,
      1,
      1,
      1.467668,
      0,
      NULL,
      0.609298,
      NULL,
      NULL,
      0.128430,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.497952,
      2,
      NULL,
      NULL,
      1.558942,
      NULL,
      0.651731,
      1,
      NULL,
      0.617066,
      NULL,
      NULL,
      0,
      0.862365,
      NULL,
      0.365861,
      0,
      NULL,
      0,
      1.962556,
      NULL,
      NULL,
      0,
      0.320058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.188447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      13,
      NULL,
      1.528306,
      2.569851,
      41.559045,
      27.778483,
      5,
      0.934835,
      NULL,
      '31041',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '01322',
      '22300',
      '');
commit;
end;
/


