set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      NULL,
      4.133182,
      2.113185,
      2,
      0.884349,
      2.423723,
      1.956552,
      '100',
      '01234123',
      22.821179,
      63,
      '3221143',
      2,
      NULL,
      3,
      NULL,
      '2113',
      NULL,
      0.250960,
      NULL,
      NULL,
      ' 1- 0-2002',
      NULL,
      19,
      NULL,
      1.122844,
      1.083993,
      ' 1-16-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 2- 6-1990',
      ' 0-10-1986',
      '11- 8-1994',
      1,
      3.861301,
      3.628928,
      1,
      1,
      0.391965,
      NULL,
      1.548938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.664482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.614380,
      2.473909,
      1,
      3.133785,
      2,
      NULL,
      0,
      2.388995,
      0,
      1.680946,
      NULL,
      1.449208,
      0.490485,
      1,
      NULL,
      1.769463,
      0.186611,
      1,
      2,
      1.319375,
      2.360256,
      0.590754,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.230626,
      NULL,
      3.313915,
      1,
      0.289974,
      2,
      2,
      2,
      1.451151,
      NULL,
      NULL,
      3,
      1.485517,
      NULL,
      NULL,
      1,
      0.449083,
      NULL,
      0,
      0.839030,
      0.268477,
      2.990608,
      0.500996,
      3.396018,
      4.275640,
      1.163926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.446378,
      NULL,
      2.450716,
      6,
      3.103717,
      NULL,
      0.172577,
      0,
      0.258127,
      1,
      0.102989,
      7,
      0,
      1,
      1.776042,
      1,
      1.948034,
      NULL,
      0.736567,
      0,
      1.773813,
      5.164590,
      0,
      2.618794,
      0.744979,
      0,
      0,
      NULL,
      NULL,
      1,
      3.431194,
      NULL,
      1.938529,
      0.336712,
      2.225589,
      1,
      0,
      4,
      NULL,
      3,
      NULL,
      7,
      0,
      0,
      NULL,
      2,
      NULL,
      3008,
      NULL,
      1896.057935,
      2.297435,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298938,
      0,
      NULL,
      NULL,
      1,
      2,
      1.109689,
      1.193872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.632869,
      NULL,
      2.767442,
      1,
      0.427503,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.363098,
      6,
      1,
      3.250306,
      0,
      NULL,
      NULL,
      NULL,
      1.668993,
      3,
      1.669312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.527871,
      1,
      0,
      0,
      3.605467,
      1.106856,
      1,
      0,
      0.794765,
      0.062332,
      0.503810,
      NULL,
      NULL,
      NULL,
      0,
      1.588883,
      2.716497,
      3,
      3,
      NULL,
      3,
      NULL,
      0.190357,
      0,
      3.343983,
      3,
      1,
      1,
      NULL,
      2.188442,
      0,
      NULL,
      0,
      5.481963,
      0.305314,
      0,
      0.021580,
      0.422568,
      0.039485,
      1,
      0,
      0.497877,
      1,
      3.789097,
      2.286060,
      0.866713,
      6,
      6,
      6,
      10.540276,
      0,
      5.506447,
      2.574652,
      3.356825,
      2,
      3.815115,
      2.281548,
      NULL,
      35.546334,
      0,
      0,
      43.751670,
      NULL,
      42.338153,
      27.931710,
      1,
      1.489525,
      NULL,
      '42413',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.722115,
      '',
      NULL,
      '',
      NULL,
      44,
      399.987443,
      10,
      1,
      25.460892,
      3,
      80.134646,
      NULL,
      NULL,
      NULL,
      0.466434,
      0,
      NULL,
      NULL,
      NULL,
      2.172828,
      0,
      3.364834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.283058,
      0,
      1,
      1,
      3.632667,
      2,
      0.834299,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.039914,
      1,
      0,
      0.202543,
      0.234020,
      1,
      2.800495,
      1,
      1,
      7,
      5,
      6.073375,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.710032,
      NULL,
      NULL,
      NULL,
      3,
      0.172983,
      2,
      NULL,
      0.674097,
      3.939287,
      3.097129,
      NULL,
      1.186081,
      1,
      0.076675,
      NULL,
      2,
      1.515229,
      0,
      1.867118,
      NULL,
      1,
      2.275049,
      2.681790,
      1.230270,
      1.034366,
      2,
      0,
      3.269909,
      1.009300,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.896476,
      4.142024,
      8.990698,
      4,
      1.552376,
      1.188992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436653,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.974815,
      NULL,
      2.484573,
      NULL,
      NULL,
      4.843919,
      2,
      0.604920,
      2.152779,
      0,
      NULL,
      NULL,
      5.789215,
      4,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0.369382,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.969668,
      NULL,
      1.397763,
      NULL,
      0,
      1.757982,
      1,
      NULL,
      NULL,
      3,
      0.382192,
      0.807384,
      1,
      0.231147,
      3.797377,
      9,
      3.968480,
      1,
      0,
      NULL,
      NULL,
      3.955028,
      0.858728,
      1,
      NULL,
      3,
      NULL,
      3.373195,
      1.743440,
      0.899869,
      5.761821,
      5,
      0.227740,
      0,
      1.930430,
      0,
      1,
      3.588975,
      0.261495,
      2.675766,
      2.565398,
      2,
      0.093164,
      3,
      0.294148,
      5,
      2,
      5,
      0,
      NULL,
      NULL,
      1.100735,
      0.362162,
      9.423243,
      1.297348,
      1.156297,
      0,
      1,
      1,
      2.220958,
      NULL,
      NULL,
      0.006988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095031,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.173434,
      NULL,
      NULL,
      1.708945,
      0,
      3,
      1,
      1.078896,
      1,
      NULL,
      NULL,
      NULL,
      3.464297,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.935812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.711769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.501867,
      NULL,
      NULL,
      NULL,
      0.977890,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.390629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.836280,
      NULL,
      NULL,
      NULL,
      0.751585,
      3,
      NULL,
      NULL,
      0,
      254,
      50,
      1,
      97,
      2.306146,
      1.569211,
      NULL,
      NULL,
      1,
      NULL,
      13.052796,
      NULL,
      47.844510,
      9,
      0.917203,
      NULL,
      NULL,
      0.143273,
      NULL,
      1,
      NULL,
      1.132498,
      1,
      0,
      0,
      0,
      1.040283,
      1,
      0,
      NULL,
      0.050535,
      0.504034,
      1,
      1,
      1.203295,
      1.658962,
      0.895678,
      0,
      0.058160,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422909,
      0.525501,
      0.874492,
      0.295166,
      0.043704,
      0.845881,
      0.590582,
      NULL,
      1.119413,
      3,
      0.111301,
      0,
      NULL,
      NULL,
      1.066052,
      1,
      NULL,
      0,
      1.666369,
      NULL,
      NULL,
      1.575316,
      NULL,
      0,
      1.723540,
      NULL,
      1.051130,
      1,
      NULL,
      0.359310,
      1.947098,
      NULL,
      0,
      1,
      NULL,
      0.181552,
      NULL,
      NULL,
      0,
      1.436275,
      NULL,
      NULL,
      0.909992,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445552,
      NULL,
      0.855849,
      NULL,
      1,
      NULL,
      NULL,
      1.522717,
      0,
      0.752346,
      NULL,
      NULL,
      30,
      NULL,
      0,
      NULL,
      1.557910,
      '01342',
      NULL,
      '',
      1.664024,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL);
commit;
end;
/


