set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8313515';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6,
      2,
      NULL,
      0,
      5.564630,
      2.003434,
      NULL,
      7.225274,
      '204',
      '01023104',
      NULL,
      3,
      '0141024',
      NULL,
      0.121278,
      3,
      2,
      '2011',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      6.516692,
      51.785529,
      NULL,
      NULL,
      3,
      ' 3- 9-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 0-22-1982',
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0.820183,
      3.821915,
      NULL,
      NULL,
      NULL,
      11,
      10.087730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.459861,
      NULL,
      NULL,
      NULL,
      0.281017,
      0,
      1,
      1.582709,
      0,
      NULL,
      NULL,
      1.747583,
      1,
      NULL,
      5,
      1.375854,
      0,
      6,
      1.922235,
      1,
      1.284513,
      1.449048,
      0.476653,
      2,
      1.721319,
      NULL,
      NULL,
      1,
      4,
      NULL,
      0.378779,
      4.555793,
      0.719146,
      1.038414,
      0.097834,
      NULL,
      NULL,
      0.239604,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2.447970,
      2,
      1.096417,
      3,
      NULL,
      3,
      1,
      1.815375,
      2.666903,
      2,
      1,
      1.428167,
      0.848532,
      3,
      1,
      1.776004,
      0.222327,
      1,
      1.519324,
      5,
      1,
      2,
      1.431025,
      0,
      NULL,
      NULL,
      1.268579,
      NULL,
      NULL,
      NULL,
      5.468532,
      NULL,
      1.303552,
      4,
      1.859615,
      0,
      1,
      NULL,
      0.917153,
      0,
      1.076594,
      0.971183,
      5,
      NULL,
      0,
      1,
      1.328058,
      1.588843,
      NULL,
      0,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      0.618659,
      3,
      NULL,
      NULL,
      7,
      0,
      4,
      2.989178,
      0,
      3.576612,
      3,
      3,
      0.737003,
      NULL,
      1.448483,
      1,
      NULL,
      1,
      9.471713,
      NULL,
      2.324853,
      ' 0- 9-1981',
      0.602401,
      NULL,
      NULL,
      3,
      3.900422,
      NULL,
      NULL,
      1.533649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492671,
      1.746254,
      1.768200,
      1.239958,
      NULL,
      1.905172,
      1.840929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.048542,
      NULL,
      7,
      0,
      3.544271,
      0.013290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.156685,
      4.259125,
      2.186002,
      1,
      1.774686,
      0,
      5.831871,
      NULL,
      NULL,
      NULL,
      1.830140,
      0.095963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.731134,
      NULL,
      0.003125,
      0.501735,
      NULL,
      0.699576,
      NULL,
      NULL,
      NULL,
      0.701426,
      NULL,
      NULL,
      NULL,
      3,
      1.164405,
      2,
      NULL,
      1,
      1,
      NULL,
      0.179749,
      NULL,
      1.998645,
      NULL,
      2.021608,
      NULL,
      2,
      NULL,
      NULL,
      3.250940,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.744203,
      1.583159,
      0.695359,
      1.646832,
      1.028978,
      2,
      NULL,
      1,
      NULL,
      2.305731,
      1.961036,
      7,
      7,
      2,
      NULL,
      2,
      1,
      3.858612,
      3.437779,
      44,
      3,
      3,
      11.156071,
      NULL,
      15.927014,
      24,
      0.822688,
      1.594184,
      1,
      '03242',
      '02202',
      '',
      2.886922,
      '24422',
      '',
      NULL,
      0.991765,
      '',
      '',
      '',
      1,
      23,
      1.522727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.406142,
      0.880144,
      NULL,
      3.175644,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.450064,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      881.866478,
      8,
      1,
      0.825593,
      0.184163,
      0,
      1,
      1.194259,
      0,
      NULL,
      2,
      0.232209,
      3.597474,
      NULL,
      0,
      1,
      1,
      1.065868,
      3.725770,
      1.844766,
      NULL,
      NULL,
      2,
      NULL,
      0.606602,
      NULL,
      3,
      NULL,
      3,
      NULL,
      80.200028,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.333173,
      0.716411,
      NULL,
      1.962182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.878307,
      NULL,
      1.594461,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.842095,
      NULL,
      0.933389,
      NULL,
      1.094004,
      NULL,
      1.273473,
      0.055242,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419670,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315976,
      1,
      NULL,
      NULL,
      1.001673,
      NULL,
      403,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.199959,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      3.213999,
      NULL,
      405,
      NULL,
      0,
      NULL,
      0.585708,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.340028,
      1.651570,
      1.888504,
      NULL,
      0.383769,
      NULL,
      40,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.622544,
      1.251200,
      19.293735,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.230957,
      4.900820,
      0.478660,
      0.453949,
      4,
      3.794900,
      NULL,
      0.594956,
      NULL,
      1,
      1.874874,
      1.034362,
      NULL,
      0,
      0,
      NULL,
      1,
      1.874484,
      NULL,
      1,
      0.659887,
      NULL,
      NULL,
      0.223921,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.498481,
      0.688106,
      NULL,
      0.576519,
      NULL,
      NULL,
      3.491179,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1.322093,
      0.891449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.054486,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.294423,
      1,
      NULL,
      NULL,
      32.788844,
      38,
      5,
      NULL,
      4,
      '14222',
      '32012',
      '44222',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


