set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9921354';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      1.360067,
      NULL,
      3.827050,
      NULL,
      3.612361,
      5.520143,
      0.298785,
      '330',
      '33331103',
      82,
      9,
      '0432311',
      0.785928,
      NULL,
      6,
      2,
      '4330',
      4,
      NULL,
      NULL,
      NULL,
      ' 0-27-1981',
      NULL,
      36.750194,
      NULL,
      3,
      0,
      ' 5-12-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-11-1983',
      ' 0-13-1993',
      ' 4- 7-1995',
      2.497872,
      0.169797,
      NULL,
      3.695110,
      1,
      0.211230,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.106391,
      0.637731,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1.549099,
      1.159561,
      1,
      1.697989,
      0,
      3,
      NULL,
      1.292223,
      0,
      NULL,
      0.001239,
      1.741144,
      NULL,
      1.905169,
      2,
      5,
      0,
      1,
      NULL,
      3.557405,
      1.658727,
      0,
      0.827201,
      0.979437,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.747090,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744761,
      0.323732,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.469086,
      0,
      8,
      0,
      1,
      1.119768,
      0,
      7.857808,
      6,
      NULL,
      1.827740,
      0,
      0,
      1,
      1,
      0,
      0.289477,
      NULL,
      0.065083,
      0.457972,
      NULL,
      1.657043,
      0,
      0,
      1,
      4.042061,
      0,
      7.208476,
      1,
      1.122480,
      1.847550,
      0.315179,
      NULL,
      1,
      3.306605,
      1,
      7,
      5.867783,
      4.105484,
      3,
      2,
      5,
      4,
      0,
      7,
      3,
      '11-19-1981',
      2,
      '10- 6-2001',
      NULL,
      1,
      5,
      1,
      1,
      2,
      NULL,
      2,
      1.346357,
      1.405102,
      1.198995,
      1.834248,
      2.356571,
      2,
      2,
      NULL,
      1,
      7.347234,
      3.823879,
      0,
      7.288174,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.957331,
      0,
      2,
      3.592278,
      2.564391,
      NULL,
      NULL,
      0,
      0,
      0.077779,
      0.098078,
      3.207098,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.489747,
      1.972328,
      0.729148,
      3.551317,
      0.425177,
      NULL,
      2,
      0.480944,
      0.107572,
      0.860758,
      NULL,
      NULL,
      NULL,
      0.440281,
      NULL,
      3,
      3.400890,
      2.108387,
      1.837721,
      NULL,
      NULL,
      2,
      0.089923,
      0,
      1.313634,
      NULL,
      2.069703,
      1.000109,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0.001226,
      1.011442,
      NULL,
      1,
      NULL,
      0,
      0,
      2.464109,
      1,
      11,
      0.456461,
      NULL,
      8.060365,
      2.905800,
      7.487575,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.834362,
      17.603486,
      2,
      0,
      50,
      NULL,
      40.638105,
      29,
      2,
      3,
      NULL,
      '14441',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      NULL,
      0,
      25.789314,
      26.580988,
      28,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.899183,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.972483,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.395255,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.326872,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900319,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.039327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.618092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954420,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.609907,
      NULL,
      NULL,
      1.306485,
      NULL,
      NULL,
      1.213928,
      NULL,
      NULL,
      1.000062,
      NULL,
      NULL,
      1.060346,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420454,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.257823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.092769,
      NULL,
      NULL,
      0.667624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.460917,
      0.587977,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.211806,
      2,
      3.804581,
      1.960448,
      NULL,
      1,
      7,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      NULL,
      NULL,
      1.082249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.501189,
      NULL,
      NULL,
      NULL,
      2.511615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.404993,
      NULL,
      NULL,
      NULL,
      0.309888,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.826194,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.691525,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.629512,
      NULL,
      NULL,
      NULL,
      3.728155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469918,
      NULL,
      NULL,
      NULL,
      3,
      3.640652,
      NULL,
      3,
      0,
      2.629452,
      0.386430,
      NULL,
      NULL,
      1.368203,
      NULL,
      NULL,
      0,
      0.915845,
      NULL,
      0,
      NULL,
      NULL,
      0.308606,
      NULL,
      0.261228,
      227.369008,
      7,
      1,
      NULL,
      0.293623,
      1.610380,
      0,
      1.385699,
      2,
      0,
      1.931948,
      1.006177,
      1.168589,
      1.642715,
      1,
      0.851160,
      0.947608,
      0,
      0,
      NULL,
      0.723405,
      NULL,
      0.967538,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.732859,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.133095,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.788523,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.687004,
      NULL,
      NULL,
      0.452317,
      0.434150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.619103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659991,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665022,
      1,
      NULL,
      NULL,
      2.966633,
      NULL,
      81.684810,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.036673,
      NULL,
      33,
      0,
      0.273349,
      NULL,
      NULL,
      NULL,
      0.393674,
      NULL,
      2,
      0.886569,
      NULL,
      1.904447,
      2,
      2,
      3,
      3.775564,
      1.668730,
      1,
      NULL,
      1.707268,
      0,
      1,
      0.804735,
      NULL,
      0,
      NULL,
      1.740374,
      0.467889,
      1.607254,
      1.102326,
      1.550450,
      3.505692,
      3,
      1.827633,
      1.986784,
      NULL,
      1.314350,
      3,
      NULL,
      1.029724,
      1.581518,
      1,
      0,
      NULL,
      0.568196,
      1.125362,
      3.945260,
      1.400981,
      1.280992,
      0.462141,
      0.919619,
      0,
      0,
      0.083244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835370,
      1,
      1,
      0,
      NULL,
      1.957674,
      0.602707,
      0.795095,
      NULL,
      0,
      NULL,
      NULL,
      55.864355,
      122,
      2,
      NULL,
      4,
      '41003',
      '00121',
      '04303',
      0,
      '',
      '',
      '',
      0.808156,
      '',
      '',
      NULL);
commit;
end;
/


