set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9336131';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      2.115943,
      1.869434,
      0,
      0,
      '3321',
      2.054361,
      0,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      4.790113,
      NULL,
      1,
      NULL,
      67.387521,
      1.231563,
      296.184704,
      104,
      1,
      '11- 1-1976',
      NULL,
      ' 1- 4-1984',
      3.528484,
      3,
      2,
      0.188379,
      2.229173,
      2,
      7,
      1.682270,
      0,
      3,
      NULL,
      8.040138,
      9,
      NULL,
      1,
      7.502935,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1.629212,
      1,
      0,
      1.315081,
      NULL,
      1.125595,
      1.844321,
      NULL,
      NULL,
      NULL,
      1,
      2.448586,
      2,
      2.278871,
      9,
      1.461775,
      1.443851,
      NULL,
      2.884138,
      1,
      7,
      0.755435,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.198822,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.592693,
      1.401113,
      0.456125,
      0,
      0,
      0,
      1.883504,
      NULL,
      1.362785,
      NULL,
      1,
      1,
      1,
      1,
      0.365628,
      0,
      1,
      NULL,
      5,
      1,
      1.253221,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.638731,
      0,
      NULL,
      NULL,
      0.450905,
      1,
      0,
      1,
      0.485471,
      5.680644,
      1.715058,
      1.336062,
      3,
      NULL,
      1.940495,
      0.239845,
      0,
      0,
      NULL,
      NULL,
      0.284676,
      NULL,
      0.453229,
      1.324440,
      0.235603,
      1,
      0.321323,
      0.889383,
      1.404839,
      1,
      NULL,
      1,
      1.832257,
      6,
      5,
      4,
      0.887586,
      NULL,
      2.769598,
      8,
      5,
      NULL,
      NULL,
      0,
      NULL,
      0.191003,
      2,
      ' 9-22-1990',
      1529.725222,
      ' 9-26-1985',
      NULL,
      3.027655,
      3.549881,
      0,
      3,
      1,
      NULL,
      1.241812,
      0,
      NULL,
      3,
      5.058511,
      3,
      1.398765,
      NULL,
      2.851731,
      5.412615,
      3,
      3,
      1.726599,
      1,
      1.062291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      NULL,
      1.474472,
      4,
      1.380631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.526286,
      0.085118,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.622677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.273733,
      1.367118,
      1.426394,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143373,
      1.920365,
      NULL,
      1.536741,
      2.160212,
      4.974470,
      0,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      1.421084,
      1.097724,
      NULL,
      0,
      1.425155,
      0,
      1.510676,
      3.658920,
      NULL,
      0,
      1,
      0.829541,
      1,
      NULL,
      0.593205,
      NULL,
      0,
      4.264058,
      NULL,
      1,
      8,
      NULL,
      2.564976,
      4,
      5.628781,
      4,
      NULL,
      6.914517,
      0.727159,
      3.303972,
      2,
      9.618165,
      2.877536,
      2.068697,
      NULL,
      NULL,
      30,
      54,
      NULL,
      2.454297,
      3,
      '31300',
      NULL,
      '',
      0.875763,
      '',
      NULL,
      '',
      2.172502,
      '44340',
      NULL,
      '03204',
      1,
      8.978336,
      270,
      3.313079,
      3,
      39,
      NULL,
      0,
      2,
      2.458566,
      NULL,
      NULL,
      0.611572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.507735,
      3.846149,
      0.827967,
      NULL,
      0.701628,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.293088,
      NULL,
      NULL,
      0.027192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.333164,
      0,
      NULL,
      NULL,
      NULL,
      0.637852,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.678826,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1.330725,
      2,
      0.313622,
      NULL,
      0,
      NULL,
      NULL,
      2.249586,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.852835,
      1.248334,
      2.940904,
      0.770118,
      0.456791,
      NULL,
      1,
      0,
      NULL,
      NULL,
      6.883146,
      1,
      2,
      3.781197,
      0.205840,
      2.234786,
      1.493412,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469519,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.925708,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.199196,
      1,
      NULL,
      1.956599,
      NULL,
      NULL,
      3.259098,
      1.120707,
      2,
      NULL,
      NULL,
      NULL,
      4,
      3.683920,
      NULL,
      0.074387,
      1.533998,
      0.609612,
      0.589083,
      NULL,
      1.165069,
      3.313290,
      1.885169,
      0.279564,
      NULL,
      3.997714,
      NULL,
      1.263008,
      2,
      5,
      0,
      NULL,
      NULL,
      2.810325,
      0,
      5.875325,
      1.369141,
      NULL,
      1.922603,
      NULL,
      1.671850,
      0.309691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.730001,
      NULL,
      NULL,
      1.864225,
      NULL,
      NULL,
      4.907523,
      NULL,
      NULL,
      NULL,
      1,
      0.252030,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      3.366416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.487977,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.994993,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.283206,
      NULL,
      3,
      1,
      1.333084,
      NULL,
      NULL,
      NULL,
      1.048780,
      NULL,
      NULL,
      1.182669,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.284909,
      NULL,
      1.821125,
      603.017191,
      42.870021,
      1,
      1.040394,
      1.887736,
      NULL,
      0.619632,
      NULL,
      1,
      0,
      0,
      2,
      0.001178,
      2.702741,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.353198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289943,
      NULL,
      0.160506,
      NULL,
      70.456572,
      NULL,
      2,
      NULL,
      41,
      0.562776,
      1,
      NULL,
      NULL,
      3.769050,
      NULL,
      1.958621,
      NULL,
      0.755629,
      NULL,
      1.210544,
      NULL,
      2.092590,
      NULL,
      2.224818,
      NULL,
      1.850705,
      NULL,
      1.749744,
      NULL,
      1,
      NULL,
      0.359635,
      NULL,
      0.023934,
      NULL,
      1.633228,
      NULL,
      0.095982,
      NULL,
      NULL,
      0,
      1.902778,
      1.990260,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.549034,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.197468,
      0.418675,
      2,
      NULL,
      0.237988,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516651,
      NULL,
      NULL,
      NULL,
      0.887528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687234,
      3.182528,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.265681,
      NULL,
      0.731148,
      NULL,
      0.558165,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.542823,
      NULL,
      0.396907,
      NULL,
      1.013826,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.697070,
      3.673426,
      1.997591,
      0,
      NULL,
      NULL,
      1.435893,
      0.172276,
      0.809425,
      NULL,
      1.729900,
      1,
      1.623211,
      1.596786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      NULL,
      1.556415,
      2.526507,
      NULL,
      2.834884,
      0.081175,
      0,
      0.498018,
      1,
      NULL,
      0.548053,
      2,
      NULL,
      0.615816,
      0.965828,
      NULL,
      NULL,
      1.397020,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      NULL,
      1.761945,
      NULL,
      NULL,
      0.174785,
      1.229509,
      NULL,
      1,
      2,
      NULL,
      0.377997,
      2.594586,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      1.090634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.016571,
      0.311820,
      NULL,
      NULL,
      NULL,
      60,
      NULL,
      6,
      1.296235,
      3,
      '24413',
      '21142',
      '',
      NULL,
      '',
      NULL,
      NULL,
      1,
      NULL,
      '14012',
      NULL);
commit;
end;
/


