set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531891';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '4201141',
      NULL,
      0,
      6,
      0,
      '3011',
      2.875225,
      0.966293,
      NULL,
      NULL,
      ' 0-13-2001',
      4,
      NULL,
      3,
      1.569919,
      1.103748,
      NULL,
      3,
      3.126943,
      NULL,
      28,
      0,
      NULL,
      ' 6-26-1975',
      NULL,
      2.073045,
      0.395611,
      NULL,
      0,
      0,
      2.386938,
      2,
      1.059030,
      0,
      2,
      11,
      NULL,
      3.931918,
      0,
      8,
      3,
      9.273105,
      2.096211,
      NULL,
      7,
      NULL,
      2,
      0,
      NULL,
      1,
      0.022268,
      0,
      NULL,
      1.731541,
      NULL,
      1,
      1.826096,
      3.703004,
      3,
      NULL,
      9,
      0.549453,
      2.102305,
      3,
      0,
      2.624515,
      6,
      5,
      NULL,
      2,
      2,
      5.679323,
      1.011950,
      NULL,
      4,
      1.235425,
      0,
      1.694220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.628562,
      1,
      1,
      0.357743,
      1.608720,
      0,
      0.216366,
      NULL,
      0.277068,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      1.009872,
      1.849227,
      2.804856,
      0,
      0,
      0,
      NULL,
      1.763936,
      0,
      2.989094,
      0.390396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.547995,
      0.872388,
      6,
      0,
      2.467910,
      0,
      1,
      5.668683,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0.653257,
      NULL,
      2,
      5.206429,
      2.431370,
      0.628349,
      NULL,
      1,
      2,
      1.539675,
      1.470432,
      4.826579,
      4,
      3.830576,
      1.115090,
      5,
      1,
      1.361598,
      NULL,
      4,
      3.438633,
      2,
      NULL,
      0,
      3.457977,
      0,
      0.287037,
      2.638557,
      5.766834,
      0,
      ' 3- 8-1992',
      34.463090,
      ' 5- 1-1980',
      7.032254,
      1,
      0.989788,
      1.467386,
      NULL,
      0.566223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418461,
      0,
      2.483937,
      0,
      NULL,
      0,
      3.355820,
      1.606379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.300007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677051,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.048416,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735581,
      0.389735,
      1,
      0,
      NULL,
      1.925798,
      0.635197,
      38,
      2.143885,
      1.321917,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      3,
      0,
      2,
      0.451602,
      1,
      3.257643,
      1.319606,
      2.449825,
      NULL,
      0.736354,
      3,
      3,
      NULL,
      1,
      0.883918,
      0.235388,
      0.695952,
      0,
      1,
      1,
      0,
      1,
      0.310467,
      1,
      0,
      13,
      0.133474,
      1,
      6,
      1.367758,
      7,
      2,
      0.190070,
      3,
      2,
      0.359096,
      NULL,
      3,
      3,
      NULL,
      65,
      0,
      1,
      NULL,
      11.118736,
      11.364537,
      25.767136,
      4,
      5.381669,
      1,
      '41312',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      3.728633,
      NULL,
      23,
      3.665830,
      1,
      22.227322,
      0,
      NULL,
      4.497397,
      2.895665,
      NULL,
      2.375761,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.843187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661994,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2,
      1.080920,
      2,
      1,
      3,
      NULL,
      1.370738,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.082111,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.726529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.603037,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.101296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088893,
      NULL,
      NULL,
      1,
      2.513947,
      1,
      2.817886,
      2.788481,
      0.990595,
      0.028750,
      NULL,
      NULL,
      2.861979,
      0.576033,
      2.831078,
      0,
      1,
      NULL,
      2.764645,
      2,
      0.030953,
      NULL,
      5,
      4,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.137397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790650,
      NULL,
      NULL,
      0.320109,
      NULL,
      NULL,
      2.754483,
      2.502280,
      2.312388,
      3.827412,
      1.631177,
      3,
      3,
      0,
      7.290027,
      6.347574,
      2.933391,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675731,
      0.513058,
      2.345604,
      1.185339,
      0,
      3.244651,
      NULL,
      3,
      3,
      1,
      0,
      1.231728,
      NULL,
      3.641461,
      2,
      3,
      0.394053,
      2.219910,
      1.060225,
      NULL,
      NULL,
      NULL,
      8.687518,
      4.104335,
      4,
      1.033192,
      1.613727,
      NULL,
      NULL,
      NULL,
      0,
      1.087287,
      0,
      0.034063,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830082,
      NULL,
      NULL,
      1.523939,
      NULL,
      NULL,
      3.971472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811508,
      0,
      0.325019,
      1.854176,
      1.462573,
      1.732121,
      0.788877,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.543769,
      NULL,
      NULL,
      NULL,
      3.827040,
      NULL,
      NULL,
      NULL,
      0.614990,
      NULL,
      NULL,
      NULL,
      1.124727,
      NULL,
      NULL,
      NULL,
      1.934363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.275564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.479137,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9.598889,
      NULL,
      NULL,
      NULL,
      0.946634,
      0.137654,
      5.615297,
      1.706570,
      1.626014,
      1.687853,
      0.619841,
      NULL,
      1.347406,
      NULL,
      0.232048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719552,
      NULL,
      NULL,
      0.076732,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1.165009,
      1.289626,
      1.991851,
      NULL,
      0,
      1,
      0.970068,
      0.549437,
      0.492097,
      1,
      0,
      0,
      1,
      1.470923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.227082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.532092,
      0,
      0,
      0,
      3.431699,
      0,
      6.023236,
      2,
      0.789604,
      0,
      1.254074,
      0.579042,
      NULL,
      1.965359,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0.744271,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      0.415661,
      0,
      NULL,
      0.908836,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.517896,
      NULL,
      0.805848,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770674,
      NULL,
      1,
      NULL,
      0.969883,
      NULL,
      5.255838,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      18.629689,
      NULL,
      2,
      2,
      1.118991,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.130577,
      '',
      '',
      '');
commit;
end;
/


