set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8106369';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.815998,
      NULL,
      6,
      NULL,
      0.420140,
      1.943278,
      NULL,
      0,
      '033',
      '02320421',
      50,
      8,
      '0223240',
      2.228351,
      1.515029,
      2,
      2,
      '1213',
      5.513093,
      0.611611,
      NULL,
      NULL,
      ' 1-20-1997',
      3.589917,
      NULL,
      NULL,
      3.013366,
      0,
      ' 8- 9-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 5-1990',
      '10-21-1976',
      NULL,
      1,
      0.029699,
      0,
      1,
      1.830553,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      0.958242,
      0,
      1,
      NULL,
      0,
      0.325026,
      1,
      3,
      0.678188,
      0.029646,
      1,
      1,
      NULL,
      3.866649,
      3,
      7.023218,
      0,
      0,
      NULL,
      0,
      0.279594,
      NULL,
      1,
      1,
      0.836213,
      1.550127,
      0,
      8,
      1,
      4.156973,
      2.947962,
      0.947081,
      1.578869,
      NULL,
      NULL,
      1.142107,
      NULL,
      NULL,
      5,
      0.757740,
      1,
      1.668204,
      1.700799,
      NULL,
      2.279857,
      0.144692,
      1,
      3,
      3,
      0.370306,
      0.294758,
      NULL,
      1.000653,
      0,
      1,
      2.428937,
      2.097423,
      1.873824,
      1.108552,
      1.634671,
      1.222155,
      0,
      4,
      2.975783,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      4,
      0,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      0.766427,
      4,
      1.978195,
      7,
      1,
      NULL,
      1,
      0,
      1.015422,
      NULL,
      1,
      5,
      0.142854,
      5,
      1,
      5.192128,
      7.859196,
      NULL,
      7,
      2.716964,
      5,
      NULL,
      3,
      NULL,
      4.909517,
      5.682916,
      4.950291,
      8.838125,
      6.629470,
      5.432088,
      1,
      4,
      NULL,
      5,
      2.921686,
      5.583589,
      0,
      3,
      NULL,
      23.026963,
      ' 1-25-1975',
      NULL,
      3.543440,
      1,
      1.766801,
      7.779469,
      0.855975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042350,
      NULL,
      NULL,
      2,
      7.963351,
      2.323938,
      NULL,
      0.206249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.754764,
      NULL,
      5,
      0,
      1,
      3.544832,
      0.334216,
      1,
      2,
      1.562501,
      0.045434,
      3,
      1.713614,
      3.061989,
      3,
      3.884961,
      3.110596,
      4.481520,
      1,
      6.216361,
      1,
      0,
      NULL,
      3.187831,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488846,
      3,
      1.335293,
      1.748327,
      0.036017,
      NULL,
      1,
      0.192339,
      20,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.590634,
      1,
      2.988558,
      3.985011,
      NULL,
      NULL,
      NULL,
      0.407317,
      3.440346,
      0.120488,
      2.326294,
      3,
      2.122437,
      NULL,
      0,
      1,
      1,
      0,
      1.395488,
      1.475897,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.309241,
      0.586000,
      NULL,
      NULL,
      0.804482,
      NULL,
      6.099199,
      NULL,
      5.001618,
      1,
      0.000631,
      6.164184,
      NULL,
      3,
      2.139662,
      1,
      1,
      3,
      58,
      2,
      2.048588,
      43,
      NULL,
      4.149982,
      18.182581,
      5,
      NULL,
      2,
      '13341',
      '21243',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      20.435346,
      28.139702,
      NULL,
      1.198327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.295169,
      2.522729,
      0.405813,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.702837,
      3,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.116894,
      NULL,
      NULL,
      0,
      0.989355,
      0.462926,
      NULL,
      0.178538,
      3,
      3.262310,
      0.774000,
      0.979585,
      2,
      2,
      2.427318,
      0,
      NULL,
      NULL,
      1.350834,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1.060453,
      0.300710,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      0.232750,
      0.882585,
      NULL,
      NULL,
      0,
      0.046898,
      NULL,
      3,
      NULL,
      2.285297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796128,
      NULL,
      NULL,
      1.143666,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.304461,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.612307,
      NULL,
      NULL,
      2,
      NULL,
      1.664585,
      NULL,
      NULL,
      NULL,
      3.326641,
      2.137692,
      4.332354,
      2,
      5,
      0,
      0.112947,
      NULL,
      NULL,
      3,
      1.435360,
      2.650085,
      2,
      3,
      1,
      2,
      3,
      NULL,
      1.172975,
      1,
      5.119350,
      0,
      3.195914,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      3.594344,
      NULL,
      1.314459,
      3,
      6,
      4,
      7.013192,
      2.946993,
      0.919666,
      NULL,
      1.894966,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.964226,
      NULL,
      0,
      NULL,
      NULL,
      0.210929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834534,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.731117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.163753,
      NULL,
      NULL,
      20,
      2,
      0,
      NULL,
      0.997480,
      1,
      0.780283,
      0,
      1.070826,
      0.644707,
      1,
      0.629871,
      1.699776,
      0.181962,
      0.257584,
      NULL,
      NULL,
      NULL,
      1,
      1.312033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072573,
      1,
      0.112792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.716448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.727752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.443112,
      0.459062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987834,
      0.452871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      26.688333,
      NULL,
      0.597898,
      NULL,
      NULL,
      NULL,
      3,
      0,
      5.858510,
      2.361606,
      NULL,
      2,
      5,
      2,
      13,
      0.653035,
      NULL,
      0.107185,
      1,
      1.565091,
      NULL,
      3.385626,
      NULL,
      NULL,
      1.163719,
      2,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1.934802,
      NULL,
      1,
      2.215634,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.547628,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      2,
      NULL,
      0,
      1,
      0.216229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.807085,
      NULL,
      0.508749,
      NULL,
      NULL,
      9.704217,
      9,
      0,
      NULL,
      NULL,
      29,
      13,
      3.411262,
      NULL,
      1,
      '12221',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


