set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8620424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '1422311',
      1.236694,
      1.667349,
      NULL,
      3,
      '4042',
      2.039629,
      1,
      NULL,
      NULL,
      ' 8- 3-1984',
      8,
      NULL,
      4,
      2,
      6.612765,
      '11- 3-1998',
      29.391087,
      NULL,
      NULL,
      38.466801,
      3,
      '10-13-1974',
      ' 4- 7-1993',
      NULL,
      0.163458,
      0,
      NULL,
      1.813062,
      0,
      1,
      1.616096,
      3.551493,
      NULL,
      NULL,
      NULL,
      4.735621,
      2,
      NULL,
      13,
      5,
      14,
      3,
      1,
      5.577209,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1.617422,
      7.586589,
      1.973517,
      1.129528,
      0,
      NULL,
      0.610318,
      1,
      5.514727,
      NULL,
      0,
      7.918280,
      4.213987,
      NULL,
      0.658865,
      0,
      3,
      1.701291,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      1,
      3,
      1,
      0,
      1,
      0,
      1.156136,
      2,
      0,
      3.203935,
      NULL,
      1,
      0,
      0.585625,
      0,
      0,
      NULL,
      1.528094,
      NULL,
      2,
      NULL,
      0.501644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.378591,
      5,
      3.787329,
      1,
      1,
      9,
      2,
      1.295204,
      1.186477,
      1.851517,
      0.560666,
      1,
      1.131267,
      0,
      1.435800,
      0.612171,
      1,
      0.006900,
      NULL,
      1.717091,
      NULL,
      3.353632,
      0,
      2.675765,
      0,
      NULL,
      3,
      1.761019,
      6.125287,
      0.970610,
      0,
      4,
      7,
      1,
      7.589947,
      1.738865,
      8,
      9.216968,
      0.685720,
      2,
      2.335649,
      4,
      4.619820,
      NULL,
      1,
      NULL,
      1,
      '11- 9-2002',
      NULL,
      ' 8-12-1974',
      6,
      1,
      1,
      0.572435,
      3.946846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.116368,
      4.448775,
      3,
      1.770879,
      5,
      1.239717,
      1.333177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.181118,
      1.695680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.089974,
      0,
      0,
      0.554297,
      3,
      1.448151,
      5,
      3,
      0,
      3.045109,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614136,
      NULL,
      0,
      1,
      0.023107,
      0.397508,
      0,
      2,
      22,
      0.090919,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.754552,
      NULL,
      2.087503,
      NULL,
      1,
      0,
      0,
      3,
      1.623990,
      NULL,
      2,
      3,
      3,
      NULL,
      1.973098,
      3.931549,
      1.896868,
      NULL,
      0.796016,
      0,
      0,
      1.215377,
      0,
      0.514783,
      0.836228,
      NULL,
      1.989525,
      0.062772,
      0.539271,
      2.553375,
      0,
      5.412329,
      2.963054,
      0.905661,
      4.275056,
      7,
      0.498707,
      4.911268,
      0.925483,
      NULL,
      NULL,
      1.560140,
      1,
      49,
      4.851840,
      2,
      NULL,
      41,
      29,
      20,
      3,
      1,
      NULL,
      '42241',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '02401',
      '',
      NULL,
      3,
      NULL,
      1.045881,
      4,
      0,
      20.042993,
      6.497536,
      2.900104,
      4.152954,
      1.546824,
      NULL,
      3,
      0.583678,
      0.661074,
      1.361340,
      2.550098,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.346924,
      0.431096,
      NULL,
      NULL,
      NULL,
      0.702649,
      0.205570,
      3.789143,
      0.208665,
      NULL,
      NULL,
      1.243344,
      1.529224,
      NULL,
      1,
      0,
      1,
      6.472597,
      8,
      NULL,
      0,
      1.584960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.174347,
      2,
      3,
      NULL,
      0,
      2.513127,
      0.046475,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.203052,
      0,
      NULL,
      1,
      0.427449,
      NULL,
      3.606638,
      NULL,
      3.209695,
      1.243377,
      0,
      0,
      1.459677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.708021,
      NULL,
      3,
      0.828755,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.412121,
      NULL,
      3.762173,
      1,
      0,
      0,
      NULL,
      NULL,
      5,
      0,
      1,
      0,
      1.715536,
      1,
      1.902651,
      NULL,
      NULL,
      2.589755,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.313486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941063,
      NULL,
      NULL,
      1.841313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.387611,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      5,
      1,
      4,
      1.683155,
      NULL,
      NULL,
      NULL,
      1.762331,
      0,
      2.787986,
      0,
      2.185909,
      0,
      2,
      NULL,
      1.036132,
      7,
      NULL,
      NULL,
      3,
      0.232646,
      1.761374,
      1.519665,
      0.634129,
      3.437283,
      NULL,
      3,
      NULL,
      NULL,
      3,
      1.106118,
      NULL,
      NULL,
      6.524810,
      NULL,
      0.823608,
      5,
      0,
      NULL,
      2,
      0,
      1.569064,
      1.940467,
      1,
      0.942451,
      3.966720,
      NULL,
      NULL,
      1.027699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668209,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.109932,
      NULL,
      NULL,
      1.768418,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.724339,
      NULL,
      NULL,
      0.631663,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.690160,
      NULL,
      NULL,
      1.207434,
      1.396733,
      3.486118,
      0.135122,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.826457,
      NULL,
      NULL,
      NULL,
      1.233700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.428967,
      1.683987,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.064875,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.302167,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.700028,
      1.804495,
      NULL,
      NULL,
      0.908998,
      3.262601,
      NULL,
      NULL,
      1.422310,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.435076,
      NULL,
      NULL,
      NULL,
      0.392445,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      NULL,
      0.067698,
      3,
      3,
      0.640178,
      4,
      2.338817,
      1.607656,
      NULL,
      NULL,
      0.600698,
      1,
      0,
      0,
      NULL,
      NULL,
      1.434532,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      308,
      6,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.484871,
      1,
      0,
      1,
      0.432817,
      1.269600,
      NULL,
      0.604498,
      1,
      0.950814,
      0.177452,
      2,
      NULL,
      0.939798,
      NULL,
      1.699548,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.002636,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.873064,
      NULL,
      3.401918,
      NULL,
      0.949231,
      0,
      1.858785,
      2,
      3.778840,
      1.157929,
      NULL,
      2,
      3,
      NULL,
      1.146148,
      0.740763,
      1,
      1,
      NULL,
      0.645051,
      0,
      1.220039,
      1,
      1,
      0.349453,
      NULL,
      1.661558,
      1.341040,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3.287925,
      1,
      NULL,
      0.235092,
      1,
      0,
      3.770108,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.285985,
      0,
      1.837623,
      NULL,
      5,
      7,
      5.692745,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.205985,
      0.959921,
      NULL,
      NULL,
      '',
      NULL,
      0.671437,
      '',
      NULL,
      '',
      1.701917,
      '41003',
      '',
      '');
commit;
end;
/


