set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935013';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '2213130',
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      1.317087,
      NULL,
      NULL,
      ' 7-19-1974',
      3,
      NULL,
      NULL,
      0.440293,
      NULL,
      ' 7-11-1978',
      1.540807,
      5,
      161,
      17.497274,
      NULL,
      NULL,
      ' 8-28-1989',
      NULL,
      2,
      3.006277,
      1,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.745145,
      16.683029,
      NULL,
      4.298621,
      13.759383,
      2.335340,
      0,
      5.896584,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328846,
      2.910003,
      0,
      2,
      NULL,
      0.093236,
      0.397762,
      NULL,
      0.390700,
      1,
      1.135667,
      0,
      2,
      1.369595,
      1.915759,
      4,
      NULL,
      2,
      0.415102,
      0,
      1.516869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.547294,
      2.475018,
      1,
      0,
      0.278797,
      1.886863,
      NULL,
      0.016145,
      NULL,
      0,
      0.117582,
      1.966575,
      0,
      1.343479,
      0,
      1,
      NULL,
      0,
      1.190985,
      1.734848,
      4.769170,
      2.768850,
      2.862521,
      3,
      0.583334,
      NULL,
      NULL,
      0.812719,
      NULL,
      NULL,
      1,
      7.998429,
      0.682813,
      NULL,
      0.086882,
      NULL,
      1,
      1.831004,
      3,
      2,
      3.396015,
      1.701381,
      1.612276,
      2,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      7.488568,
      5,
      0,
      4.786018,
      0.187392,
      NULL,
      6.796521,
      1,
      7,
      NULL,
      7,
      1,
      NULL,
      NULL,
      3.544554,
      NULL,
      5,
      1.645839,
      0,
      0.645056,
      6,
      1.416692,
      7.708223,
      4.592265,
      0.843016,
      0.835497,
      0.214038,
      ' 8- 7-1979',
      401,
      '11- 5-2003',
      93.620529,
      0.562870,
      0,
      0,
      0,
      0.349239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.961494,
      1.833960,
      1.235348,
      0,
      1.658540,
      0.926858,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.952105,
      1.345810,
      7.761930,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.557229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1.452145,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.061738,
      3,
      NULL,
      3.618815,
      3,
      3.192156,
      0.448084,
      NULL,
      1.474591,
      3.552045,
      2.792399,
      NULL,
      2.115688,
      NULL,
      1.769769,
      0,
      1,
      1.170794,
      5.613284,
      0,
      NULL,
      0.105941,
      0,
      0.393815,
      0.186194,
      0.747626,
      0,
      0,
      0.471905,
      2,
      NULL,
      5,
      6.730888,
      6.743293,
      3,
      NULL,
      2.125457,
      5,
      1,
      6,
      0,
      2.041487,
      0.867138,
      NULL,
      2,
      NULL,
      NULL,
      84.584279,
      0.463817,
      75.476437,
      3.061250,
      1,
      2.800330,
      '11022',
      '',
      '',
      0.472814,
      '',
      '',
      NULL,
      1.661096,
      NULL,
      NULL,
      NULL,
      0.777929,
      34.547693,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.936705,
      0,
      0.621896,
      NULL,
      NULL,
      1.797849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526844,
      NULL,
      NULL,
      0.410715,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.739956,
      5.173246,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.837945,
      NULL,
      NULL,
      NULL,
      1,
      1.061957,
      2,
      1,
      NULL,
      NULL,
      0.619092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143817,
      0,
      NULL,
      0.926602,
      1,
      0.607884,
      1,
      0.296332,
      NULL,
      0.486559,
      1.810325,
      NULL,
      1.738463,
      1.913022,
      NULL,
      NULL,
      3,
      0.778578,
      NULL,
      1,
      NULL,
      NULL,
      5.801814,
      0.006951,
      1.636171,
      NULL,
      1.579823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.401095,
      0,
      3,
      0,
      NULL,
      0.896167,
      2,
      1,
      0.359230,
      6.662126,
      3.574925,
      3,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      4.262653,
      4.014165,
      3,
      0,
      NULL,
      NULL,
      0.494328,
      NULL,
      NULL,
      1.626681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232468,
      NULL,
      NULL,
      1.555957,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      1.365058,
      0,
      NULL,
      5.006098,
      4.589940,
      1,
      NULL,
      3.382661,
      0,
      5,
      1.012512,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.609526,
      6,
      4,
      5.188904,
      NULL,
      NULL,
      1,
      0,
      1.986578,
      0,
      NULL,
      NULL,
      2,
      3.714587,
      2.040192,
      3,
      1.547597,
      NULL,
      NULL,
      5.664565,
      1.785132,
      1.188944,
      2.370253,
      2,
      NULL,
      1,
      0.935194,
      1.554522,
      1,
      1.068524,
      2.768225,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.144501,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.200953,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.522717,
      NULL,
      NULL,
      0.424630,
      NULL,
      NULL,
      NULL,
      1.826959,
      1,
      0,
      0.546599,
      0,
      1,
      NULL,
      NULL,
      1.431107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.120324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.059256,
      NULL,
      NULL,
      NULL,
      1.852070,
      NULL,
      NULL,
      NULL,
      3.246562,
      NULL,
      NULL,
      NULL,
      0.538520,
      NULL,
      NULL,
      NULL,
      0.382149,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271312,
      NULL,
      NULL,
      NULL,
      3,
      3.731372,
      1.261495,
      NULL,
      NULL,
      NULL,
      1.616921,
      NULL,
      NULL,
      0.372287,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.877113,
      NULL,
      NULL,
      0.242424,
      NULL,
      0,
      277,
      15,
      0.743465,
      1,
      0,
      1.525293,
      0,
      0.234390,
      0,
      0,
      1,
      0,
      1.881477,
      NULL,
      1,
      0.487556,
      1.214965,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.778515,
      1.864012,
      1.223098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.324769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.553419,
      0,
      NULL,
      1.712524,
      NULL,
      1.520681,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.410925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413439,
      NULL,
      0,
      NULL,
      0,
      0.566773,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.984478,
      NULL,
      1.285950,
      0,
      2.642052,
      0,
      9.188921,
      1.473819,
      2,
      0.557424,
      NULL,
      1.578126,
      NULL,
      NULL,
      0.048987,
      NULL,
      0.184987,
      0.482471,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.552519,
      1,
      NULL,
      1.188779,
      0,
      NULL,
      1,
      1,
      NULL,
      0.164091,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.042970,
      NULL,
      2.878666,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.004853,
      NULL,
      0,
      NULL,
      0.457918,
      NULL,
      1.614686,
      0.404392,
      NULL,
      NULL,
      19.366008,
      97.986344,
      1.196561,
      0,
      2,
      '40022',
      '',
      '',
      1.516983,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


