set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9223985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '4443011',
      0.916336,
      1.528926,
      3,
      2,
      '2042',
      3,
      1.420512,
      NULL,
      NULL,
      ' 2-12-1984',
      NULL,
      NULL,
      NULL,
      1.214454,
      1.682920,
      NULL,
      114,
      NULL,
      156,
      46,
      3,
      NULL,
      NULL,
      ' 6- 8-1986',
      2.461920,
      3.363560,
      2,
      NULL,
      1,
      0,
      2,
      1,
      1.157069,
      962.583943,
      4.473854,
      11,
      5,
      102.210402,
      12.912901,
      13,
      8.291855,
      6.537032,
      0.471682,
      NULL,
      0,
      1,
      0.092602,
      1,
      0,
      1,
      NULL,
      NULL,
      1.667262,
      0.423621,
      62.011850,
      NULL,
      7.433311,
      NULL,
      2.458840,
      1.793763,
      NULL,
      6,
      NULL,
      1,
      0,
      1.901929,
      0.216150,
      1.796978,
      1.372533,
      3.826963,
      1,
      7,
      0.092725,
      0,
      0,
      1,
      1.717702,
      NULL,
      NULL,
      3.835067,
      3,
      2.460886,
      2.681538,
      3,
      NULL,
      NULL,
      0,
      1,
      1.560748,
      1,
      NULL,
      1.385550,
      NULL,
      0,
      0,
      1.823069,
      0,
      1.323815,
      NULL,
      0.909101,
      0,
      NULL,
      0.713491,
      NULL,
      0.476801,
      NULL,
      0,
      3.668710,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.583646,
      0,
      NULL,
      0,
      0,
      NULL,
      0.823753,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0.974036,
      0,
      1,
      0.183972,
      0,
      0,
      NULL,
      NULL,
      7.432512,
      1.463970,
      NULL,
      0,
      NULL,
      7.771478,
      8,
      4.441633,
      1.430564,
      NULL,
      4.376400,
      8.050646,
      4.827915,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      10.835790,
      2,
      11.694876,
      NULL,
      3,
      6.797736,
      0.131789,
      1,
      NULL,
      NULL,
      NULL,
      1289,
      2.211158,
      0,
      0,
      NULL,
      0.052504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.112296,
      0,
      0.219762,
      NULL,
      NULL,
      0.098859,
      0.526159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449149,
      NULL,
      13,
      1.890960,
      1.563930,
      NULL,
      0.938415,
      1.991514,
      2.081729,
      NULL,
      43.911840,
      0.714904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      7,
      0,
      9.119942,
      0.031021,
      NULL,
      NULL,
      NULL,
      1.554778,
      10,
      NULL,
      NULL,
      5,
      3,
      8,
      NULL,
      NULL,
      NULL,
      1985.169809,
      NULL,
      0,
      1.442964,
      0,
      2,
      1.383589,
      1.723400,
      0.279568,
      0.255478,
      NULL,
      1.877920,
      13389.646313,
      0.717039,
      0,
      NULL,
      1511.540266,
      1837.379332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      '01211',
      NULL,
      '11331',
      1.703346,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      NULL,
      3.775009,
      40.894262,
      NULL,
      6,
      0.402977,
      9.622070,
      26,
      15.832467,
      10.426722,
      1,
      NULL,
      NULL,
      0.168490,
      NULL,
      NULL,
      NULL,
      0.457369,
      3.438523,
      3,
      1.378075,
      0.983816,
      1.618962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.081735,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.926753,
      NULL,
      3.116507,
      NULL,
      NULL,
      1,
      5,
      7.381361,
      1,
      0.072182,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.511789,
      1,
      1.388465,
      0,
      1.601514,
      NULL,
      NULL,
      NULL,
      2,
      3.746165,
      0.699212,
      1,
      1,
      0,
      0.217474,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.251089,
      NULL,
      NULL,
      5.038297,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.173101,
      NULL,
      NULL,
      NULL,
      1.039551,
      NULL,
      NULL,
      1.458894,
      3,
      2.112758,
      2,
      1,
      NULL,
      0.204626,
      NULL,
      NULL,
      4,
      2,
      NULL,
      3.844514,
      0,
      1.477402,
      NULL,
      NULL,
      NULL,
      3.199972,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.470007,
      NULL,
      2,
      1.544414,
      NULL,
      NULL,
      7.744298,
      7,
      NULL,
      6.946227,
      4.772055,
      9.153419,
      0,
      NULL,
      NULL,
      3.082145,
      0,
      2.173378,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.963475,
      NULL,
      6.756800,
      NULL,
      1.966980,
      0.255302,
      1,
      0,
      1.859475,
      3.689427,
      3,
      1.287937,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.004630,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.324499,
      NULL,
      0,
      1.146887,
      0,
      0.666470,
      NULL,
      NULL,
      1.908052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.996847,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.038710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.204960,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438999,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.494825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.528517,
      NULL,
      NULL,
      NULL,
      1.264912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.056172,
      NULL,
      NULL,
      NULL,
      2.537134,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      1.169937,
      NULL,
      3,
      0.224444,
      386.292051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.446342,
      14184.254024,
      67,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0.338918,
      1.902064,
      0.061791,
      0.345678,
      0.871834,
      0,
      0,
      1.420843,
      0.308231,
      3.057389,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.821255,
      NULL,
      1,
      NULL,
      1,
      NULL,
      204,
      NULL,
      3.809613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.809777,
      NULL,
      8,
      3.285370,
      2,
      1.980939,
      3,
      1,
      3,
      NULL,
      NULL,
      0.420359,
      18,
      NULL,
      0.445790,
      NULL,
      NULL,
      0,
      13,
      NULL,
      1,
      8,
      NULL,
      0,
      7.768807,
      NULL,
      0.573885,
      4.072942,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678318,
      2,
      NULL,
      1.013435,
      9.868454,
      NULL,
      0.328698,
      6.204288,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.103660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.520515,
      NULL,
      1,
      NULL,
      5.024116,
      3.839591,
      9.354059,
      3,
      1.999874,
      3,
      14.646531,
      NULL,
      NULL,
      2.490594,
      5.903877,
      NULL,
      '20202',
      NULL,
      1.469003,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


