set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '4040233',
      0.292785,
      NULL,
      2,
      0,
      NULL,
      0.633371,
      0.021827,
      NULL,
      NULL,
      ' 9-27-1985',
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 5-1999',
      NULL,
      NULL,
      92.647020,
      40.757237,
      2.049284,
      ' 1-11-1998',
      ' 2-16-1978',
      ' 4-12-1984',
      1,
      1,
      1,
      1,
      1.798957,
      NULL,
      3.106298,
      1.694777,
      NULL,
      115.161534,
      10,
      NULL,
      5,
      21,
      8.669815,
      0.190801,
      27,
      7,
      0,
      4.197760,
      0,
      NULL,
      NULL,
      NULL,
      0.808076,
      0.412257,
      1.915375,
      1.139427,
      1,
      NULL,
      0.759611,
      3,
      NULL,
      4,
      1,
      9.209895,
      1,
      0,
      1,
      3.542157,
      1,
      7,
      4.002447,
      6.755249,
      5.045656,
      3.884704,
      1.540594,
      11,
      1,
      NULL,
      1,
      0.119956,
      0.339519,
      NULL,
      NULL,
      0.116612,
      NULL,
      NULL,
      10.365405,
      0.830975,
      2,
      NULL,
      1,
      NULL,
      1,
      1.792306,
      3,
      3,
      NULL,
      1.720038,
      1.291944,
      0.232125,
      1,
      NULL,
      0,
      0.496039,
      NULL,
      2.671292,
      0.040751,
      NULL,
      NULL,
      0,
      3.052320,
      1,
      1,
      NULL,
      NULL,
      0.739071,
      NULL,
      NULL,
      1,
      0,
      8,
      1,
      NULL,
      2,
      2.156555,
      0.097333,
      0.008385,
      1,
      9.414756,
      NULL,
      3,
      0.727719,
      0,
      0,
      0,
      1,
      0.647999,
      NULL,
      1,
      NULL,
      1,
      0.393988,
      0,
      3,
      1.159486,
      5,
      7.830179,
      3,
      2,
      5.937514,
      4,
      5,
      1,
      NULL,
      NULL,
      NULL,
      11.943855,
      7.451987,
      2,
      NULL,
      5,
      1.842400,
      6,
      0.764486,
      NULL,
      0.639193,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549862,
      1.625152,
      0,
      0,
      1.575279,
      3,
      NULL,
      NULL,
      1.975821,
      0,
      0,
      0,
      7,
      10,
      1.378036,
      NULL,
      2.740781,
      1.635285,
      1,
      5.078733,
      1.607503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.650687,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.971747,
      1.629654,
      8,
      NULL,
      NULL,
      9.863202,
      3,
      NULL,
      NULL,
      NULL,
      0.679561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.800141,
      0,
      NULL,
      0,
      1,
      0.483480,
      NULL,
      3,
      5.100394,
      3.319683,
      1,
      NULL,
      NULL,
      NULL,
      0.127449,
      0,
      NULL,
      0,
      3.379055,
      2.106211,
      1,
      2,
      5.574960,
      2,
      NULL,
      3,
      2.042793,
      0,
      NULL,
      NULL,
      2.047388,
      1,
      0.870941,
      0,
      NULL,
      NULL,
      1.962059,
      1,
      NULL,
      0.933133,
      0.333348,
      1.417980,
      0.615483,
      1.626728,
      1,
      1.298893,
      7,
      6,
      3,
      8.451177,
      NULL,
      7.724965,
      2,
      0.047286,
      0.513876,
      1.888345,
      NULL,
      3.236633,
      10,
      1.194811,
      1.659890,
      NULL,
      36.621552,
      NULL,
      30.682745,
      2.968583,
      1,
      NULL,
      NULL,
      '40413',
      '21220',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      2.092964,
      24,
      23,
      55.104512,
      0.615842,
      46.660961,
      3,
      2.617486,
      NULL,
      2,
      0,
      1.535403,
      0.086942,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.160705,
      3,
      0,
      NULL,
      NULL,
      1,
      0.501867,
      2,
      2,
      1,
      0,
      2.866962,
      0,
      0.983800,
      0,
      NULL,
      0.007630,
      0.300631,
      3,
      1.146226,
      NULL,
      NULL,
      6.675010,
      5.838796,
      6,
      1.081273,
      2.776495,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.247139,
      NULL,
      0.507550,
      NULL,
      NULL,
      NULL,
      0.129819,
      1.779366,
      1.150121,
      1.012266,
      3.781942,
      1.890949,
      1.519406,
      0.917592,
      1,
      3.598682,
      0.964668,
      0,
      0.888297,
      1,
      NULL,
      1,
      2,
      NULL,
      2.428481,
      NULL,
      NULL,
      NULL,
      NULL,
      2.915282,
      0,
      6,
      NULL,
      NULL,
      2,
      0,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.457942,
      NULL,
      NULL,
      2.128843,
      NULL,
      1,
      0,
      1.029026,
      1.069121,
      1,
      NULL,
      NULL,
      NULL,
      4,
      1.180537,
      1.394092,
      NULL,
      0.712096,
      1,
      1.619362,
      0.215788,
      0.961224,
      4,
      NULL,
      1.251499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.875711,
      0,
      2,
      0.145311,
      0.177729,
      6,
      NULL,
      0,
      0,
      NULL,
      3,
      0.753685,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      3,
      0.591272,
      2,
      NULL,
      8,
      0,
      NULL,
      1.173643,
      2.815247,
      1,
      0,
      1.198371,
      0,
      3.064889,
      2.172326,
      0,
      NULL,
      0,
      1,
      11,
      1.307249,
      7.419304,
      NULL,
      5.652420,
      2.397999,
      1.624057,
      0.560304,
      7,
      2.924447,
      3,
      3.505378,
      0.500951,
      1,
      0,
      NULL,
      0.653920,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1.389837,
      3.593266,
      NULL,
      NULL,
      1.433027,
      NULL,
      0,
      0.515623,
      NULL,
      NULL,
      1,
      NULL,
      2.142434,
      3.676049,
      NULL,
      NULL,
      3,
      NULL,
      1.372519,
      NULL,
      NULL,
      2.962580,
      0.315388,
      NULL,
      0.484275,
      2.090433,
      NULL,
      0,
      2.935033,
      NULL,
      0,
      2,
      NULL,
      13.651124,
      13,
      NULL,
      1,
      0.009215,
      1.928507,
      0.926925,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062573,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.360755,
      NULL,
      NULL,
      NULL,
      3.481803,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.887764,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.351843,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.516346,
      1,
      NULL,
      NULL,
      1.846816,
      NULL,
      1,
      NULL,
      NULL,
      2.314756,
      0.797500,
      1.708524,
      0.401031,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.445085,
      NULL,
      1,
      1.965161,
      NULL,
      NULL,
      0,
      2.599537,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.766037,
      NULL,
      NULL,
      NULL,
      102,
      NULL,
      2.025622,
      NULL,
      NULL,
      NULL,
      1.657155,
      1.492608,
      NULL,
      NULL,
      NULL,
      1.347492,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.984189,
      NULL,
      1.675547,
      NULL,
      0.456550,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.513680,
      NULL,
      0.136275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.681506,
      NULL,
      1,
      0.399954,
      1.656188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185399,
      1.566433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416988,
      1.615491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.021802,
      1.635787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980393,
      0.987916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.652448,
      2.152960,
      NULL,
      2.665019,
      NULL,
      5,
      NULL,
      3,
      NULL,
      0.156841,
      NULL,
      NULL,
      NULL,
      3.271572,
      NULL,
      33,
      NULL,
      NULL,
      1,
      1.676343,
      NULL,
      0.592162,
      2,
      1,
      6,
      6.344797,
      0.042070,
      3,
      NULL,
      12.091029,
      1,
      2,
      1.303727,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.493376,
      1.792786,
      NULL,
      0,
      2,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3.977667,
      NULL,
      2,
      1,
      NULL,
      2.450121,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.603010,
      NULL,
      3.265179,
      1.923743,
      3,
      2.868856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.618684,
      NULL,
      2.146607,
      NULL,
      0.010227,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.097323,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      63,
      0.682916,
      1429.496898,
      1,
      0.056826,
      NULL,
      0.658650,
      NULL,
      1,
      NULL,
      0.118437,
      NULL,
      1.741476,
      NULL,
      0.214993,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.523637,
      NULL,
      57.337734,
      1,
      328.426315,
      0,
      NULL,
      1.510481,
      NULL,
      2,
      NULL,
      4,
      4,
      NULL,
      3.320098,
      1.466672,
      3.588208,
      49.872113,
      NULL,
      4,
      1.485536,
      6,
      '02422',
      '22312',
      '03221',
      3.280643,
      '34432',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


