set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-4-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '2042230',
      NULL,
      0.974359,
      0,
      NULL,
      NULL,
      NULL,
      1.681925,
      NULL,
      NULL,
      ' 6- 4-2002',
      16.621650,
      NULL,
      5.595440,
      2.199397,
      NULL,
      '11-16-1984',
      52.662583,
      3,
      NULL,
      0.645990,
      3,
      ' 5-25-1981',
      ' 1-27-1985',
      ' 4-16-1981',
      2,
      2.084198,
      2,
      NULL,
      1,
      1.189165,
      1.934765,
      0,
      NULL,
      185,
      1,
      11.252274,
      2,
      33,
      NULL,
      NULL,
      5,
      3.748269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.632438,
      1,
      0,
      3,
      5,
      1.597015,
      1.677082,
      NULL,
      2,
      5.961413,
      4.835122,
      2,
      2.457624,
      6.322040,
      5.268191,
      6.548932,
      NULL,
      NULL,
      0.368868,
      NULL,
      1.246754,
      1.619560,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.984657,
      1,
      NULL,
      0.819573,
      1,
      1.221947,
      1.894197,
      2.840517,
      0.384017,
      3.699777,
      2.757733,
      NULL,
      3.283791,
      2.370177,
      0,
      2.950758,
      NULL,
      3,
      NULL,
      11.138027,
      3.313499,
      NULL,
      7.667220,
      1.163559,
      4.079051,
      NULL,
      0.219654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.803689,
      1.843327,
      0,
      NULL,
      0,
      6,
      0.154682,
      NULL,
      2,
      5,
      1,
      7.586620,
      NULL,
      0,
      1.131486,
      0.183532,
      1,
      0.595774,
      NULL,
      1.511198,
      0.580884,
      3,
      NULL,
      0.516427,
      1.753883,
      3,
      1,
      NULL,
      1.038987,
      1.183637,
      1,
      1,
      1,
      1.146358,
      2,
      1,
      3.499265,
      1.372320,
      2,
      NULL,
      NULL,
      8.111438,
      NULL,
      1.741506,
      5.249878,
      0,
      1.006327,
      ' 4-26-1989',
      628,
      NULL,
      414.861738,
      NULL,
      1,
      0.612378,
      2,
      0.056838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.101939,
      0,
      NULL,
      1.308621,
      1.668557,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744192,
      0.269993,
      0.118630,
      0,
      1,
      1,
      0.262814,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.518881,
      0.743461,
      0,
      NULL,
      1.176893,
      1.337597,
      0.942994,
      69.851811,
      1.099106,
      0.484300,
      NULL,
      NULL,
      NULL,
      0.502351,
      0,
      1.003895,
      NULL,
      NULL,
      NULL,
      0,
      0,
      7,
      3.746720,
      2.025853,
      NULL,
      NULL,
      1,
      2.696064,
      NULL,
      0.210356,
      0.009173,
      0,
      1.806054,
      1,
      NULL,
      1.794068,
      0.426901,
      1.175976,
      1,
      1.973967,
      NULL,
      NULL,
      1.831303,
      1,
      0,
      3,
      0,
      1,
      6,
      10.261171,
      7.906119,
      5.481860,
      NULL,
      4,
      2,
      2.871378,
      1.183869,
      NULL,
      3.157625,
      2.807212,
      NULL,
      NULL,
      42.614955,
      2,
      0,
      NULL,
      0.717719,
      '40331',
      '44222',
      '30021',
      1.989304,
      NULL,
      '',
      NULL,
      0.115798,
      '',
      '',
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      1.859431,
      31.480416,
      NULL,
      0,
      NULL,
      0,
      1.702381,
      2,
      2.312889,
      0.218402,
      NULL,
      0.321468,
      NULL,
      NULL,
      1,
      1,
      0.245805,
      0.420473,
      3.048894,
      1.221726,
      3.489309,
      3,
      1.840268,
      2.563392,
      3,
      2,
      0,
      2,
      0.761620,
      3,
      2.731906,
      3.716610,
      NULL,
      0,
      0.818457,
      0.659940,
      NULL,
      NULL,
      2,
      1,
      1.255562,
      9.971834,
      2.398197,
      5.194874,
      0,
      1.881905,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.656438,
      2,
      3,
      0.677397,
      0.208331,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.872419,
      2.992263,
      2.445331,
      3.429671,
      3,
      0.997607,
      NULL,
      2,
      2,
      1,
      3.563775,
      3,
      3,
      0.663195,
      0,
      2,
      NULL,
      0,
      0.997117,
      1,
      3.888063,
      1,
      2,
      5,
      9,
      NULL,
      0.371736,
      0,
      3.704624,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.457713,
      0.085740,
      3,
      NULL,
      0.003570,
      0,
      NULL,
      1,
      1.464950,
      0,
      NULL,
      NULL,
      11.743275,
      NULL,
      4.569532,
      2.307947,
      3.482280,
      2.776978,
      NULL,
      NULL,
      1.781986,
      7.315220,
      2.887458,
      4.240141,
      1,
      NULL,
      NULL,
      0.791516,
      NULL,
      NULL,
      0.738336,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.981705,
      NULL,
      NULL,
      NULL,
      2.457765,
      1,
      1,
      3.646353,
      0.258771,
      9,
      2.817507,
      0,
      3.862350,
      3,
      5.605782,
      4,
      7.168047,
      5.807655,
      1.784147,
      1,
      3.435410,
      1.921071,
      3.374888,
      0,
      0.494361,
      2.236137,
      1.108779,
      1,
      8.211974,
      6.902218,
      1,
      NULL,
      1,
      0.444040,
      0.767876,
      2.142437,
      NULL,
      1,
      0,
      NULL,
      0,
      2.328368,
      7.703670,
      1.470434,
      5,
      NULL,
      6,
      NULL,
      3.907949,
      2,
      NULL,
      3.900540,
      1.929062,
      0,
      0,
      0.400616,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      26.686395,
      152,
      NULL,
      1.559475,
      0,
      NULL,
      3,
      3.547896,
      NULL,
      NULL,
      NULL,
      NULL,
      0.267460,
      NULL,
      NULL,
      2.334092,
      1.437154,
      NULL,
      0,
      3,
      NULL,
      3,
      1.083949,
      NULL,
      2.429819,
      3,
      NULL,
      NULL,
      3.907267,
      NULL,
      0.848479,
      0.403262,
      NULL,
      1.797304,
      0,
      NULL,
      5,
      3.502577,
      NULL,
      NULL,
      0.173216,
      1,
      0,
      1,
      0.947464,
      3.255817,
      0.797185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.222413,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.668490,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697123,
      NULL,
      NULL,
      NULL,
      0.968318,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.462539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284853,
      NULL,
      NULL,
      NULL,
      2.425797,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      1.163706,
      NULL,
      NULL,
      NULL,
      1.817835,
      66.781881,
      2.049849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586507,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.047313,
      949.497679,
      NULL,
      NULL,
      1,
      NULL,
      3.189188,
      1.384515,
      0,
      1,
      NULL,
      1.213625,
      NULL,
      0.884967,
      3,
      1,
      0.773466,
      1,
      0,
      1.504117,
      2,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.690387,
      NULL,
      NULL,
      NULL,
      328,
      NULL,
      3,
      17,
      47.873792,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.919975,
      NULL,
      1.239452,
      NULL,
      1.804545,
      NULL,
      0,
      NULL,
      2.899108,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.997127,
      NULL,
      0.737970,
      NULL,
      0,
      NULL,
      1.777467,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.662579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.300903,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1710.267679,
      NULL,
      1.739354,
      NULL,
      3,
      NULL,
      2,
      1.393033,
      0.153240,
      23,
      NULL,
      NULL,
      0,
      0,
      NULL,
      4.326207,
      3,
      2.433795,
      NULL,
      NULL,
      NULL,
      NULL,
      2.214815,
      13.744802,
      1.944467,
      1.236702,
      NULL,
      2.949097,
      NULL,
      NULL,
      NULL,
      1.318651,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      2.236436,
      1,
      NULL,
      2.063559,
      0.104403,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.256214,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.181054,
      NULL,
      1.078619,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634107,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.480645,
      1.831806,
      5.609918,
      3.911625,
      1,
      1,
      4,
      13.829973,
      NULL,
      1,
      NULL,
      '32230',
      '10212',
      '11130',
      1.441661,
      '34442',
      '',
      '',
      0.936518,
      '',
      '',
      '');
commit;
end;
/


