set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514465';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-9-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '0330441',
      1.733814,
      1,
      0,
      1,
      '4001',
      NULL,
      1,
      NULL,
      NULL,
      ' 2-13-1984',
      105,
      NULL,
      0.562526,
      NULL,
      0.164507,
      ' 5-21-1975',
      58.687495,
      NULL,
      NULL,
      46,
      0.471336,
      ' 8- 7-1996',
      ' 2-18-2001',
      NULL,
      1.899464,
      NULL,
      0,
      1,
      0,
      1.537251,
      1,
      NULL,
      0.559449,
      13.134497,
      11.538850,
      NULL,
      NULL,
      17,
      NULL,
      5,
      34.702408,
      3.297369,
      1.055579,
      4.265866,
      1.463738,
      0,
      0,
      0,
      1.745314,
      0,
      1.223343,
      0.166497,
      0.201733,
      0,
      NULL,
      2.310923,
      1,
      NULL,
      2.624855,
      0,
      1.536097,
      3.553247,
      3,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0.135308,
      2,
      NULL,
      0.416299,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.355355,
      NULL,
      NULL,
      1.006949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724064,
      0.789681,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.774914,
      1,
      5.411760,
      NULL,
      7,
      1,
      0.690822,
      1,
      2,
      1,
      0.643198,
      1.943252,
      1,
      NULL,
      3.919178,
      0.903477,
      2.953888,
      0,
      1.476787,
      NULL,
      1.621022,
      4.197252,
      5,
      3.801754,
      3.904190,
      3.201030,
      1,
      2,
      5,
      5,
      0.607471,
      4,
      2.680426,
      5.745764,
      5,
      1,
      7.445539,
      3,
      0,
      9,
      0,
      1.513737,
      2,
      1.607658,
      NULL,
      NULL,
      '11-22-1982',
      NULL,
      ' 2- 9-1994',
      23,
      3,
      1.752669,
      1.960517,
      1.720722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.587049,
      NULL,
      1.053793,
      3,
      NULL,
      0.507082,
      0,
      3.634919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015457,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.363929,
      0.860655,
      0,
      2.932076,
      0.604798,
      NULL,
      NULL,
      NULL,
      1.812557,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.885648,
      0.695699,
      1.507967,
      0.882913,
      1,
      0.394828,
      0,
      12,
      2.668076,
      1.573152,
      NULL,
      NULL,
      NULL,
      2.072344,
      1.348038,
      2,
      0,
      3.642444,
      2.794628,
      1,
      NULL,
      0.333937,
      0.310811,
      NULL,
      1.533288,
      3,
      3.147559,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.656241,
      0,
      NULL,
      4,
      NULL,
      1,
      1,
      NULL,
      1.631455,
      0,
      1.695696,
      NULL,
      1.400713,
      4,
      2.077069,
      NULL,
      4.303437,
      2,
      0.515727,
      5.684645,
      0,
      5.362024,
      3.869721,
      3.859064,
      0.632450,
      55.725704,
      3.065065,
      2.974928,
      NULL,
      51.603294,
      27.307389,
      NULL,
      3,
      5,
      4,
      NULL,
      '31014',
      '',
      1.418789,
      '',
      NULL,
      '',
      3.396034,
      '0112',
      '',
      '',
      0.277602,
      25.502416,
      179.891482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093863,
      0.395281,
      1,
      1,
      NULL,
      NULL,
      0.737788,
      NULL,
      NULL,
      0,
      0.413174,
      1,
      0.757818,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174153,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.341985,
      4,
      0,
      1,
      3,
      2.181574,
      1.398411,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.736612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824517,
      0.215701,
      1.560424,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.106288,
      2.135785,
      NULL,
      0.380786,
      1.674830,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.071456,
      NULL,
      NULL,
      1.862151,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.056405,
      1,
      2.442494,
      0,
      0.251658,
      0.573963,
      NULL,
      NULL,
      0.895430,
      1.712261,
      2.670502,
      1.268006,
      1.767562,
      1,
      0,
      1,
      0.680307,
      0.277140,
      NULL,
      0,
      3,
      0,
      0.066312,
      3.897342,
      0,
      1.663883,
      5,
      1,
      0.483751,
      0,
      NULL,
      NULL,
      NULL,
      3.855147,
      0.458902,
      1,
      0.628600,
      2.206999,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      19.001347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640381,
      NULL,
      NULL,
      1.773370,
      NULL,
      NULL,
      0.896053,
      NULL,
      NULL,
      0.918852,
      NULL,
      NULL,
      1.924882,
      NULL,
      NULL,
      2.806297,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.544132,
      NULL,
      NULL,
      0.904095,
      0,
      0,
      0.260472,
      NULL,
      NULL,
      0.012880,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068973,
      0.298216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831901,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.396452,
      NULL,
      NULL,
      NULL,
      1.751466,
      0,
      NULL,
      NULL,
      0.824557,
      NULL,
      NULL,
      NULL,
      0.207035,
      0,
      NULL,
      NULL,
      1,
      0.529451,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897439,
      NULL,
      NULL,
      0.028424,
      NULL,
      0.899027,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.549252,
      NULL,
      NULL,
      0,
      1.957730,
      1.697626,
      0.739409,
      0,
      NULL,
      1,
      0.463954,
      0.885962,
      0.798439,
      0.289641,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5,
      6.205555,
      3.070471,
      2,
      NULL,
      0.749549,
      13,
      NULL,
      3.026697,
      2,
      0.119071,
      1,
      0.628239,
      1,
      1.781883,
      1.713491,
      0.878789,
      1,
      1,
      1.064481,
      0.758516,
      1.145553,
      NULL,
      2.808375,
      NULL,
      0,
      0.680007,
      NULL,
      0,
      0,
      1.171797,
      1,
      0.424484,
      NULL,
      0,
      NULL,
      3.713712,
      0,
      1,
      1,
      1.083623,
      0,
      1,
      1.238602,
      0,
      1.166828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.333534,
      1,
      0.602176,
      0.293337,
      NULL,
      0,
      7.258508,
      0.944430,
      NULL,
      NULL,
      26.911515,
      NULL,
      4,
      2,
      2,
      NULL,
      '21143',
      '',
      1.292383,
      '',
      '',
      '',
      NULL,
      '2004',
      '',
      '');
commit;
end;
/


