set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6702935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '2000213',
      2,
      0,
      3,
      NULL,
      '1400',
      NULL,
      NULL,
      1,
      50.257637,
      ' 9-27-1991',
      107.314717,
      NULL,
      4.048322,
      2,
      0.329487,
      ' 4- 9-1992',
      NULL,
      NULL,
      138.105613,
      NULL,
      0.571558,
      NULL,
      NULL,
      ' 6-24-1976',
      NULL,
      1.264388,
      1.894518,
      3.295031,
      2.274442,
      1.582391,
      2,
      1.593283,
      0,
      149,
      11,
      0,
      2,
      NULL,
      9,
      3,
      5,
      6.491864,
      0,
      NULL,
      1,
      1,
      0.518805,
      1,
      NULL,
      NULL,
      0,
      0,
      1.747455,
      NULL,
      3,
      1.801756,
      2,
      7,
      2.817411,
      1,
      0,
      0.460154,
      0.400150,
      1,
      NULL,
      NULL,
      0.877660,
      1.261393,
      NULL,
      NULL,
      1.925011,
      1,
      1,
      1,
      1.721641,
      2.921472,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658656,
      1.482697,
      0.075244,
      0.873066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840237,
      1.151236,
      0.459654,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.800435,
      0,
      1.606066,
      1.469796,
      1.328402,
      7,
      1,
      1.706915,
      NULL,
      NULL,
      1,
      3,
      NULL,
      6.716960,
      1.794640,
      NULL,
      3,
      1,
      0.427554,
      NULL,
      0.311847,
      3,
      NULL,
      1.455000,
      5,
      2,
      3,
      NULL,
      6.455458,
      7.430758,
      4,
      NULL,
      2,
      NULL,
      0.078449,
      3.443998,
      3.378145,
      3,
      3.991924,
      2,
      0.296094,
      4.250619,
      2.065131,
      5.722633,
      NULL,
      NULL,
      5,
      3.501157,
      NULL,
      891.405216,
      NULL,
      NULL,
      0,
      1.064052,
      0.761435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.165965,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176315,
      1.096065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.481701,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.218049,
      0.981700,
      NULL,
      1.730661,
      0.662769,
      NULL,
      0.564322,
      1.535466,
      NULL,
      NULL,
      NULL,
      2.010640,
      1.782521,
      0,
      3.284043,
      0.918039,
      3.901860,
      2,
      3,
      0.569866,
      3.583929,
      2,
      NULL,
      1.017846,
      2,
      NULL,
      0.896346,
      0,
      1,
      0,
      8,
      1,
      0,
      1,
      0.868363,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      9.404000,
      NULL,
      0.591879,
      1.954757,
      6,
      0.828973,
      1,
      1.467593,
      2,
      0.040693,
      0,
      23.167762,
      NULL,
      0.972973,
      62,
      NULL,
      NULL,
      NULL,
      1.284520,
      1,
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0.848266,
      '01241',
      '4134',
      '',
      0.575223,
      29.671711,
      122,
      NULL,
      0,
      NULL,
      4,
      NULL,
      0.751809,
      0,
      NULL,
      1.653857,
      0,
      NULL,
      NULL,
      0.744763,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.520328,
      NULL,
      NULL,
      3.427195,
      2.345477,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823533,
      NULL,
      NULL,
      1.774486,
      0.980961,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      7,
      1.789174,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.153921,
      NULL,
      NULL,
      1.474871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.902674,
      2.196811,
      2,
      1,
      NULL,
      0.966108,
      1,
      NULL,
      NULL,
      4.085116,
      2.089005,
      2.215517,
      0.217009,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      1.001936,
      NULL,
      NULL,
      1.593990,
      NULL,
      1.986453,
      1.848598,
      1.622036,
      0.206082,
      1,
      NULL,
      NULL,
      4,
      5,
      0,
      NULL,
      0,
      NULL,
      3,
      0,
      12,
      NULL,
      0,
      NULL,
      0.811631,
      NULL,
      NULL,
      0.190887,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      3.592478,
      1.573719,
      1.735598,
      NULL,
      2.677791,
      0.744264,
      NULL,
      NULL,
      NULL,
      2.624261,
      NULL,
      1,
      1.014394,
      NULL,
      4,
      1,
      0.286795,
      1.247879,
      0.599877,
      3,
      NULL,
      2.206357,
      2,
      NULL,
      1,
      NULL,
      0.585057,
      11.838303,
      0,
      4.233672,
      1.011087,
      NULL,
      2.197671,
      NULL,
      2,
      2.451542,
      NULL,
      2,
      3.690925,
      1,
      2,
      0.536444,
      10.733163,
      2,
      3,
      5,
      7,
      9,
      2.260995,
      3.679850,
      7.103409,
      1,
      1.762217,
      0.209476,
      1.989799,
      1.868366,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.147429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.554311,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.236622,
      NULL,
      NULL,
      1.610021,
      NULL,
      NULL,
      2.380768,
      NULL,
      NULL,
      1.655855,
      NULL,
      NULL,
      2.636706,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.186248,
      1.890701,
      0.092932,
      3,
      NULL,
      5,
      1.113244,
      105.020267,
      NULL,
      46.009028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.723895,
      NULL,
      3.711754,
      NULL,
      0,
      NULL,
      0,
      0.253891,
      0.360896,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.769985,
      NULL,
      3.889815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.034616,
      0.852699,
      NULL,
      1,
      0,
      1,
      NULL,
      2.881871,
      0.600644,
      NULL,
      NULL,
      2,
      NULL,
      18,
      NULL,
      1.949952,
      NULL,
      NULL,
      NULL,
      1.646183,
      2.889871,
      1,
      NULL,
      0,
      1.379676,
      NULL,
      NULL,
      5.441806,
      7.682772,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      25,
      44.056699,
      NULL,
      84,
      4,
      0.330675,
      NULL,
      NULL,
      NULL,
      121.636954,
      17.419725,
      0,
      NULL,
      NULL,
      0.305288,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      119,
      0,
      0.701795,
      0.200307,
      0,
      1.045402,
      1.982845,
      0.969884,
      0,
      1.023263,
      1,
      1.801597,
      1.761049,
      1,
      1,
      1,
      NULL,
      NULL,
      0.688594,
      1.928006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.640953,
      NULL,
      7.099668,
      0.092697,
      0,
      3,
      2.080440,
      9.346413,
      0.819420,
      0,
      1.600144,
      1.696571,
      NULL,
      1,
      12.219443,
      9.338705,
      0,
      0.160623,
      0,
      2,
      NULL,
      0,
      0,
      1,
      2,
      3.484766,
      0,
      1.972654,
      2.032508,
      2,
      0.683219,
      NULL,
      3,
      3.602375,
      1.299089,
      1.452194,
      NULL,
      0.688865,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.064469,
      0.624786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.232252,
      1.177871,
      0.347522,
      0.182386,
      NULL,
      2,
      9.640082,
      NULL,
      0.464891,
      1,
      4.707367,
      36.435559,
      1.746721,
      0,
      3.855399,
      '12313',
      '',
      '',
      0.707099,
      '',
      '',
      '',
      NULL,
      '1243',
      '14333',
      '4040');
commit;
end;
/


