set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433079';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '1034243',
      2.159534,
      0,
      NULL,
      3,
      '3100',
      3,
      0,
      NULL,
      NULL,
      '11- 2-2002',
      44,
      NULL,
      5.994015,
      3,
      3,
      ' 0-14-2001',
      10.974123,
      2.137796,
      205.703568,
      83,
      3.556162,
      NULL,
      NULL,
      '11-22-1988',
      3.742777,
      3.382804,
      NULL,
      NULL,
      0,
      3.450574,
      3.105838,
      0.858417,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.351921,
      16.113074,
      4,
      7.151894,
      2.001380,
      4.175954,
      3.218645,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.494044,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.082149,
      1,
      1.651921,
      0.252603,
      0.433771,
      3.946673,
      1,
      0,
      1,
      NULL,
      1,
      0.532779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.784730,
      1.163088,
      2,
      2,
      2.518305,
      0,
      2.480722,
      2,
      1.048272,
      1.209946,
      1,
      1.363547,
      NULL,
      0.468906,
      NULL,
      2.961552,
      2,
      0.659150,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.958652,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1.016382,
      0.372009,
      NULL,
      NULL,
      0.129003,
      NULL,
      0.634411,
      3,
      NULL,
      0,
      NULL,
      0.165414,
      0,
      1,
      0,
      0,
      NULL,
      1,
      8.117376,
      0.736712,
      NULL,
      NULL,
      1,
      11,
      NULL,
      0,
      5.461450,
      NULL,
      6,
      0,
      2.007199,
      NULL,
      8,
      10.839289,
      5,
      0.926180,
      1,
      2,
      0,
      5,
      NULL,
      2.401465,
      7.514727,
      6,
      1,
      '11-26-1988',
      363,
      ' 5-19-1998',
      NULL,
      0,
      0.172780,
      3.670738,
      2.160944,
      0.871075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.403530,
      NULL,
      0.822153,
      NULL,
      NULL,
      1,
      1.637638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.838107,
      1,
      1.396819,
      0,
      NULL,
      7,
      1.777144,
      NULL,
      NULL,
      NULL,
      0.241389,
      1.491648,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.397060,
      0.705119,
      1.399694,
      0.599903,
      0.896929,
      0.670185,
      1,
      2,
      4,
      NULL,
      0.018184,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.587978,
      0.434629,
      2.843719,
      0,
      1,
      2.291990,
      1,
      0,
      1,
      3,
      1.121186,
      NULL,
      2.383803,
      3.828763,
      NULL,
      1.726962,
      1,
      2,
      NULL,
      1.920320,
      0,
      0.330303,
      0,
      NULL,
      0.897013,
      NULL,
      0.114859,
      0,
      2.443961,
      1.671394,
      NULL,
      1,
      7.451295,
      0,
      NULL,
      0,
      1,
      3.380149,
      0.441718,
      NULL,
      3,
      1,
      10.713324,
      3.997640,
      0,
      NULL,
      13,
      31.163790,
      15,
      0,
      0,
      NULL,
      '22214',
      '',
      '',
      4,
      '1134',
      '3203',
      NULL,
      0,
      '',
      '',
      '',
      1,
      5.193620,
      143,
      7,
      1.806041,
      0,
      11.854910,
      NULL,
      8,
      0,
      2,
      3.791612,
      1.457704,
      NULL,
      NULL,
      1.926074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.747491,
      NULL,
      NULL,
      0.377771,
      1,
      2.319911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.667662,
      NULL,
      NULL,
      0.060879,
      NULL,
      NULL,
      1.445630,
      NULL,
      NULL,
      NULL,
      7.992760,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.066270,
      0.131503,
      2.831634,
      0.387352,
      2.375176,
      3.558613,
      2,
      NULL,
      1,
      1,
      0.624953,
      2,
      3.095266,
      1,
      NULL,
      1.937872,
      1.705433,
      0.980437,
      1.964467,
      1.828113,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      7.036121,
      5.908894,
      3,
      2.437525,
      0,
      NULL,
      NULL,
      NULL,
      1.948425,
      NULL,
      NULL,
      NULL,
      0.945102,
      NULL,
      NULL,
      1.203258,
      0,
      3,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      6,
      1,
      1,
      0.426210,
      0.464857,
      3.988131,
      0.372012,
      NULL,
      NULL,
      2,
      3,
      5.649643,
      0,
      NULL,
      NULL,
      1.368447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811481,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      2,
      0,
      2,
      2.852917,
      NULL,
      2.892485,
      0.208904,
      4.300184,
      5.035251,
      8.702036,
      8,
      1,
      NULL,
      3.718920,
      0,
      3,
      3.998621,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.899875,
      NULL,
      3.722449,
      2.777563,
      0,
      2.684604,
      2.831001,
      1.175586,
      3.363517,
      2.624780,
      0,
      NULL,
      NULL,
      1,
      2.283658,
      0.388409,
      8.007791,
      7.856337,
      8.985330,
      0.762061,
      1.440344,
      3,
      0,
      0.405267,
      0.732917,
      0.914487,
      NULL,
      1.239372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.777678,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.357822,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286249,
      NULL,
      NULL,
      1,
      1,
      1.978830,
      0.068725,
      1.298784,
      0,
      0,
      NULL,
      NULL,
      1.480919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.840108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.618170,
      NULL,
      NULL,
      NULL,
      3.408726,
      NULL,
      NULL,
      NULL,
      0.159869,
      NULL,
      NULL,
      NULL,
      1.965184,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367187,
      NULL,
      NULL,
      NULL,
      6.823387,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      27.705689,
      12.665693,
      0,
      2.008364,
      2,
      NULL,
      NULL,
      NULL,
      2,
      0.287027,
      NULL,
      1.417547,
      NULL,
      NULL,
      1.119126,
      NULL,
      NULL,
      0.694821,
      NULL,
      NULL,
      161,
      0.542533,
      1,
      0,
      0,
      0.345840,
      NULL,
      NULL,
      0,
      1.051576,
      0.838638,
      1,
      1,
      0,
      0.998952,
      NULL,
      0.221914,
      1.668648,
      1.548432,
      1.775870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      2,
      3.256606,
      0,
      NULL,
      NULL,
      3.061573,
      1.788218,
      1,
      0.991715,
      NULL,
      NULL,
      0,
      2.512407,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.884838,
      1,
      NULL,
      3,
      3,
      NULL,
      1.463966,
      NULL,
      NULL,
      2,
      NULL,
      1.382857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.919030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      7.006246,
      1.061717,
      NULL,
      1,
      NULL,
      NULL,
      8,
      46.328287,
      4,
      5,
      1,
      '42021',
      '',
      '',
      5.762681,
      '1004',
      '3222',
      '',
      0.609686,
      '',
      NULL,
      NULL);
commit;
end;
/


