set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9717517';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6.939610,
      NULL,
      1.004390,
      NULL,
      3.877683,
      2,
      0,
      0,
      '30',
      NULL,
      49,
      NULL,
      '1242012',
      1.008129,
      1,
      3,
      1,
      '1202',
      3.101678,
      1.633008,
      NULL,
      NULL,
      ' 7- 0-2001',
      123.119982,
      143.931128,
      NULL,
      NULL,
      0.780506,
      ' 8- 6-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 0-11-1987',
      ' 3- 6-1983',
      ' 5- 8-1974',
      2.632051,
      1.695225,
      2,
      1.676266,
      0.791816,
      NULL,
      3.714686,
      0,
      NULL,
      NULL,
      NULL,
      2.352121,
      1.185430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0.208476,
      0,
      0,
      1.631668,
      NULL,
      0,
      7,
      0,
      1,
      4.337223,
      NULL,
      2.956459,
      NULL,
      1,
      NULL,
      0.491213,
      3.675871,
      0.841543,
      3.435694,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      3,
      1.142868,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774412,
      NULL,
      NULL,
      5,
      1,
      3,
      NULL,
      NULL,
      3,
      3.401548,
      NULL,
      3.963423,
      NULL,
      NULL,
      1.538241,
      1,
      2,
      0,
      1,
      NULL,
      0,
      3,
      NULL,
      1.102575,
      0,
      6,
      1.990818,
      1.118155,
      0.241943,
      NULL,
      NULL,
      NULL,
      1.974106,
      NULL,
      NULL,
      NULL,
      0.902635,
      NULL,
      NULL,
      NULL,
      2,
      0.805237,
      NULL,
      0,
      1,
      0.899436,
      5.354984,
      0.942999,
      7,
      1.269479,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.943176,
      1,
      3.150838,
      NULL,
      1,
      0,
      5,
      2,
      0,
      0.906969,
      2.776001,
      5.641765,
      0.568784,
      2.740612,
      7,
      3.344911,
      8.365693,
      6.074235,
      7.678647,
      5.626200,
      2,
      4.337292,
      3,
      4.408364,
      4.028267,
      NULL,
      2,
      NULL,
      ' 9- 3-2003',
      NULL,
      ' 6- 5-1983',
      1,
      0.654349,
      1,
      1,
      4.044410,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.265493,
      NULL,
      1.634252,
      0,
      3.066735,
      1.272517,
      0.100740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959913,
      1.020857,
      1.877874,
      NULL,
      4,
      3.596596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286605,
      1.715126,
      3.690658,
      0,
      1,
      4.022294,
      1.591708,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.825143,
      1.720490,
      NULL,
      2,
      1,
      1.397781,
      1.868514,
      2,
      32.129401,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888327,
      NULL,
      2,
      1,
      2,
      NULL,
      1,
      0.654509,
      3,
      3.704289,
      3,
      0,
      3,
      0.000359,
      3.174429,
      0,
      2,
      1,
      1.351364,
      NULL,
      0.838837,
      1,
      1.790680,
      NULL,
      1.042955,
      1,
      NULL,
      NULL,
      1,
      1.728099,
      0.912203,
      0.458588,
      7.160345,
      NULL,
      6.048997,
      1,
      8,
      6,
      4.985278,
      1.000744,
      NULL,
      2,
      0.756736,
      NULL,
      44.174188,
      3,
      0,
      NULL,
      NULL,
      41,
      NULL,
      0,
      3.630199,
      0.219173,
      '0002',
      '',
      '',
      0.525908,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.726665,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.728446,
      3,
      1,
      0,
      NULL,
      NULL,
      0.356334,
      NULL,
      NULL,
      3,
      1.742359,
      1.108469,
      0,
      NULL,
      NULL,
      1.631663,
      NULL,
      NULL,
      0,
      NULL,
      0,
      57,
      NULL,
      1,
      0,
      1.110630,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1.897488,
      0,
      1,
      0.909032,
      0.353800,
      NULL,
      NULL,
      0.681924,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      6,
      4.632417,
      3,
      3.313354,
      NULL,
      NULL,
      3.050378,
      9,
      0,
      0.313292,
      0.809400,
      NULL,
      1,
      NULL,
      1.016672,
      1.591690,
      NULL,
      1,
      1,
      NULL,
      0,
      0.729695,
      NULL,
      0.902729,
      1.417744,
      NULL,
      0.968358,
      1.821195,
      NULL,
      2,
      2.382139,
      NULL,
      1.651027,
      0.623388,
      NULL,
      NULL,
      0.641672,
      NULL,
      0,
      1.492936,
      NULL,
      0.713978,
      1.589544,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819002,
      NULL,
      1.109326,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      NULL,
      87.893636,
      34.717693,
      NULL,
      NULL,
      1.477964,
      '1211',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL);
commit;
end;
/


