set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      1,
      '3114',
      NULL,
      0.732180,
      NULL,
      NULL,
      ' 2-22-1996',
      31,
      NULL,
      5.641238,
      1.714648,
      0,
      ' 4-11-1975',
      37.536397,
      2.453407,
      176,
      66.251193,
      3,
      ' 3- 8-1974',
      ' 6-25-1996',
      '10-13-1993',
      2,
      2,
      2,
      0.633415,
      1,
      3.069977,
      2.922396,
      2.771938,
      NULL,
      NULL,
      NULL,
      0.150372,
      11,
      3,
      17.253414,
      5,
      NULL,
      2,
      0,
      NULL,
      1.646441,
      0.777541,
      1.114641,
      1.892490,
      0.723087,
      1,
      0,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      1,
      2.299005,
      2.051533,
      1,
      0.957658,
      1,
      1,
      3.706609,
      5,
      0.673832,
      NULL,
      4,
      1,
      0,
      3,
      1,
      2.090354,
      0.118790,
      3.874971,
      1.460302,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.043606,
      NULL,
      0.498785,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.246993,
      0.254832,
      0,
      0.240650,
      3,
      1.031600,
      1.387156,
      3,
      0,
      1,
      NULL,
      1,
      NULL,
      1.613659,
      0.186532,
      0.836372,
      0.807412,
      1.952803,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.729518,
      7,
      5.382759,
      3.578687,
      NULL,
      1,
      5,
      0.200289,
      1.703450,
      0.181228,
      0.403236,
      NULL,
      0,
      1.977304,
      1.176274,
      1,
      NULL,
      0.343889,
      0,
      2,
      0.832226,
      1,
      0.882420,
      1.160381,
      NULL,
      0,
      0,
      1.978783,
      NULL,
      1,
      3.792434,
      1,
      1.172675,
      0.475665,
      2.621419,
      3.922092,
      0.645960,
      NULL,
      NULL,
      5,
      3,
      1.043383,
      NULL,
      0,
      NULL,
      ' 8-16-1996',
      192,
      ' 1-29-1975',
      101,
      0,
      1,
      NULL,
      1,
      1.782365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718999,
      NULL,
      1.826247,
      0,
      1,
      1.968355,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.322134,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800646,
      1.742266,
      3,
      0.079371,
      0.437589,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.605724,
      0,
      0.077379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      1.103761,
      0,
      0,
      1.964065,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.343523,
      4,
      NULL,
      1,
      1,
      1,
      2.186309,
      4.083719,
      3.060186,
      NULL,
      0,
      5,
      NULL,
      1.144141,
      2,
      0.346227,
      1,
      5.646625,
      1,
      1.735129,
      1,
      1,
      0.161070,
      0,
      NULL,
      0,
      0.505727,
      2,
      1,
      0,
      4,
      0,
      NULL,
      9,
      3.523916,
      7.371485,
      2.909739,
      1.683086,
      7.335736,
      3.537359,
      NULL,
      2.623957,
      7,
      3.983457,
      1,
      NULL,
      46,
      45,
      68,
      NULL,
      2.490649,
      3,
      '21333',
      '14013',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.904156,
      NULL,
      11,
      1.196823,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704348,
      0.682884,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.098152,
      NULL,
      NULL,
      1.708175,
      NULL,
      NULL,
      1.532324,
      NULL,
      NULL,
      3.282489,
      1.740334,
      3.716092,
      1,
      NULL,
      NULL,
      1.351055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174646,
      NULL,
      NULL,
      0.054050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.844244,
      NULL,
      NULL,
      NULL,
      3.749599,
      2.596208,
      1,
      0,
      NULL,
      NULL,
      1,
      0.459865,
      3,
      3.289077,
      0,
      NULL,
      3,
      2.096191,
      0.751399,
      1,
      NULL,
      1.104228,
      3,
      0,
      NULL,
      1,
      NULL,
      0.488201,
      1.422018,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701114,
      NULL,
      9,
      0.068486,
      1.534650,
      NULL,
      NULL,
      NULL,
      1.688463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.129667,
      1.302027,
      NULL,
      1.698760,
      0.809105,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      1.015414,
      NULL,
      2.062920,
      0.570875,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.761703,
      NULL,
      NULL,
      1.171005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290420,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      2.962615,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.631674,
      NULL,
      1,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      0.397317,
      2.612958,
      2.116118,
      0.933481,
      3.525470,
      1.968749,
      1,
      2.918142,
      2,
      1,
      3.644100,
      2,
      2,
      NULL,
      1.734932,
      NULL,
      NULL,
      NULL,
      2,
      1.388663,
      3,
      1,
      0.955197,
      1,
      1.069858,
      NULL,
      3,
      NULL,
      NULL,
      1.366198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.477390,
      NULL,
      NULL,
      1.016113,
      NULL,
      NULL,
      1,
      0.446423,
      0.060856,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805823,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.866037,
      NULL,
      NULL,
      1.726124,
      NULL,
      NULL,
      NULL,
      0,
      0.613725,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.928171,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.109459,
      125.121318,
      19.200605,
      0,
      0,
      1,
      NULL,
      1,
      0.885083,
      NULL,
      0.320326,
      0,
      1,
      2,
      NULL,
      1.968663,
      NULL,
      NULL,
      0.233601,
      2.262064,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      32,
      NULL,
      3,
      NULL,
      29.216709,
      NULL,
      3.729196,
      NULL,
      NULL,
      1,
      NULL,
      1.186282,
      NULL,
      1.409793,
      NULL,
      0.325770,
      NULL,
      1.595138,
      NULL,
      1,
      NULL,
      0.907874,
      NULL,
      NULL,
      NULL,
      1.927942,
      NULL,
      0,
      NULL,
      0.765103,
      NULL,
      1,
      NULL,
      0.674116,
      NULL,
      0.083473,
      NULL,
      3,
      1.047491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202822,
      1.309024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.090216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.188302,
      3.515362,
      0.835644,
      1.541632,
      0.197354,
      0,
      NULL,
      NULL,
      1,
      0.156292,
      1.378974,
      1.645350,
      1.916591,
      1.241400,
      NULL,
      0.431633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.910335,
      0.146904,
      2.507679,
      1.118266,
      3,
      1.613481,
      3.769703,
      NULL,
      1,
      0.797822,
      2.751769,
      1,
      1.397860,
      1.066724,
      NULL,
      NULL,
      1.130084,
      0.756726,
      2.431672,
      NULL,
      1.294337,
      NULL,
      1.899021,
      1,
      0.414196,
      0.040444,
      1.365051,
      0,
      NULL,
      1.099562,
      0,
      3.133451,
      NULL,
      1,
      1.573935,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.951291,
      NULL,
      1,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923076,
      1,
      0,
      0.460605,
      1,
      1.621766,
      2,
      1,
      2.966068,
      NULL,
      0,
      1.645149,
      0,
      26.017977,
      5,
      2,
      4,
      '12243',
      '44033',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


