set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31',
      NULL,
      25,
      27.771173,
      '4211330',
      0.776485,
      NULL,
      NULL,
      1,
      '4113',
      4.825206,
      0,
      NULL,
      NULL,
      '10-24-1995',
      114,
      17.699629,
      NULL,
      NULL,
      0,
      ' 3-13-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      2.617852,
      ' 7- 8-1992',
      ' 1- 9-1996',
      NULL,
      NULL,
      NULL,
      3.111175,
      1,
      0,
      NULL,
      1.597980,
      1.963074,
      0,
      7,
      11,
      17,
      4.256172,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      NULL,
      0.750861,
      NULL,
      NULL,
      0.127955,
      1,
      0,
      0,
      2.779669,
      NULL,
      0,
      1.226955,
      1.864021,
      NULL,
      7.949297,
      2,
      NULL,
      1,
      1.730940,
      1,
      1.494804,
      3.358142,
      5.642679,
      3.070210,
      4.733826,
      1,
      NULL,
      0,
      3,
      0.541445,
      NULL,
      1.767637,
      1,
      1.642493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.253713,
      1.385079,
      3.376848,
      3.216828,
      1.107631,
      1,
      1,
      2.671218,
      1.225786,
      1.223400,
      3.228663,
      NULL,
      0,
      1,
      3.989940,
      NULL,
      1.312569,
      3.448379,
      NULL,
      10.339918,
      1,
      0.039841,
      NULL,
      1.560242,
      1,
      NULL,
      1.424671,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.362742,
      0,
      0.296443,
      1.624197,
      0,
      0.653606,
      NULL,
      1.649716,
      NULL,
      NULL,
      0,
      1,
      1.638968,
      0.428527,
      1.853513,
      0,
      0,
      0,
      1.995289,
      NULL,
      0,
      NULL,
      1.415473,
      0,
      0,
      NULL,
      1,
      4,
      0,
      4.611729,
      3.962490,
      1.444660,
      1.055524,
      1.594799,
      1.981880,
      5,
      NULL,
      2.078870,
      9,
      5.046761,
      1.058837,
      NULL,
      5.668080,
      NULL,
      NULL,
      0,
      0,
      0,
      ' 5-11-2001',
      352.232454,
      NULL,
      NULL,
      0.757833,
      NULL,
      1.583524,
      5,
      0.640296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.063370,
      1.162274,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.685050,
      1.369928,
      0.133632,
      1.985214,
      0.702895,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.338233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.879537,
      1.690843,
      NULL,
      0.932668,
      0.491681,
      1,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.967799,
      1.673902,
      NULL,
      1.969772,
      3.460130,
      3,
      0,
      0.003859,
      5.629641,
      3,
      0,
      3.148528,
      3,
      3.343739,
      2.918631,
      2,
      0.077990,
      0,
      5.032714,
      1,
      1.940903,
      1,
      0.173731,
      0.176372,
      NULL,
      0,
      1,
      1,
      NULL,
      2,
      0,
      10.998496,
      9.084836,
      7.119373,
      NULL,
      6.588024,
      3,
      3,
      3.983372,
      3.462820,
      2,
      2.077715,
      3.436021,
      58,
      2.553305,
      1,
      70.293131,
      NULL,
      3.774165,
      67.980519,
      1.673808,
      4.125428,
      1,
      '33032',
      '33301',
      NULL,
      0.390447,
      '',
      '',
      NULL,
      1.357484,
      '',
      NULL,
      '',
      1,
      34.765840,
      74,
      42.209140,
      NULL,
      57.158103,
      2.038631,
      2,
      1,
      NULL,
      1.185907,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286018,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.584177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      7,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.957698,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      2.008208,
      1.721564,
      NULL,
      NULL,
      1.645923,
      1.743866,
      2.055626,
      NULL,
      0,
      NULL,
      1,
      3,
      0.501983,
      2,
      3.856513,
      0.049765,
      3,
      1,
      0.884744,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.096676,
      NULL,
      NULL,
      7.596832,
      3.412775,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.092724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823530,
      NULL,
      NULL,
      2,
      1.962865,
      1.466890,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      2,
      2.920670,
      1.300146,
      NULL,
      NULL,
      NULL,
      0.466820,
      0.324518,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.236572,
      NULL,
      NULL,
      0.525930,
      NULL,
      NULL,
      0.080559,
      NULL,
      NULL,
      0.821683,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      0,
      2.681667,
      NULL,
      NULL,
      2,
      1.313882,
      2.841597,
      1.039399,
      NULL,
      NULL,
      0.307927,
      NULL,
      NULL,
      3.760790,
      3,
      3,
      0.135006,
      1.168075,
      2,
      3,
      3.969158,
      3,
      1.313652,
      1,
      1,
      1.651443,
      0,
      NULL,
      3,
      2.284630,
      0.122613,
      3,
      0.617906,
      2,
      0.827782,
      4.979153,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      4,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.034207,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.187027,
      1.195005,
      0.990573,
      0,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885271,
      1.035938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.008902,
      0.024307,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132195,
      1.754392,
      NULL,
      NULL,
      1,
      1.995613,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.529599,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.423560,
      14,
      NULL,
      1.597864,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.239984,
      NULL,
      1.701746,
      140,
      0,
      1,
      1,
      NULL,
      1,
      1.653981,
      1,
      1,
      0.166300,
      0,
      NULL,
      1.929598,
      3.628073,
      1,
      0.326667,
      NULL,
      1.789366,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.294934,
      NULL,
      0,
      NULL,
      0,
      NULL,
      89.354164,
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      0,
      NULL,
      NULL,
      0.888310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.043456,
      NULL,
      0.503216,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305349,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.730401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.914260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      0.588035,
      NULL,
      NULL,
      0,
      NULL,
      1.042479,
      1,
      0.837966,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.047463,
      0.258268,
      NULL,
      NULL,
      0.009451,
      3,
      1,
      NULL,
      1,
      NULL,
      1.865301,
      0.153814,
      0.818556,
      NULL,
      0,
      2.054733,
      2,
      NULL,
      NULL,
      0,
      0.232150,
      1,
      NULL,
      1.001283,
      0.245121,
      NULL,
      0.100633,
      1,
      1,
      0.218645,
      1,
      1,
      1.003415,
      NULL,
      1,
      0.229306,
      0.136253,
      NULL,
      NULL,
      1,
      NULL,
      0.885037,
      1.142692,
      0.355055,
      NULL,
      1,
      1.496002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361469,
      1,
      1.995998,
      1,
      NULL,
      1,
      4,
      8,
      6,
      0.443219,
      NULL,
      1.467566,
      NULL,
      36,
      5,
      2.736888,
      2.046971,
      '41302',
      '24244',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


