set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7214550';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '01',
      39,
      NULL,
      '4433204',
      1.246900,
      NULL,
      6,
      NULL,
      NULL,
      5,
      0.680684,
      NULL,
      NULL,
      ' 0-16-2002',
      NULL,
      17.576627,
      NULL,
      1.961245,
      2,
      ' 6-12-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      2.258212,
      ' 8-21-1976',
      ' 2-20-2001',
      ' 1-20-1975',
      NULL,
      2,
      2,
      2.841520,
      1.058764,
      1.004494,
      3.797741,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.362008,
      0.681555,
      NULL,
      1.129213,
      0.178555,
      1,
      0,
      0.598871,
      0.582934,
      0.156553,
      NULL,
      0,
      NULL,
      0.285379,
      11.195762,
      1.284607,
      1,
      5,
      NULL,
      1.835652,
      NULL,
      1.609125,
      NULL,
      1,
      0,
      0.433150,
      9.035210,
      1.138052,
      1.887492,
      1,
      1,
      2,
      1,
      1,
      3,
      0.249923,
      NULL,
      4,
      1.178141,
      0,
      1,
      NULL,
      0.503572,
      NULL,
      2,
      0.131864,
      NULL,
      1.398272,
      NULL,
      3,
      0.710378,
      0.703149,
      0,
      1,
      1,
      0.207372,
      1.510642,
      1.769735,
      NULL,
      9,
      0.383568,
      0.695169,
      1,
      0,
      0.022781,
      3,
      3,
      NULL,
      0,
      9.731087,
      5,
      0,
      0.964090,
      3.952833,
      8.046911,
      5.478317,
      8.286266,
      2,
      0,
      1,
      5.431351,
      1.989093,
      8.848638,
      0,
      1.780843,
      0,
      1,
      2.296647,
      NULL,
      2.023854,
      1,
      NULL,
      4.065488,
      NULL,
      0.966270,
      0.684084,
      0.645324,
      1,
      1,
      1,
      1.693321,
      0,
      NULL,
      1,
      3.245031,
      3.398631,
      0,
      3.050581,
      0,
      2,
      8.660845,
      7.998313,
      9.060553,
      6.564174,
      0,
      7,
      0.024779,
      ' 3-16-1998',
      3,
      NULL,
      NULL,
      NULL,
      1.434354,
      3,
      3,
      0,
      NULL,
      3.762165,
      0,
      1,
      NULL,
      0.611405,
      0,
      2,
      0.941723,
      3,
      7.746671,
      NULL,
      7.089586,
      NULL,
      5,
      3.417546,
      ' 7- 5-1975',
      2.253020,
      ' 8- 0-1978',
      NULL,
      0.982612,
      2,
      1,
      4.600250,
      NULL,
      4,
      2.940273,
      3,
      0.260995,
      0.171549,
      1.937552,
      1.138459,
      3,
      1,
      5,
      NULL,
      NULL,
      3.629611,
      1,
      3,
      1,
      0.289924,
      1,
      5.376558,
      4.527165,
      6,
      0,
      1.423014,
      NULL,
      NULL,
      NULL,
      0.256227,
      0,
      NULL,
      NULL,
      6,
      1.316799,
      '11- 8-1987',
      2.494387,
      ' 6-12-1981',
      1.080667,
      NULL,
      1,
      0.932444,
      3.838014,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      2.527291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.603670,
      1,
      2.542793,
      2,
      0,
      1,
      1.820157,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2.104633,
      NULL,
      1.880999,
      NULL,
      2.383384,
      1,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      1,
      2.824164,
      0.527492,
      6.712820,
      7,
      4.099176,
      4.491507,
      NULL,
      NULL,
      3,
      2,
      6.810196,
      NULL,
      2.175442,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      1,
      NULL,
      NULL,
      '14323',
      '44010',
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.593902,
      64,
      0.503202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.614009,
      1,
      1.364697,
      1.339985,
      NULL,
      NULL,
      0.853769,
      NULL,
      NULL,
      1.299898,
      0,
      1,
      NULL,
      0,
      1.843710,
      0.663984,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      529,
      NULL,
      2,
      0.552114,
      2,
      1.684084,
      1,
      0,
      0.182364,
      NULL,
      0.687909,
      0.069489,
      1,
      1,
      NULL,
      1.005389,
      NULL,
      NULL,
      1.648608,
      0,
      1,
      NULL,
      3.320735,
      NULL,
      NULL,
      NULL,
      0.465751,
      NULL,
      1.094014,
      NULL,
      111.132504,
      NULL,
      3.450934,
      NULL,
      52,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.640309,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.226773,
      NULL,
      0.024885,
      NULL,
      1.616505,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.383155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209187,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422816,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      1.567489,
      8.392758,
      NULL,
      4,
      2.192381,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1.528312,
      0,
      NULL,
      1,
      0,
      NULL,
      0.725548,
      1.896882,
      NULL,
      NULL,
      1.480232,
      NULL,
      0.657073,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.917613,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.563651,
      0,
      NULL,
      3,
      2.728800,
      NULL,
      0.042801,
      1,
      1.944065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.251919,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.754037,
      5,
      9,
      0,
      NULL,
      NULL,
      40,
      51.667385,
      1,
      2,
      1,
      '32002',
      '34311',
      '',
      NULL,
      NULL,
      '',
      '',
      1.930768,
      '',
      '',
      '');
commit;
end;
/


