set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8233883';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      '0132',
      2,
      1.517162,
      NULL,
      NULL,
      ' 7- 6-1990',
      0.174163,
      NULL,
      5.406343,
      3,
      NULL,
      ' 9- 0-1978',
      85.861376,
      NULL,
      186.184219,
      51.543736,
      4,
      NULL,
      NULL,
      '11-14-1998',
      NULL,
      0,
      3.418870,
      0.277977,
      0,
      0.335736,
      NULL,
      1,
      NULL,
      NULL,
      3.200294,
      NULL,
      6,
      13,
      23.171140,
      7.955905,
      26,
      0.696475,
      12.178872,
      4.030650,
      NULL,
      0.779402,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0.143129,
      NULL,
      2.585674,
      0.822374,
      2.531753,
      0,
      1,
      0.071113,
      0.937690,
      NULL,
      1,
      1,
      5,
      0.749397,
      1.415293,
      0.425526,
      1.755227,
      NULL,
      3.039621,
      1,
      4,
      1,
      NULL,
      0.102237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.192667,
      0.355267,
      NULL,
      1,
      1,
      0.235866,
      0,
      0.421017,
      1.556681,
      1,
      1.012351,
      0,
      1,
      NULL,
      NULL,
      0.865126,
      1,
      1.708424,
      1,
      1,
      0,
      3,
      6,
      1.370504,
      1.631818,
      1,
      NULL,
      NULL,
      0.580952,
      NULL,
      NULL,
      1.432170,
      6.144503,
      9,
      2.533148,
      6.823683,
      3,
      6.481198,
      0,
      2.245523,
      1.062883,
      1,
      0.671043,
      NULL,
      7.394156,
      1.246562,
      1.571417,
      NULL,
      0.246931,
      0.428107,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      6.950827,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.762135,
      5,
      0.576411,
      10.189702,
      6.621842,
      0,
      1.879153,
      5,
      NULL,
      10,
      10.829065,
      8.219043,
      8.815150,
      1.977404,
      6.206799,
      1.200644,
      ' 2- 2-1985',
      64,
      '11-20-1980',
      1319,
      1.704341,
      0.709599,
      0.892060,
      0.959093,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565207,
      0.743473,
      1,
      1.312719,
      0,
      1.280036,
      1,
      1.902241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3.767956,
      0.021713,
      4,
      0.111977,
      NULL,
      NULL,
      NULL,
      1.105421,
      NULL,
      0.736102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.072659,
      1,
      1.970461,
      0.832978,
      0.683057,
      0.457864,
      2,
      7068,
      NULL,
      0.252686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.013064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.947851,
      NULL,
      NULL,
      NULL,
      5.335300,
      1.684845,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.302951,
      NULL,
      NULL,
      '',
      3.346936,
      NULL,
      1276,
      1,
      3,
      35.397133,
      NULL,
      630.745976,
      NULL,
      3.678883,
      0.246309,
      NULL,
      1.879622,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.019857,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.227747,
      NULL,
      NULL,
      3.419374,
      0.755833,
      3.355691,
      1.873425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507957,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      4,
      1,
      3.501736,
      0.011266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266678,
      1,
      3.159952,
      8,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      2,
      1,
      0.475467,
      NULL,
      0,
      NULL,
      1.405826,
      0.620802,
      1.595031,
      0,
      NULL,
      NULL,
      NULL,
      1.775447,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.153653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161212,
      NULL,
      5,
      NULL,
      0.304689,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.649113,
      NULL,
      1.349761,
      3,
      0.401667,
      3,
      1.940802,
      NULL,
      NULL,
      7,
      0,
      NULL,
      2,
      3.449017,
      1.196315,
      0.931840,
      NULL,
      NULL,
      3.396931,
      6.670991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846813,
      NULL,
      NULL,
      0.546594,
      NULL,
      NULL,
      1.027923,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.909809,
      NULL,
      NULL,
      0,
      2.953452,
      8.210369,
      0,
      5.194399,
      0,
      8.548294,
      3.041979,
      1.681264,
      7,
      5.289721,
      NULL,
      2.396041,
      0.834100,
      1,
      2,
      3.839272,
      3,
      NULL,
      3.409800,
      3,
      6.614402,
      2,
      2,
      2,
      1.003486,
      3.108083,
      NULL,
      0.922369,
      3,
      0.361730,
      1.004582,
      NULL,
      2.906836,
      2.280123,
      7,
      6,
      6.685395,
      5,
      0.612191,
      NULL,
      1,
      3.372114,
      NULL,
      NULL,
      0.930675,
      1,
      0.505223,
      1.778733,
      2.909463,
      NULL,
      NULL,
      1.791802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.627905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.229746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315597,
      NULL,
      NULL,
      0.215232,
      NULL,
      NULL,
      1.068886,
      0,
      0.173845,
      1,
      1,
      1.480818,
      0.579721,
      NULL,
      NULL,
      1.330072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.221360,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.740954,
      NULL,
      NULL,
      NULL,
      1.237380,
      NULL,
      NULL,
      NULL,
      2.778009,
      795,
      313.854159,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.003724,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.378862,
      1.834963,
      1,
      1,
      0,
      1,
      NULL,
      1.399278,
      0,
      1.200883,
      0.940935,
      NULL,
      0.322091,
      1.507004,
      0.317689,
      0,
      0.013489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931479,
      0,
      1.767757,
      1.551555,
      0.606272,
      2,
      0.380144,
      1.952152,
      1.430503,
      0.117248,
      0.574652,
      0.367271,
      0,
      NULL,
      0.182734,
      1.784156,
      NULL,
      0,
      1.445987,
      NULL,
      0.956165,
      1,
      NULL,
      1.447946,
      0.140900,
      NULL,
      1,
      1.699675,
      NULL,
      0,
      0,
      NULL,
      0.876749,
      NULL,
      NULL,
      NULL,
      0.147259,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.412280,
      NULL,
      0.817343,
      1,
      0.855423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.653506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      8,
      NULL,
      0.380621,
      NULL,
      3,
      0,
      5.493600,
      15.176376,
      5,
      1,
      1.628939,
      '12124',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.848615,
      '',
      '',
      '');
commit;
end;
/


