set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7624278';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      2.948634,
      NULL,
      3,
      3,
      '1011',
      2,
      2.018220,
      1.874024,
      10,
      '11- 8-1996',
      NULL,
      NULL,
      3.390723,
      NULL,
      1,
      ' 6-25-1989',
      32,
      NULL,
      178,
      NULL,
      9.978043,
      NULL,
      NULL,
      '11- 1-1988',
      3,
      0.841685,
      1,
      1.282234,
      0.086405,
      1,
      NULL,
      NULL,
      1.098057,
      1.452069,
      4,
      6.149710,
      NULL,
      16.101440,
      NULL,
      7.863035,
      NULL,
      NULL,
      2.655363,
      8.484559,
      0,
      NULL,
      0.086530,
      0,
      0,
      0,
      1,
      NULL,
      0.077947,
      1,
      NULL,
      1,
      6.651222,
      1.232452,
      3.297046,
      0,
      0.232883,
      NULL,
      0,
      1.969388,
      1,
      2.246804,
      3.068195,
      0,
      2,
      NULL,
      0.933374,
      NULL,
      0,
      0,
      0.084049,
      2,
      0,
      NULL,
      NULL,
      0.133278,
      NULL,
      NULL,
      0,
      0,
      1.218187,
      1.768512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.298117,
      1,
      0,
      0.613446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.488353,
      0.556790,
      0.049463,
      2.665038,
      2.382147,
      3,
      1.564684,
      0,
      0,
      5,
      0,
      1.227401,
      0.856774,
      1.236013,
      1.843662,
      1.069696,
      0.132535,
      1,
      NULL,
      1,
      0.949156,
      1,
      1,
      1,
      0,
      1.797498,
      5,
      3,
      4,
      NULL,
      1,
      0.239096,
      NULL,
      2,
      3.524766,
      9.224567,
      7,
      8,
      5,
      0,
      4.806622,
      6.769133,
      0,
      5,
      1.272600,
      5.745654,
      2,
      NULL,
      NULL,
      ' 2-13-1997',
      469.775279,
      2,
      NULL,
      1.413274,
      2.753203,
      0.383155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474897,
      NULL,
      0.627171,
      1,
      NULL,
      NULL,
      NULL,
      0.876052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.894140,
      2.755313,
      0.728897,
      NULL,
      NULL,
      NULL,
      NULL,
      1.645138,
      5,
      2.983196,
      1.235593,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0.663412,
      1.228478,
      0.655307,
      NULL,
      2,
      1.910171,
      NULL,
      NULL,
      NULL,
      4.118829,
      1,
      0,
      5.235356,
      1,
      1.061833,
      NULL,
      5,
      NULL,
      1.969606,
      0.638125,
      1.910806,
      2,
      3,
      3,
      3,
      0,
      2,
      1.019632,
      0.118435,
      0.770420,
      1,
      1.236096,
      NULL,
      0.935638,
      NULL,
      0,
      0.499163,
      0.635963,
      NULL,
      NULL,
      1.949283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      NULL,
      NULL,
      7.403922,
      0,
      4,
      NULL,
      '34300',
      '',
      0.959143,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      49,
      0.274339,
      48.420328,
      5,
      NULL,
      1,
      0,
      1,
      2,
      0,
      1,
      1.475434,
      NULL,
      NULL,
      0,
      2,
      0.914082,
      1.787468,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.591653,
      NULL,
      2.823589,
      1.953674,
      2.774699,
      3,
      NULL,
      0,
      1,
      1.350817,
      0,
      3.284288,
      1,
      2.838033,
      0.431269,
      NULL,
      NULL,
      7.600013,
      NULL,
      4.248078,
      1.851875,
      0.632787,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816749,
      1.664314,
      NULL,
      2,
      0.131017,
      1,
      3,
      2,
      1.727388,
      0,
      1,
      0,
      2,
      1.072028,
      NULL,
      2,
      0.703616,
      2,
      NULL,
      3,
      NULL,
      3.586032,
      NULL,
      3,
      1,
      0.253627,
      0,
      3,
      0.492612,
      1.723832,
      0,
      1.896374,
      NULL,
      1.188689,
      0,
      NULL,
      1,
      1.016255,
      7,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      1,
      1.757835,
      0,
      1.903878,
      1,
      2.042986,
      0,
      2,
      NULL,
      0.141007,
      1,
      NULL,
      NULL,
      1,
      3,
      0.544074,
      NULL,
      NULL,
      NULL,
      0,
      1.854296,
      1.727913,
      NULL,
      0,
      0.243488,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811173,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.488686,
      NULL,
      NULL,
      0.820585,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.825268,
      1,
      NULL,
      2.215918,
      1,
      1.313990,
      3.800435,
      1,
      0,
      NULL,
      2,
      4.677318,
      NULL,
      NULL,
      NULL,
      3.940141,
      1.533835,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      8,
      6,
      5,
      7.595336,
      0.972185,
      1.769727,
      NULL,
      3.617816,
      NULL,
      1.090912,
      NULL,
      0,
      1.996698,
      0,
      1,
      NULL,
      NULL,
      4.854213,
      NULL,
      NULL,
      0.049080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848176,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.590383,
      NULL,
      NULL,
      1.713369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271697,
      NULL,
      NULL,
      0.438623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.444635,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.903965,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.104034,
      1,
      NULL,
      NULL,
      0.697879,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170666,
      1.767679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.009594,
      1.107468,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.787469,
      NULL,
      NULL,
      NULL,
      1.274244,
      NULL,
      NULL,
      NULL,
      3.669516,
      3.789534,
      NULL,
      NULL,
      1.744464,
      1.791954,
      NULL,
      NULL,
      2.657684,
      0.275194,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.362602,
      NULL,
      NULL,
      0,
      0.228876,
      NULL,
      NULL,
      1.330886,
      1.388717,
      NULL,
      NULL,
      4.432452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      8.010783,
      0.683418,
      1.880359,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      12.489470,
      0.792344,
      0.707485,
      6.548957,
      NULL,
      1.898630,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10174.429904,
      1669,
      0,
      0,
      1.926862,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1.787874,
      2.784128,
      0.716091,
      1.153554,
      1.863979,
      0,
      0,
      2,
      NULL,
      1.887122,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      191.908004,
      NULL,
      5,
      37,
      12,
      2.730634,
      2,
      4.772109,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.391881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.239803,
      NULL,
      1,
      NULL,
      1,
      3.948174,
      0,
      1.136775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.614626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.478274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.945229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075307,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.360058,
      NULL,
      1,
      NULL,
      1.363243,
      0,
      2.412104,
      10.729878,
      26.921651,
      NULL,
      3,
      NULL,
      NULL,
      1.210617,
      3,
      NULL,
      1,
      NULL,
      2.473537,
      NULL,
      2.806815,
      11,
      NULL,
      2,
      0.807545,
      0,
      1,
      0.729289,
      NULL,
      1,
      2,
      0.462548,
      NULL,
      NULL,
      NULL,
      1.698963,
      3.232268,
      0.861249,
      0.914925,
      1,
      0.400166,
      0,
      1.745004,
      0.497576,
      2.137621,
      0,
      1.402945,
      0.756256,
      1,
      NULL,
      12.964764,
      NULL,
      NULL,
      2.153090,
      3,
      1,
      1,
      0,
      2,
      1.206708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.312064,
      1.817843,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.301620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.982783,
      NULL,
      0.920419,
      NULL,
      NULL,
      NULL,
      1.360572,
      NULL,
      0,
      NULL,
      0,
      0.981260,
      NULL,
      1.626777,
      NULL,
      0,
      NULL,
      6,
      11.216852,
      2,
      1.462479,
      1,
      4.146906,
      NULL,
      2,
      0,
      NULL,
      NULL,
      '33313',
      '33320',
      1.779987,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


