set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7407185';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '4114044',
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.636990,
      2.617201,
      56.951141,
      ' 5-10-1997',
      NULL,
      NULL,
      2,
      0.850026,
      NULL,
      ' 1-16-1986',
      73,
      3,
      299,
      10.506805,
      5,
      NULL,
      NULL,
      ' 2- 7-1984',
      2,
      1.842424,
      1,
      NULL,
      1,
      0.902107,
      1.971638,
      1.623773,
      NULL,
      NULL,
      NULL,
      5,
      5,
      0,
      NULL,
      7,
      8,
      NULL,
      0.185612,
      NULL,
      1,
      0,
      2.365625,
      0,
      0,
      1.386754,
      NULL,
      NULL,
      0.531719,
      NULL,
      1,
      2,
      2.077005,
      NULL,
      1.697169,
      1,
      NULL,
      NULL,
      1,
      1.092102,
      NULL,
      4,
      0,
      1,
      1,
      1,
      1.616846,
      3.803030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.938309,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.682972,
      1.415730,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.210643,
      1,
      0,
      0,
      0.540065,
      1.323608,
      3,
      NULL,
      0,
      1.211737,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      3.409851,
      0.207277,
      5,
      NULL,
      0,
      NULL,
      0.372503,
      6.877716,
      4,
      NULL,
      5,
      2.269355,
      1,
      5.310944,
      3.366215,
      5.756241,
      7,
      1,
      NULL,
      0.283021,
      NULL,
      5,
      0,
      3.243759,
      5,
      1.903899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529857,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.469308,
      1.839220,
      1.471018,
      1,
      2,
      0.209492,
      1.214691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.222402,
      5,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      0.569856,
      1.027946,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449080,
      NULL,
      0.976720,
      3.129716,
      0,
      0.989011,
      1.392747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.070476,
      1.705828,
      0.401868,
      1,
      0.291195,
      2.984789,
      0.930106,
      0.900556,
      2.684792,
      0,
      3.777674,
      3,
      2,
      1.657643,
      0,
      1.939510,
      0,
      1.301685,
      NULL,
      2.476836,
      NULL,
      0.547029,
      NULL,
      NULL,
      0.718224,
      1.201534,
      0,
      NULL,
      2,
      NULL,
      3,
      0.193573,
      11,
      7.086715,
      2,
      1.429390,
      4.818427,
      3,
      5,
      0.219842,
      2.163293,
      NULL,
      0,
      2.988705,
      35,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      '30200',
      '',
      '',
      1.524659,
      '34412',
      NULL,
      '',
      1,
      '01344',
      NULL,
      '21421',
      0,
      39,
      208.913569,
      84.482516,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.216939,
      0.499362,
      0,
      0,
      NULL,
      NULL,
      0.038144,
      NULL,
      NULL,
      0.038729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.293796,
      NULL,
      NULL,
      0.458274,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.468299,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0.728714,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.950766,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.724569,
      1.681648,
      1.015993,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0.006032,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617288,
      NULL,
      NULL,
      1.672994,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.761192,
      2.383581,
      NULL,
      0,
      NULL,
      NULL,
      4.506584,
      5,
      3.099571,
      1,
      0,
      0,
      0.915267,
      NULL,
      NULL,
      3,
      0.076621,
      NULL,
      NULL,
      1,
      1.567089,
      3,
      0,
      2.158216,
      3.575518,
      4.424556,
      NULL,
      2,
      3.984487,
      0.213760,
      0.603712,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.001999,
      3.080689,
      1,
      3,
      5.650217,
      0,
      NULL,
      3.284480,
      3,
      0.304137,
      5,
      1,
      NULL,
      1,
      0,
      1,
      1,
      2.572666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.313936,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188853,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.538535,
      NULL,
      NULL,
      2,
      NULL,
      3.370593,
      0.110825,
      0.737684,
      2.626559,
      0,
      3.180450,
      NULL,
      7,
      3,
      3.096390,
      NULL,
      4,
      8,
      3,
      NULL,
      3.768895,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1.553636,
      NULL,
      NULL,
      1.092487,
      NULL,
      NULL,
      NULL,
      3.643472,
      NULL,
      1.049984,
      NULL,
      3.471943,
      1,
      0.151378,
      NULL,
      3,
      NULL,
      3.675960,
      NULL,
      0,
      NULL,
      1.459687,
      NULL,
      3.831135,
      NULL,
      1,
      NULL,
      0.821764,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.812137,
      NULL,
      1,
      0,
      3.987966,
      NULL,
      3.858380,
      0.808588,
      0,
      NULL,
      1.295947,
      3.877821,
      NULL,
      NULL,
      1,
      1.911076,
      NULL,
      NULL,
      1.625734,
      2,
      0.465655,
      NULL,
      0.533251,
      0,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.364298,
      NULL,
      3.206415,
      3,
      0,
      NULL,
      1.407827,
      NULL,
      NULL,
      NULL,
      99.340408,
      7.306966,
      0.309555,
      NULL,
      NULL,
      1.477822,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      412,
      NULL,
      1.852340,
      3.332228,
      NULL,
      1.124253,
      NULL,
      3.651371,
      1,
      0,
      0,
      0,
      1,
      0.648749,
      0,
      0,
      0,
      0.726114,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.836936,
      NULL,
      NULL,
      NULL,
      2.859412,
      NULL,
      0,
      NULL,
      9,
      NULL,
      5,
      34.388265,
      23,
      1.414537,
      0.349015,
      NULL,
      NULL,
      1.364228,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.290702,
      NULL,
      1.288623,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.965503,
      NULL,
      1.927780,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.297016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.751261,
      NULL,
      NULL,
      NULL,
      0.158838,
      3,
      8.229235,
      3.513343,
      1.015445,
      2.075197,
      0,
      1,
      1,
      0,
      1.030633,
      0,
      0,
      3.256130,
      NULL,
      1.595109,
      1,
      0.588528,
      2.484240,
      1,
      1,
      NULL,
      1,
      2,
      NULL,
      0,
      0,
      2.216140,
      1.281464,
      1.870866,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0.720412,
      1.436023,
      0,
      1.677775,
      1.223138,
      1.920020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      NULL,
      1,
      0.895291,
      0.062901,
      NULL,
      0,
      NULL,
      1.640996,
      0.225988,
      NULL,
      NULL,
      1,
      1.494046,
      0,
      1,
      0.386360,
      1.816458,
      0.627932,
      NULL,
      1.714962,
      1,
      1,
      0,
      86.589008,
      1,
      NULL,
      0.957921,
      0,
      1,
      1,
      0,
      0.753038,
      0,
      5,
      NULL,
      2.313221,
      0.260166,
      2.927785,
      60,
      NULL,
      NULL,
      0,
      3,
      '32123',
      '04124',
      '',
      2,
      NULL,
      '',
      '',
      3,
      '33104',
      '244',
      '04130');
commit;
end;
/


