set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9036757';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.410797,
      3.612483,
      3.545108,
      1.847361,
      NULL,
      NULL,
      0.051095,
      0,
      '022',
      '44304403',
      61.919480,
      21,
      '1310032',
      0.025158,
      NULL,
      3,
      0,
      NULL,
      3,
      0.191253,
      NULL,
      NULL,
      ' 6- 1-1991',
      132,
      27.501972,
      NULL,
      NULL,
      1,
      ' 3-15-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      4.239911,
      NULL,
      NULL,
      '10-23-1994',
      NULL,
      3,
      1.079369,
      NULL,
      1.268706,
      NULL,
      2,
      1.897406,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.467295,
      1.417565,
      1.943385,
      1,
      1.986993,
      3.736654,
      1.766708,
      1.059775,
      0,
      2.251468,
      3.646121,
      9.216021,
      2,
      3,
      0,
      0.596126,
      NULL,
      1.308096,
      0,
      1,
      0,
      2.867637,
      NULL,
      2,
      NULL,
      2,
      1.270110,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.581310,
      NULL,
      0.744907,
      NULL,
      NULL,
      0.465824,
      NULL,
      1.499213,
      0,
      NULL,
      0.396931,
      2.140867,
      3,
      NULL,
      0,
      2.299752,
      0,
      2.134559,
      1.568661,
      3,
      3,
      NULL,
      0.471265,
      0,
      0.878123,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      6,
      0,
      NULL,
      5.279506,
      1.091157,
      0,
      0,
      0,
      0.903846,
      NULL,
      1.091578,
      5.300415,
      1,
      0,
      1,
      1,
      1.244259,
      NULL,
      0,
      0.777441,
      3.686967,
      0,
      0,
      0.723889,
      4,
      3,
      0.095885,
      0.265873,
      1.697976,
      NULL,
      1.002932,
      4.535622,
      NULL,
      3.269346,
      7.497691,
      NULL,
      7.501909,
      5,
      6.969065,
      1,
      NULL,
      NULL,
      2,
      7,
      4,
      3,
      ' 9- 6-1975',
      256,
      ' 2-24-1976',
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.875792,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2.971739,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.734180,
      1.594680,
      2,
      0.634843,
      NULL,
      3,
      1.558229,
      1.295338,
      5.684021,
      0,
      1,
      5.633042,
      1.738743,
      NULL,
      NULL,
      NULL,
      0,
      1.407264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.549888,
      3,
      0.063747,
      NULL,
      1.444818,
      0,
      0,
      0,
      0,
      NULL,
      0.410943,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.890945,
      2,
      0.602733,
      NULL,
      0.886645,
      2,
      1,
      NULL,
      3,
      1.998309,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.044420,
      0.695196,
      0.685420,
      1.764782,
      1.500057,
      1.370673,
      1.558034,
      1.483656,
      1,
      0.416715,
      3.496395,
      0.756952,
      2.418161,
      6.225836,
      6.882303,
      3,
      8,
      2,
      5,
      3.194433,
      7,
      0,
      3,
      0,
      39.514263,
      0,
      NULL,
      NULL,
      NULL,
      57,
      8,
      NULL,
      NULL,
      NULL,
      '11242',
      '',
      '',
      0.874163,
      '',
      NULL,
      '',
      1,
      '33204',
      '2104',
      '',
      NULL,
      5.074624,
      97,
      11.723293,
      NULL,
      2.063513,
      9.397251,
      8.623696,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.701608,
      NULL,
      NULL,
      0.876402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.486113,
      0,
      NULL,
      3.761834,
      0.665334,
      2.580626,
      1.958118,
      NULL,
      NULL,
      1.728362,
      NULL,
      NULL,
      0.640815,
      NULL,
      NULL,
      0.024385,
      NULL,
      NULL,
      1.865536,
      NULL,
      NULL,
      4,
      5.994346,
      0,
      0.262025,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.296650,
      1,
      0.183050,
      0.756161,
      1,
      1.613488,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.905768,
      1,
      2.373914,
      3.417695,
      2.272035,
      3,
      1.232231,
      2,
      1.235840,
      3,
      1.800581,
      2,
      1.383745,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.132509,
      1.753483,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1.497212,
      NULL,
      3,
      0.857862,
      NULL,
      NULL,
      3.981551,
      7.098856,
      NULL,
      1.962915,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.427735,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.822605,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.409924,
      NULL,
      1.719118,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.201691,
      NULL,
      NULL,
      0.322607,
      0.864749,
      1.599320,
      1.992303,
      1,
      2,
      1,
      NULL,
      NULL,
      2.137246,
      0.113423,
      3,
      3.909382,
      1,
      0.538319,
      3.968509,
      0.090592,
      0,
      0,
      3.022693,
      2.815488,
      NULL,
      1.033892,
      0,
      9.202293,
      5.278564,
      0.201522,
      4,
      1.801846,
      1,
      0.162040,
      0,
      NULL,
      0,
      1,
      0,
      1.948576,
      0,
      0.336043,
      NULL,
      NULL,
      0.057817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.312203,
      NULL,
      NULL,
      0.806785,
      NULL,
      NULL,
      0.470867,
      NULL,
      NULL,
      1.043596,
      NULL,
      NULL,
      0.108652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.993168,
      1.655770,
      1,
      0.805880,
      NULL,
      1,
      NULL,
      NULL,
      4.678761,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1.451292,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.933457,
      NULL,
      NULL,
      NULL,
      0.641304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498704,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.492133,
      NULL,
      NULL,
      NULL,
      0.454063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.326945,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621063,
      0,
      0.200736,
      3,
      51.564811,
      10.693995,
      3.346117,
      58,
      7.913357,
      0,
      NULL,
      NULL,
      1.807981,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.717148,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      42.730482,
      5.474303,
      1.659343,
      1.165572,
      1.724620,
      0,
      NULL,
      0.963663,
      NULL,
      1,
      1,
      0.828615,
      1,
      1.680786,
      NULL,
      1.239949,
      0.907755,
      NULL,
      0.620404,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.990524,
      1.457009,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.117648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.278082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.970674,
      NULL,
      0.487729,
      NULL,
      NULL,
      NULL,
      1.381141,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289919,
      NULL,
      NULL,
      1.373377,
      NULL,
      1.881178,
      NULL,
      NULL,
      NULL,
      0.308588,
      1.770386,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.746912,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.100640,
      3,
      3,
      0,
      0.266787,
      NULL,
      2,
      2.823270,
      NULL,
      0.314973,
      1,
      0.990291,
      3,
      NULL,
      NULL,
      3.989894,
      3.405564,
      NULL,
      3,
      2,
      NULL,
      3.595798,
      NULL,
      NULL,
      1.727508,
      0,
      NULL,
      0.888209,
      NULL,
      NULL,
      1.281285,
      3.872344,
      NULL,
      3.951258,
      1,
      NULL,
      NULL,
      3.395217,
      NULL,
      2.128578,
      3.359940,
      NULL,
      0.210256,
      0.071011,
      NULL,
      1,
      0.929171,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716538,
      NULL,
      1.783103,
      NULL,
      1,
      NULL,
      1,
      4.037937,
      4,
      NULL,
      1,
      0.445490,
      40.242954,
      62.438138,
      2,
      5,
      0.600507,
      '02123',
      NULL,
      NULL,
      1.267923,
      '',
      '',
      '',
      NULL,
      '24002',
      '1421',
      NULL);
commit;
end;
/


