set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9758892';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.595511,
      5.374546,
      3,
      4,
      2.104935,
      1.463880,
      2,
      NULL,
      NULL,
      '20244411',
      15.829068,
      35,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '0230',
      3.387738,
      1.539360,
      NULL,
      NULL,
      '10-23-1975',
      77.621089,
      245.450535,
      NULL,
      0,
      0,
      ' 9-18-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      3.283430,
      ' 8-15-1990',
      '10-22-1978',
      ' 0-26-1984',
      1.923817,
      1,
      1.243071,
      0,
      1,
      1,
      NULL,
      1.360616,
      0.743290,
      NULL,
      10.254062,
      8.673757,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.050196,
      NULL,
      1.000222,
      NULL,
      5,
      NULL,
      0,
      1,
      0.160835,
      0,
      1.604134,
      NULL,
      1,
      3.477840,
      9.365756,
      10,
      2,
      2.629685,
      0.718913,
      2.789564,
      1.397710,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      2.225343,
      0.065979,
      3,
      NULL,
      1,
      2.428106,
      NULL,
      4.949060,
      1.819796,
      NULL,
      NULL,
      3,
      NULL,
      0.168759,
      1.728443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.676191,
      5,
      0.280972,
      1.520709,
      1,
      0,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.128855,
      1.130721,
      NULL,
      0,
      2.188990,
      5.576131,
      4.087466,
      0.410705,
      NULL,
      1,
      2,
      4.718433,
      0.364139,
      NULL,
      0,
      1,
      NULL,
      1.730526,
      0.405240,
      NULL,
      0,
      0,
      1,
      0.783448,
      0,
      1,
      0.399986,
      1,
      0,
      1.667283,
      0.361529,
      0.636605,
      NULL,
      0,
      1,
      NULL,
      0.763426,
      0,
      5.296661,
      0,
      4,
      1,
      NULL,
      1,
      2.597362,
      5.314786,
      NULL,
      0.964933,
      ' 9-17-1999',
      1.184115,
      ' 9-21-1986',
      NULL,
      0.345489,
      0.272232,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1.064978,
      1.495564,
      1,
      0.524709,
      3,
      NULL,
      NULL,
      0,
      4,
      7.454204,
      0.802897,
      3.829165,
      0.280171,
      3,
      NULL,
      10.728612,
      NULL,
      5.020817,
      NULL,
      NULL,
      1.019173,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.451932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      2,
      NULL,
      1.107046,
      1.086342,
      0,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.335154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.143161,
      0.138873,
      2,
      2,
      NULL,
      1.504510,
      NULL,
      NULL,
      0.775199,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      3,
      3,
      3.602820,
      3.822462,
      0.971825,
      NULL,
      2.597108,
      1,
      3,
      2,
      3,
      2.818777,
      2,
      NULL,
      1.543487,
      1,
      0,
      1,
      1.294041,
      1,
      0,
      0.554422,
      NULL,
      0,
      1.789275,
      0.313458,
      2,
      1.386195,
      0.461872,
      0.612453,
      8,
      2.833056,
      5.976686,
      7,
      7.466586,
      5.350347,
      0,
      2,
      2,
      2,
      2,
      63,
      3.562772,
      1.372863,
      16,
      NULL,
      50,
      13.022236,
      3.163019,
      NULL,
      4,
      NULL,
      '34110',
      '',
      NULL,
      NULL,
      '',
      '',
      0.002721,
      NULL,
      '',
      '',
      2,
      NULL,
      9,
      41.106325,
      0.824987,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110130,
      NULL,
      NULL,
      0.870742,
      NULL,
      NULL,
      0.299469,
      NULL,
      NULL,
      0.006562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525435,
      NULL,
      NULL,
      0.718973,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.278872,
      NULL,
      NULL,
      1.652595,
      NULL,
      NULL,
      0.478910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341057,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.164772,
      NULL,
      NULL,
      1.293478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276806,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.487765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739758,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.158088,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361651,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435167,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.237789,
      NULL,
      NULL,
      1.387847,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.850912,
      NULL,
      NULL,
      0.516405,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.454824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.180027,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.677086,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.989215,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656902,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.543586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3.692526,
      NULL,
      1.331968,
      NULL,
      NULL,
      NULL,
      NULL,
      1.775826,
      1.578908,
      1.053000,
      37.731904,
      0.976696,
      1,
      NULL,
      NULL,
      1.902928,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712372,
      376.669783,
      1.063010,
      NULL,
      0,
      1,
      0.784189,
      0,
      0.342443,
      0.758968,
      0,
      NULL,
      1,
      1,
      1.259306,
      0,
      1.083637,
      0.114040,
      0.997249,
      0.208953,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.044732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.062761,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834180,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.335296,
      0,
      1.674299,
      1,
      0,
      NULL,
      NULL,
      1.545961,
      0,
      0.748705,
      NULL,
      1.126138,
      1.370993,
      0.713524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818804,
      0,
      0.918101,
      NULL,
      0,
      0.718455,
      0,
      0.761396,
      NULL,
      0,
      NULL,
      1.363833,
      0.068675,
      0,
      NULL,
      1,
      0.241048,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.087841,
      NULL,
      0.956302,
      1.790930,
      NULL,
      1.982615,
      0.689577,
      NULL,
      1.338926,
      0.281231,
      NULL,
      0,
      1,
      NULL,
      0.098756,
      1,
      NULL,
      0,
      0.599761,
      NULL,
      0.889384,
      1.371108,
      NULL,
      NULL,
      1,
      1.624908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0.135824,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.759509,
      NULL,
      NULL,
      NULL,
      1.175849,
      NULL,
      3.155968,
      NULL,
      1,
      NULL,
      1.806649,
      NULL,
      1,
      NULL,
      56,
      NULL,
      18.279453,
      NULL,
      NULL,
      1.085802,
      NULL,
      1.466759,
      NULL,
      NULL,
      2,
      NULL,
      1.535155,
      NULL,
      NULL,
      92,
      64,
      3.446526,
      4,
      NULL,
      NULL,
      '44002',
      '',
      0.849250,
      '',
      '',
      '',
      1.216685,
      '',
      '',
      '');
commit;
end;
/


