set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437113';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      0.904822,
      0,
      NULL,
      3,
      '1024',
      NULL,
      0,
      NULL,
      NULL,
      ' 8- 9-1977',
      38.619586,
      NULL,
      1,
      NULL,
      0,
      ' 9-29-1988',
      25,
      NULL,
      180,
      107.375739,
      3,
      ' 0-24-1982',
      ' 6-10-1999',
      '11-10-1994',
      NULL,
      0,
      2,
      0,
      0,
      0,
      3,
      0,
      0.778638,
      NULL,
      NULL,
      3.147145,
      7,
      7.186365,
      6.921207,
      5,
      14,
      NULL,
      3.919348,
      4,
      0.239119,
      1.733363,
      0.389120,
      1.835403,
      NULL,
      NULL,
      1.830257,
      2.669807,
      7.106205,
      0.739927,
      1,
      NULL,
      NULL,
      10.388292,
      0,
      7,
      1,
      4,
      NULL,
      2,
      7,
      5.826029,
      3.288535,
      NULL,
      0,
      9.883264,
      6,
      10,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471270,
      NULL,
      NULL,
      9.503106,
      0.862222,
      2.513052,
      3.869907,
      2,
      0,
      3.211049,
      1.601254,
      1,
      1,
      1.387750,
      0.882006,
      0,
      0.114815,
      0,
      3,
      0,
      0,
      0,
      4,
      0.691615,
      3.621142,
      10.459979,
      1.246058,
      4.085227,
      2.756570,
      NULL,
      NULL,
      NULL,
      0.409100,
      NULL,
      NULL,
      1,
      1.568352,
      2,
      0.773650,
      2,
      0,
      1.033311,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0.881916,
      NULL,
      NULL,
      1,
      0.988569,
      NULL,
      0,
      NULL,
      2,
      0,
      3,
      3.259045,
      9,
      NULL,
      2.622457,
      NULL,
      5,
      NULL,
      1,
      7,
      9.247493,
      2.537164,
      1.254955,
      1.831623,
      9.629388,
      2.270901,
      1,
      0.172258,
      3.344917,
      4,
      NULL,
      NULL,
      NULL,
      1.458111,
      '10-25-2000',
      68.913198,
      ' 0-23-1990',
      7.319287,
      1.153608,
      1.205194,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.604873,
      NULL,
      0,
      0,
      0.271036,
      1.250077,
      1.178218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      3.559386,
      0.549454,
      1.296951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.461914,
      1.249713,
      NULL,
      NULL,
      NULL,
      3.234116,
      1,
      NULL,
      2.749064,
      NULL,
      3.196585,
      6,
      0.009330,
      NULL,
      NULL,
      1,
      10.577956,
      1.437118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.555904,
      1,
      1,
      0.099508,
      1,
      NULL,
      3,
      94.291076,
      1.948019,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.346341,
      3.555070,
      0.497988,
      2,
      3,
      0.016209,
      3,
      NULL,
      2.284699,
      2.417850,
      3.860151,
      1,
      0.343095,
      1,
      NULL,
      0,
      1,
      4,
      0,
      0,
      0,
      1,
      0,
      1.794194,
      0,
      1.786673,
      0,
      1,
      3.480277,
      1,
      NULL,
      9,
      NULL,
      8,
      1,
      0.320809,
      3,
      3,
      0.385693,
      1,
      0.788432,
      1,
      NULL,
      0,
      1.995037,
      NULL,
      53.707247,
      0.492430,
      52.948009,
      0,
      3.597042,
      NULL,
      '03233',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.037561,
      '',
      '',
      '',
      0,
      6,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.240787,
      4,
      2.186159,
      3,
      2,
      1.333177,
      NULL,
      NULL,
      1.510051,
      1,
      3,
      1.734741,
      NULL,
      NULL,
      1.086002,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.380557,
      NULL,
      2.189411,
      1.378652,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.586312,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.741995,
      4.319321,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.165155,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.843974,
      2,
      1,
      NULL,
      2,
      3.811490,
      2.952448,
      3.444226,
      1.186323,
      NULL,
      1.624913,
      1,
      3,
      NULL,
      1.276955,
      0.404823,
      3,
      1.629974,
      1,
      NULL,
      NULL,
      NULL,
      1.095990,
      NULL,
      NULL,
      5.572160,
      1,
      3.776628,
      0.712301,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018307,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      1.455248,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.829739,
      NULL,
      NULL,
      0.683038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421328,
      NULL,
      NULL,
      0.646695,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      3.901653,
      0.075331,
      NULL,
      NULL,
      7,
      4.918222,
      6.801786,
      1.743931,
      0,
      NULL,
      0.338588,
      NULL,
      NULL,
      NULL,
      3.420023,
      3,
      2.904905,
      NULL,
      2.828047,
      1,
      NULL,
      1.082533,
      NULL,
      5,
      1.814448,
      0.533071,
      3.554764,
      1,
      2,
      0,
      0,
      3,
      0,
      1.869372,
      1,
      3,
      3.488853,
      1.433671,
      6.960144,
      6.062358,
      6,
      NULL,
      3.566215,
      1.614926,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.119383,
      1,
      NULL,
      0.196494,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.103264,
      4.611663,
      4.325012,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.700175,
      NULL,
      1,
      3,
      1.573888,
      0.642484,
      1,
      0,
      1.819430,
      0.700309,
      NULL,
      0.519395,
      0,
      3.665043,
      0,
      0.868338,
      1.995804,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.543627,
      NULL,
      3.848420,
      NULL,
      1,
      NULL,
      2,
      NULL,
      11,
      NULL,
      3.928136,
      NULL,
      48,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.441907,
      NULL,
      1.047641,
      NULL,
      0,
      NULL,
      1.262566,
      NULL,
      0.507091,
      NULL,
      0.300294,
      NULL,
      1,
      NULL,
      1.404177,
      NULL,
      1.289365,
      NULL,
      0.373656,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2.775920,
      1.737801,
      1.798194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304362,
      1.832900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739640,
      2.491920,
      NULL,
      NULL,
      NULL,
      0.656879,
      NULL,
      NULL,
      NULL,
      0.349197,
      NULL,
      1.350508,
      NULL,
      NULL,
      1.140691,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.475662,
      3,
      3,
      1,
      NULL,
      0,
      NULL,
      0.462738,
      0.325533,
      NULL,
      0,
      NULL,
      3.888463,
      3.913080,
      NULL,
      0,
      0.180824,
      NULL,
      1.533857,
      0.148384,
      NULL,
      1.506085,
      1,
      NULL,
      1.749307,
      NULL,
      NULL,
      1.491889,
      3,
      NULL,
      0,
      1,
      NULL,
      1,
      1.619877,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.286327,
      NULL,
      2,
      1,
      1.500096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.321975,
      NULL,
      0.010710,
      5.471628,
      1,
      1,
      NULL,
      NULL,
      NULL,
      8,
      2.475990,
      1.000959,
      NULL,
      '43414',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.151391,
      '',
      '',
      '');
commit;
end;
/


