set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400554';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-1-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '1114001',
      2,
      0.324573,
      0,
      NULL,
      '1233',
      2.459834,
      0,
      NULL,
      NULL,
      ' 9- 3-2000',
      NULL,
      NULL,
      2.484986,
      0,
      1.378594,
      ' 5- 4-1987',
      57.202460,
      1.389669,
      3.514002,
      193.059188,
      3.873570,
      ' 1-11-1980',
      ' 4-18-1988',
      ' 3- 3-1984',
      3,
      1,
      2,
      1.708800,
      0,
      1.398294,
      3.552353,
      1.960669,
      0,
      4.969686,
      9,
      NULL,
      7,
      23,
      9,
      1.915725,
      23.149055,
      0.908703,
      2,
      NULL,
      1,
      0.872581,
      2,
      0.953877,
      0.199927,
      4.813243,
      1,
      1.453039,
      0,
      NULL,
      1,
      2.559578,
      3.915550,
      1,
      1.872446,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1.048390,
      1,
      1.462465,
      0.801009,
      0.643830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.446701,
      0,
      NULL,
      3,
      0,
      1.650103,
      3.167587,
      1,
      1.186747,
      3,
      0,
      0.557755,
      1.590078,
      3,
      1.242684,
      1,
      1.941355,
      1,
      NULL,
      NULL,
      1,
      NULL,
      7.977303,
      1.497662,
      2,
      1.902764,
      0.255831,
      NULL,
      NULL,
      0.549845,
      NULL,
      NULL,
      1.212746,
      1,
      5.730369,
      1.651776,
      NULL,
      0.534088,
      0.367627,
      1.851122,
      0.305776,
      NULL,
      2,
      1.371600,
      0,
      0,
      1.471507,
      1.289410,
      0,
      1.662022,
      1,
      NULL,
      1,
      1.001042,
      NULL,
      1.370028,
      1.801085,
      0.203465,
      0.199176,
      2,
      1,
      4,
      1,
      1,
      NULL,
      0,
      2,
      NULL,
      5,
      NULL,
      5.208851,
      3.708303,
      3,
      3.897114,
      6,
      4.387214,
      0.694116,
      NULL,
      1.182886,
      2.606216,
      ' 0-24-1978',
      NULL,
      ' 9-24-2002',
      17,
      0,
      2.689292,
      1,
      3,
      3.874845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.869232,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      3,
      NULL,
      0.185978,
      NULL,
      0,
      NULL,
      1.183346,
      NULL,
      0.939076,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095672,
      1.066558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132416,
      1.381694,
      1.075667,
      1,
      0,
      NULL,
      1.943548,
      2.923129,
      23,
      1.604225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.390746,
      1,
      0.547004,
      1.699351,
      3,
      1,
      NULL,
      3.534439,
      NULL,
      1.203708,
      1.854202,
      3.165432,
      NULL,
      1.783920,
      0,
      NULL,
      0.786907,
      0.997775,
      2.871383,
      0.361742,
      0.653998,
      0.530896,
      1.685234,
      1,
      2,
      1,
      3.891624,
      1.853836,
      NULL,
      5.376505,
      NULL,
      4,
      NULL,
      NULL,
      0.846740,
      1.424793,
      5.724253,
      3.002006,
      1,
      2.760635,
      12.882919,
      0.816627,
      2.222857,
      NULL,
      45.827079,
      56,
      56.205087,
      NULL,
      0,
      0.588460,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      62.709430,
      39,
      NULL,
      NULL,
      13.342111,
      NULL,
      0.495302,
      1.942342,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.778731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.913416,
      NULL,
      NULL,
      0.744786,
      NULL,
      NULL,
      1.754945,
      NULL,
      NULL,
      0.281463,
      NULL,
      NULL,
      0.748270,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877158,
      NULL,
      2.579245,
      0.932903,
      NULL,
      NULL,
      0.563015,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.197179,
      NULL,
      0,
      3.293713,
      1.494805,
      0.996400,
      NULL,
      3.293635,
      0.937578,
      2,
      0.938266,
      0.972353,
      1,
      1.363228,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      8.827366,
      5.644739,
      0.400692,
      1.988716,
      NULL,
      NULL,
      NULL,
      1.629535,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.821733,
      1.559151,
      3.356333,
      1,
      2,
      1,
      NULL,
      NULL,
      8.727011,
      6.979616,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.488822,
      NULL,
      NULL,
      0.924308,
      NULL,
      NULL,
      0.660358,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      1.378343,
      NULL,
      NULL,
      NULL,
      2,
      1.420218,
      3,
      NULL,
      3,
      1,
      1.704830,
      2,
      3,
      2.908624,
      NULL,
      1,
      NULL,
      3.997553,
      0,
      NULL,
      3.261825,
      1.919474,
      NULL,
      NULL,
      3,
      2.154867,
      2.559282,
      4,
      6.546636,
      5,
      1,
      NULL,
      NULL,
      1.236342,
      NULL,
      NULL,
      1,
      0,
      0.740375,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.129937,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.823267,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.476864,
      NULL,
      NULL,
      0,
      1,
      0.796493,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.814950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.395030,
      NULL,
      NULL,
      NULL,
      1.956060,
      NULL,
      NULL,
      NULL,
      2.473763,
      NULL,
      NULL,
      NULL,
      0.072035,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605091,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.124198,
      3.025827,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.299618,
      NULL,
      2,
      2.331957,
      0,
      2,
      0.088294,
      NULL,
      NULL,
      1.002413,
      NULL,
      0.510839,
      111,
      0,
      1,
      1,
      NULL,
      0.621443,
      0,
      0,
      0.368227,
      1.845496,
      0,
      1.935316,
      1,
      1,
      NULL,
      1,
      1,
      1.807482,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3,
      10.348037,
      2.684918,
      6.335138,
      3.690023,
      0.595107,
      6.009891,
      2,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0.546261,
      NULL,
      1,
      1.735784,
      NULL,
      1,
      1.970623,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.305320,
      2.889492,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      3,
      NULL,
      0,
      1,
      NULL,
      0.586166,
      0.211926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132866,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.283115,
      NULL,
      NULL,
      NULL,
      37,
      72,
      NULL,
      0,
      2.260403,
      '04103',
      '',
      '',
      0,
      '',
      '',
      '',
      0.160918,
      '',
      '',
      '');
commit;
end;
/


