set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8203083';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '3433334',
      3,
      0,
      2,
      2,
      '4330',
      2.123480,
      0.654318,
      NULL,
      NULL,
      ' 6-12-1999',
      40.961036,
      NULL,
      1.288477,
      3,
      1,
      ' 2-27-1997',
      27,
      NULL,
      135.094850,
      35.970286,
      1,
      NULL,
      ' 5-15-1993',
      ' 9- 7-2002',
      1.704618,
      3.850400,
      1.791418,
      1.593544,
      0,
      0,
      7,
      0.010492,
      0.026686,
      34,
      1,
      1.657688,
      NULL,
      23.538065,
      25,
      4.005699,
      NULL,
      0,
      0.149280,
      5.776289,
      1,
      1.849034,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      195,
      0,
      8.394785,
      0,
      2,
      11.464714,
      NULL,
      2.092647,
      0,
      0.766956,
      0.673876,
      1,
      2.674781,
      2,
      1.898634,
      1,
      1,
      0.888339,
      0.309920,
      3,
      NULL,
      NULL,
      1.938098,
      NULL,
      NULL,
      NULL,
      1.722023,
      0.093441,
      6.265584,
      1,
      0,
      2.203445,
      1.494974,
      1,
      3.028602,
      0.629149,
      1,
      0,
      1.289498,
      1.794245,
      NULL,
      NULL,
      NULL,
      2.404742,
      NULL,
      NULL,
      1,
      1,
      1.967861,
      NULL,
      6.888885,
      2.072694,
      NULL,
      0.493752,
      1,
      NULL,
      NULL,
      0.996254,
      0,
      0.706121,
      0.502327,
      NULL,
      1.819972,
      0,
      4,
      NULL,
      6,
      0.730716,
      0,
      NULL,
      1.443411,
      2,
      0,
      NULL,
      0.183193,
      1,
      NULL,
      0,
      1.921496,
      NULL,
      NULL,
      5,
      4,
      1.781228,
      10.095918,
      2,
      2,
      10,
      NULL,
      9,
      2,
      3.222041,
      NULL,
      7,
      NULL,
      2.039407,
      8,
      10,
      10,
      8.477817,
      1,
      1,
      2.562091,
      NULL,
      NULL,
      3,
      NULL,
      1,
      ' 0-21-1982',
      581.444623,
      ' 3-25-1989',
      12,
      3.854579,
      1.486229,
      3.905469,
      5.248955,
      0.163531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.506909,
      1,
      1,
      1.503456,
      0.854443,
      0.283116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.950897,
      NULL,
      10.023482,
      1.427802,
      1,
      0,
      1,
      1.306816,
      1.786576,
      3,
      4,
      10.712413,
      0,
      3.970333,
      3.149721,
      NULL,
      1.783919,
      NULL,
      7,
      5,
      2.975921,
      0,
      2.831275,
      0,
      0,
      NULL,
      NULL,
      1,
      10.510207,
      NULL,
      2.840358,
      NULL,
      7.604138,
      11,
      '11-20-2002',
      525.048957,
      ' 3-27-2000',
      54.737292,
      NULL,
      1.456451,
      1,
      1.242343,
      0.619038,
      0.428102,
      2,
      NULL,
      1.194084,
      1,
      NULL,
      419,
      1.701342,
      0.758051,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      0,
      3.210261,
      1.912664,
      NULL,
      NULL,
      1,
      1.393175,
      1.554908,
      3.703827,
      3.342435,
      3.989003,
      2.749323,
      1.344420,
      1.630251,
      1,
      1.493516,
      0.499519,
      1.108982,
      0.418089,
      1,
      1.807769,
      0.782235,
      1.040944,
      0,
      NULL,
      3.544052,
      1.858062,
      3,
      11,
      6,
      1,
      NULL,
      6,
      NULL,
      2.377040,
      1,
      1,
      3.187813,
      0.101243,
      61,
      0.189925,
      3,
      NULL,
      51.128856,
      NULL,
      75.068425,
      1.118146,
      1.468060,
      0.124970,
      '04443',
      '',
      NULL,
      NULL,
      '22024',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      20,
      91.935072,
      NULL,
      2.440482,
      44.202544,
      21,
      63.046162,
      NULL,
      0.132823,
      2.400860,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.134061,
      1.551050,
      NULL,
      NULL,
      0.460129,
      NULL,
      NULL,
      1.367208,
      NULL,
      NULL,
      NULL,
      1,
      0.283518,
      0.208418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325502,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.404328,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.993037,
      0.687684,
      1,
      3.754459,
      5.437670,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.422288,
      1.559532,
      NULL,
      0,
      0.021349,
      NULL,
      0,
      0.821020,
      2.071020,
      NULL,
      1.851250,
      2.873929,
      3,
      1.142421,
      3.010603,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.563733,
      0.906244,
      1.430647,
      1,
      NULL,
      1,
      3,
      0.054932,
      NULL,
      NULL,
      NULL,
      2.266343,
      0,
      1,
      1,
      0.466997,
      NULL,
      NULL,
      1.667582,
      0.022048,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.569319,
      0,
      1,
      2.425395,
      2.571675,
      1.920173,
      NULL,
      NULL,
      4,
      1.295747,
      NULL,
      2.523482,
      1,
      0.106658,
      0.033795,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009994,
      NULL,
      NULL,
      4,
      0.452744,
      0.186462,
      3,
      3,
      0,
      2,
      3.041684,
      NULL,
      4.489036,
      1.599963,
      5,
      2.128965,
      NULL,
      5,
      0.891021,
      NULL,
      NULL,
      1.473483,
      0.732325,
      0.358377,
      NULL,
      1.415326,
      NULL,
      0.812864,
      NULL,
      2,
      7,
      3.738621,
      NULL,
      NULL,
      0.953773,
      NULL,
      NULL,
      3,
      NULL,
      1.783129,
      NULL,
      NULL,
      1,
      0.789608,
      1,
      10,
      6.144416,
      3.147104,
      5,
      1,
      NULL,
      2,
      5,
      6.279200,
      1.965884,
      0.867071,
      0.185658,
      1,
      0.947671,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.914188,
      0,
      0,
      6,
      NULL,
      NULL,
      NULL,
      81,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.879933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.017869,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.428137,
      NULL,
      NULL,
      NULL,
      0.146485,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.471954,
      NULL,
      NULL,
      NULL,
      3.583986,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      1.598956,
      0.113060,
      0,
      NULL,
      NULL,
      61,
      5,
      2,
      189,
      2.314558,
      3.319731,
      3.251801,
      1.854195,
      0,
      39.022540,
      NULL,
      NULL,
      16.162899,
      5.650424,
      2.460963,
      5,
      NULL,
      0.046894,
      119.708727,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.499919,
      NULL,
      1,
      0,
      0,
      1.527881,
      1.212470,
      1.257592,
      1.914683,
      0.849173,
      1,
      NULL,
      0.101169,
      1.506428,
      1,
      0.548741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.930097,
      0,
      NULL,
      0.902189,
      0.587538,
      2,
      3,
      0.172565,
      0,
      1.536386,
      1.092813,
      0,
      0,
      0,
      0.194303,
      1.686527,
      1,
      1.440180,
      NULL,
      NULL,
      NULL,
      3.409481,
      1.492670,
      0.122301,
      1,
      2,
      0.579058,
      3.382142,
      1,
      1,
      3.272634,
      0.598180,
      NULL,
      NULL,
      1.547362,
      1,
      1.490055,
      2.181147,
      0,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.332916,
      1.431444,
      NULL,
      0.493602,
      0.191257,
      NULL,
      3.519484,
      1,
      1.161034,
      0.435992,
      3,
      1,
      3,
      0,
      3.362843,
      NULL,
      NULL,
      1.978040,
      1.025074,
      0.285641,
      0,
      NULL,
      1.143377,
      1.599647,
      NULL,
      46.606963,
      1.310782,
      NULL,
      0,
      1,
      1.995783,
      0.926590,
      1.269732,
      0,
      0.816235,
      4.278529,
      6,
      3.182452,
      1,
      1,
      29,
      15.421200,
      5,
      1,
      0.605755,
      '22101',
      '24024',
      '',
      3.601643,
      '13204',
      '',
      '',
      0.125888,
      '',
      '',
      '');
commit;
end;
/


