set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6401936';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      1.683325,
      0.157567,
      0,
      3,
      '2010',
      2.719780,
      1.539826,
      NULL,
      NULL,
      ' 9- 4-1980',
      30,
      NULL,
      NULL,
      0,
      0.225955,
      ' 7-10-1981',
      69,
      4,
      NULL,
      114,
      0,
      '11-10-1993',
      ' 1-13-1984',
      '10-29-1981',
      0,
      2.027170,
      0.070383,
      1,
      0.672991,
      1.930935,
      1.908254,
      0.953167,
      1.933592,
      145,
      5.582377,
      5,
      1,
      20,
      189,
      7.306005,
      7.377016,
      5,
      0.194938,
      2.962935,
      0.050634,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      75.037095,
      3.097751,
      1.105159,
      NULL,
      1.091701,
      4.947761,
      0,
      0,
      1,
      0,
      NULL,
      0.080483,
      0.641270,
      1,
      1.889670,
      1,
      0.024103,
      2,
      1,
      NULL,
      0.294087,
      NULL,
      0.322696,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.955033,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847049,
      1.591476,
      0.143410,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.319229,
      1,
      NULL,
      4.356129,
      NULL,
      3,
      3.037442,
      NULL,
      NULL,
      3.838571,
      1,
      5.642054,
      1,
      2,
      0.507802,
      1.653957,
      0,
      NULL,
      1,
      NULL,
      0.496147,
      1.843740,
      5.442232,
      0.175484,
      4.606686,
      3.172780,
      NULL,
      3.719887,
      2,
      4.117974,
      1,
      NULL,
      4.345109,
      3.011754,
      9.004998,
      0,
      8,
      3,
      NULL,
      2,
      1.083710,
      3.816828,
      1,
      6.404882,
      0,
      8,
      8,
      3.730546,
      ' 6- 0-1996',
      1705.712310,
      ' 8-18-1978',
      546,
      2,
      3,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834172,
      0.669866,
      1,
      0.185340,
      1.453798,
      1.682066,
      1,
      1.280886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.579508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.231578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518157,
      NULL,
      2.588690,
      0,
      NULL,
      1.092977,
      1,
      NULL,
      NULL,
      NULL,
      1.697679,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3.196359,
      NULL,
      1,
      0,
      2.952205,
      1421,
      1,
      0.772979,
      NULL,
      NULL,
      NULL,
      1,
      1.059995,
      NULL,
      2.594156,
      2.002464,
      1.277857,
      2,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3.198829,
      1.275979,
      1.472757,
      15.808614,
      38.521326,
      1.993830,
      110,
      9,
      83.623086,
      94,
      135,
      122,
      168.977587,
      56.254582,
      96,
      104.860482,
      1.815468,
      NULL,
      14.399941,
      1.742011,
      NULL,
      1,
      0,
      NULL,
      0,
      1.336127,
      NULL,
      2,
      2.265778,
      2.650498,
      NULL,
      NULL,
      26.865627,
      3,
      3,
      NULL,
      43,
      25,
      32,
      0.023680,
      0.313262,
      0.059265,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.233155,
      '11302',
      '21041',
      NULL,
      1.263092,
      34.827459,
      618.221428,
      0.440985,
      0.426427,
      16.271610,
      NULL,
      168,
      9.850531,
      0.615400,
      3.379868,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.079416,
      1,
      1,
      0.245896,
      0.362742,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.750708,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.417386,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.716817,
      NULL,
      NULL,
      NULL,
      3,
      0.268373,
      0.421968,
      0.402827,
      NULL,
      NULL,
      0.857813,
      NULL,
      NULL,
      2,
      0,
      1.071136,
      0,
      NULL,
      1,
      0,
      1.157113,
      0,
      0,
      0.949191,
      1.476581,
      NULL,
      1.162241,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.197328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.950690,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.420298,
      NULL,
      NULL,
      NULL,
      6,
      3,
      3,
      1,
      0.659996,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.312673,
      NULL,
      NULL,
      1.346450,
      NULL,
      NULL,
      4.965987,
      4.427903,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      3.028128,
      NULL,
      1,
      7,
      NULL,
      1.031270,
      9.883929,
      6,
      NULL,
      1.149180,
      NULL,
      NULL,
      1,
      NULL,
      2.178502,
      3,
      0.767230,
      0,
      4.995078,
      NULL,
      1,
      1.801595,
      2,
      NULL,
      0.528332,
      NULL,
      NULL,
      1,
      NULL,
      2.560206,
      3.082629,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.780007,
      0.167736,
      4.958948,
      1,
      NULL,
      0.344952,
      0.738073,
      1,
      0.120196,
      1.107937,
      0,
      0,
      NULL,
      NULL,
      1.896513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.587009,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.744379,
      NULL,
      NULL,
      0.838965,
      NULL,
      NULL,
      1.292541,
      NULL,
      NULL,
      0.986624,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.130261,
      1.563199,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.819234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.756946,
      1.511038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.057266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.246997,
      NULL,
      NULL,
      0,
      0.144763,
      NULL,
      NULL,
      1.551326,
      1.341095,
      NULL,
      NULL,
      1.335343,
      1,
      NULL,
      NULL,
      NULL,
      1.412835,
      NULL,
      NULL,
      1.990110,
      0.226256,
      NULL,
      NULL,
      0,
      0.155927,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2,
      3,
      375.574040,
      NULL,
      1.750765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313745,
      NULL,
      NULL,
      2.919020,
      356.893805,
      58.680998,
      0.020770,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      1.672537,
      1.970257,
      NULL,
      NULL,
      0.057422,
      0.064488,
      1,
      NULL,
      NULL,
      0.781267,
      NULL,
      1,
      1.707944,
      NULL,
      0,
      0.197473,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237848,
      NULL,
      0,
      1,
      0,
      0,
      3,
      1,
      7.347457,
      3.305501,
      NULL,
      0,
      0,
      NULL,
      1.229041,
      1,
      3.898635,
      NULL,
      1,
      1.129366,
      0,
      0.497950,
      1.750174,
      NULL,
      0,
      1.191712,
      1,
      1.363901,
      0,
      1.013978,
      NULL,
      1.151070,
      0.781203,
      0,
      0,
      3.208843,
      1,
      1.866486,
      1,
      1.481700,
      0.725954,
      NULL,
      1.672749,
      NULL,
      NULL,
      3.170022,
      NULL,
      0.707563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.296466,
      0.768555,
      NULL,
      0,
      1.553249,
      9.655921,
      0,
      6,
      3,
      NULL,
      1,
      46.841790,
      36.545104,
      2.917635,
      1.757401,
      3.620448,
      NULL,
      '31233',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '40101',
      '34244',
      '');
commit;
end;
/


