set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637027';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03',
      NULL,
      NULL,
      16,
      '2032041',
      1.206668,
      0.293952,
      0,
      2,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      ' 9- 1-1994',
      73.601659,
      5,
      NULL,
      2,
      1.434709,
      ' 3-20-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-27-1999',
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      11,
      7.124340,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.565281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1.420282,
      0.264043,
      2,
      0.466507,
      4.117317,
      2.858336,
      1,
      0,
      6,
      2.799876,
      1,
      1.154102,
      NULL,
      0.124181,
      8.023164,
      0,
      4.044884,
      0.310835,
      2.308830,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.601024,
      2,
      3.896130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420221,
      1,
      0.269460,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1.799456,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1.171708,
      0,
      NULL,
      0,
      NULL,
      1,
      0.706086,
      NULL,
      1.374674,
      0,
      1,
      1,
      0.552510,
      1.914320,
      0.489189,
      6,
      0.201041,
      1.801054,
      NULL,
      0,
      1.708200,
      4.045631,
      NULL,
      7,
      2.077431,
      5.087331,
      1.140565,
      1,
      7.981745,
      NULL,
      0.321770,
      NULL,
      1.338028,
      0,
      0.972060,
      1.304917,
      NULL,
      7.012806,
      ' 6-28-2001',
      1,
      NULL,
      1,
      0,
      2.821202,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.354572,
      2.071848,
      0.935512,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      2.482275,
      0.825815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754740,
      1,
      4,
      5.152701,
      0,
      0,
      2.898967,
      1.436577,
      NULL,
      NULL,
      1,
      NULL,
      1.641293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.009147,
      0.438238,
      1.209701,
      1.449087,
      0.175739,
      NULL,
      1.841270,
      6.551200,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.236172,
      1.861200,
      1,
      2,
      0.515361,
      1,
      2.859182,
      NULL,
      0.993603,
      0,
      0,
      2.909133,
      4,
      1,
      NULL,
      1.400191,
      0,
      2.354296,
      0,
      1.763584,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.511354,
      2.904872,
      5.997564,
      5,
      NULL,
      4,
      3.765747,
      3,
      NULL,
      2,
      1,
      2.603512,
      36,
      0,
      3,
      23,
      NULL,
      36,
      21.675189,
      0.707977,
      3,
      1,
      '24101',
      '',
      NULL,
      0.329888,
      '',
      '',
      '',
      1.002076,
      '',
      NULL,
      '',
      3.543504,
      37.861115,
      NULL,
      NULL,
      1.640350,
      25,
      1,
      NULL,
      0.706041,
      NULL,
      1.350236,
      NULL,
      0.441734,
      NULL,
      NULL,
      1.520088,
      0.091880,
      0.791655,
      0.306752,
      2.141704,
      0.365316,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.888024,
      0.836621,
      0.903563,
      NULL,
      NULL,
      2,
      1.627485,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.231595,
      NULL,
      NULL,
      NULL,
      4.730264,
      2.025800,
      1,
      1.354261,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.163858,
      NULL,
      NULL,
      NULL,
      3.369060,
      0.374928,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      1,
      1.211257,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.651511,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388286,
      NULL,
      NULL,
      0.231108,
      NULL,
      NULL,
      1.533035,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.643224,
      NULL,
      NULL,
      0.450685,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.587025,
      3.926489,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.539744,
      1.171989,
      1,
      1.435940,
      0.187444,
      0.574465,
      3.831004,
      2.701815,
      3,
      2,
      3.760335,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.216319,
      0.611993,
      NULL,
      0.768631,
      NULL,
      2.968880,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.847124,
      1,
      0.764347,
      0.223900,
      1.416565,
      2.026149,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.251274,
      NULL,
      NULL,
      3.734202,
      NULL,
      NULL,
      1.340659,
      0.768624,
      1.565395,
      0.482973,
      1,
      0,
      2,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.930681,
      0,
      NULL,
      NULL,
      NULL,
      1.064313,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.772966,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842746,
      NULL,
      NULL,
      3,
      1.900755,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      200.034971,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      56622.943617,
      0,
      NULL,
      1,
      0.117998,
      1.742048,
      1.894080,
      1.415072,
      NULL,
      1,
      0,
      1.159865,
      NULL,
      NULL,
      0.519124,
      0,
      1.856551,
      NULL,
      1,
      NULL,
      1.440322,
      NULL,
      3,
      NULL,
      1.321282,
      NULL,
      0,
      NULL,
      1.404870,
      NULL,
      NULL,
      NULL,
      0.908332,
      17,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3.164132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.923494,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.855705,
      NULL,
      NULL,
      NULL,
      1.046072,
      NULL,
      0,
      3.530872,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083830,
      NULL,
      0.863542,
      NULL,
      1,
      NULL,
      0,
      0.272963,
      1.661510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691321,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.290005,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1.234885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.711132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.566803,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253554,
      NULL,
      0.030370,
      NULL,
      1.222086,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081246,
      1.682439,
      0,
      1.805456,
      NULL,
      1.479535,
      1,
      NULL,
      3.343271,
      0,
      NULL,
      2.806565,
      1.154164,
      0,
      NULL,
      1,
      NULL,
      1.667195,
      0,
      0,
      NULL,
      0.854368,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0.534197,
      0,
      0,
      0,
      NULL,
      1,
      0.515432,
      NULL,
      0.646598,
      1.417665,
      0,
      0.168380,
      0.617037,
      0.227399,
      1,
      3,
      2.602560,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.131740,
      0.233562,
      0.908759,
      0.692730,
      1,
      1,
      0.861755,
      1,
      1.734773,
      NULL,
      0.264270,
      2.345524,
      0.460592,
      NULL,
      1,
      0,
      1.491780,
      0.843078,
      1,
      0,
      NULL,
      0.661592,
      NULL,
      0.209613,
      NULL,
      NULL,
      5,
      0.156644,
      0.138547,
      NULL,
      0,
      0.909391,
      NULL,
      NULL,
      1.808140,
      6.622594,
      0.645920,
      NULL,
      NULL,
      109,
      138,
      0.693708,
      5,
      2,
      '02230',
      '',
      '',
      0.678637,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


