set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '1421332',
      0.909864,
      1.517665,
      2,
      NULL,
      '2421',
      NULL,
      1.323293,
      NULL,
      NULL,
      ' 1-29-1990',
      27,
      NULL,
      0.238456,
      2,
      1,
      ' 3-18-1986',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      ' 4- 5-1983',
      NULL,
      NULL,
      NULL,
      3.720922,
      1,
      1.814386,
      0,
      2,
      3,
      0,
      0,
      3,
      2,
      4.371315,
      3,
      NULL,
      NULL,
      7,
      14,
      NULL,
      3.718299,
      2.042268,
      1.639273,
      7,
      1.042960,
      0.589539,
      1.630010,
      0.368804,
      NULL,
      NULL,
      1,
      1.313192,
      1.872714,
      NULL,
      3.432194,
      5.638514,
      1,
      2,
      NULL,
      4.076276,
      1,
      0.669377,
      0.013165,
      3,
      NULL,
      1,
      1.819486,
      1.892948,
      2.252827,
      3,
      NULL,
      4,
      1.662653,
      0.977512,
      1,
      NULL,
      NULL,
      0.057766,
      NULL,
      NULL,
      3.616183,
      0.337587,
      2,
      3,
      0.029512,
      1,
      1.751994,
      1.772087,
      NULL,
      NULL,
      2.255238,
      0,
      0,
      1.451755,
      0.937870,
      1.083137,
      3,
      2.699641,
      0.906245,
      2,
      1.543980,
      3,
      0.981956,
      NULL,
      NULL,
      1.991743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.826722,
      0.180472,
      5.567643,
      1,
      2.766035,
      0,
      0.709955,
      0,
      NULL,
      5,
      NULL,
      4.901239,
      NULL,
      0,
      1.385364,
      NULL,
      0.744180,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      1.571505,
      0,
      NULL,
      1,
      7.705272,
      2,
      NULL,
      3.848257,
      6.721290,
      1,
      1,
      0,
      0.691685,
      1.360153,
      4.380949,
      5,
      5.394347,
      9,
      6,
      1,
      NULL,
      7,
      1.250567,
      ' 7-19-2001',
      60,
      '10-18-1981',
      14.299677,
      1.563839,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.506272,
      1,
      NULL,
      1.951966,
      0.292960,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.656923,
      3.198918,
      0.731376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      0.146414,
      NULL,
      0.204571,
      2.573287,
      NULL,
      4.360470,
      4.782763,
      0,
      NULL,
      NULL,
      NULL,
      0,
      9.283160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.546315,
      1,
      NULL,
      1.989910,
      0,
      0.482564,
      1,
      15,
      1,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.992785,
      0,
      2,
      1,
      NULL,
      1,
      1.135271,
      2.805485,
      2,
      3,
      3,
      NULL,
      3,
      3.172016,
      NULL,
      0.096442,
      1.015368,
      0.258450,
      0,
      1.519054,
      1,
      0,
      0.583978,
      0.752339,
      1.053300,
      0,
      1,
      NULL,
      3.882351,
      1,
      3,
      11.367200,
      NULL,
      9,
      11,
      7.988188,
      NULL,
      1.028518,
      7.448195,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.069400,
      NULL,
      28.210665,
      4,
      47.348304,
      2.171616,
      1.119409,
      2.485946,
      NULL,
      '30030',
      '04130',
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      18.837458,
      35,
      42,
      0.287979,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.827547,
      NULL,
      NULL,
      0.287173,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.907164,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.742371,
      NULL,
      4.220957,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.294108,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966741,
      NULL,
      NULL,
      0.194700,
      NULL,
      NULL,
      0.048589,
      NULL,
      NULL,
      3.294424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.721625,
      3.469686,
      1,
      1,
      NULL,
      NULL,
      2,
      0,
      4.253273,
      2,
      2.214213,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322173,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.931645,
      NULL,
      NULL,
      NULL,
      2.791888,
      0,
      NULL,
      3.395102,
      1.721642,
      NULL,
      7.851577,
      NULL,
      5.199683,
      4,
      4.010228,
      1.334705,
      NULL,
      NULL,
      0,
      0.082131,
      3.403733,
      0,
      3.943826,
      2,
      NULL,
      3,
      2,
      6,
      6,
      1.721537,
      0,
      3,
      3.589903,
      0,
      0.956969,
      0,
      NULL,
      3,
      2.151162,
      2.952296,
      1,
      2,
      NULL,
      6.380324,
      4.563509,
      5.441699,
      4,
      1.963523,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151300,
      0,
      0.014663,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883944,
      1.334913,
      0,
      1,
      1.262708,
      0.394174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319141,
      NULL,
      NULL,
      NULL,
      1.100801,
      NULL,
      1,
      2.595819,
      5.113060,
      1,
      1.505277,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.756275,
      NULL,
      1,
      971.364087,
      3.342227,
      1,
      1,
      0,
      0.252265,
      1,
      0.491356,
      0.705681,
      NULL,
      0.737003,
      NULL,
      0.145595,
      1.559322,
      1,
      2.210422,
      0,
      0.631175,
      0,
      0.640415,
      NULL,
      3.798112,
      NULL,
      3,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2.964070,
      NULL,
      135,
      NULL,
      3.823837,
      4,
      NULL,
      1,
      NULL,
      2.092615,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.177668,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.884275,
      NULL,
      NULL,
      NULL,
      0.771522,
      NULL,
      1.569086,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208538,
      0.706910,
      NULL,
      3.769494,
      NULL,
      3.566964,
      NULL,
      135,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.120944,
      1.711025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.360950,
      NULL,
      20.542198,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.554883,
      NULL,
      3.846537,
      NULL,
      NULL,
      NULL,
      2.482579,
      NULL,
      2,
      NULL,
      2,
      1,
      3,
      0,
      NULL,
      NULL,
      3.836309,
      0.432384,
      NULL,
      0,
      3.620103,
      1.441230,
      4,
      1.116059,
      2.821401,
      NULL,
      5.981022,
      NULL,
      NULL,
      NULL,
      0.534537,
      0,
      1.882428,
      NULL,
      1.679601,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.210713,
      NULL,
      3,
      3.696791,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.089662,
      NULL,
      1,
      0.352164,
      NULL,
      1.067998,
      1,
      NULL,
      2.104364,
      3,
      NULL,
      0.173871,
      2,
      NULL,
      NULL,
      1.945648,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.133109,
      NULL,
      0.053989,
      NULL,
      0,
      4.397686,
      7.188061,
      NULL,
      NULL,
      1.371778,
      75,
      NULL,
      0.458947,
      2,
      1.204159,
      NULL,
      '22141',
      '42312',
      NULL,
      '',
      '',
      NULL,
      1.529537,
      '',
      NULL,
      '');
commit;
end;
/


