set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9232524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00',
      '13',
      3.777884,
      38.360367,
      '0013131',
      3.871297,
      1,
      3,
      NULL,
      '3122',
      1.066471,
      0,
      NULL,
      NULL,
      NULL,
      8,
      13,
      NULL,
      1.752387,
      NULL,
      ' 9- 2-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      0.013797,
      ' 9-17-1996',
      ' 4- 9-1991',
      NULL,
      2,
      0.369338,
      3,
      0.589598,
      1,
      3.976328,
      0.522218,
      1.270098,
      1,
      NULL,
      9.193638,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484393,
      2.331763,
      NULL,
      NULL,
      NULL,
      0.825972,
      0.130493,
      0.505320,
      1,
      1.257231,
      0.199110,
      0.034601,
      1,
      NULL,
      3.492718,
      1.969365,
      7.293947,
      0,
      NULL,
      NULL,
      NULL,
      0.001498,
      NULL,
      1.081792,
      1,
      NULL,
      1.846798,
      1,
      1.305647,
      1,
      3.075833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903617,
      0.385616,
      1.180290,
      1.934508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.109810,
      1.687952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1.953320,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.673702,
      0.035126,
      0.936057,
      0.846325,
      5.418757,
      2,
      4,
      7,
      1,
      0.278237,
      5,
      0,
      NULL,
      5,
      0.073344,
      5.633073,
      5.799054,
      0,
      1.809655,
      NULL,
      1,
      NULL,
      NULL,
      3.101449,
      NULL,
      0.600008,
      7.223074,
      8.689639,
      7,
      10.308797,
      NULL,
      NULL,
      4.357508,
      0.908194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.817126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.036443,
      NULL,
      0.065873,
      1,
      1.113765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.403092,
      1,
      0,
      0.262636,
      1.110449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099826,
      0.082637,
      1,
      NULL,
      1.546299,
      0,
      0.213170,
      NULL,
      23,
      NULL,
      0,
      2,
      14,
      NULL,
      4.893750,
      0,
      1,
      5.195727,
      2,
      3.737272,
      NULL,
      3.891079,
      1,
      NULL,
      NULL,
      0,
      3.549078,
      0,
      1.059469,
      3,
      NULL,
      0.850071,
      1.548187,
      3.514672,
      1,
      1,
      0,
      0.072873,
      1.276345,
      NULL,
      NULL,
      1,
      0.013661,
      2.403523,
      3,
      1,
      7,
      NULL,
      NULL,
      NULL,
      4.306024,
      3.309122,
      3,
      3.927333,
      1.067707,
      1.222401,
      3.990733,
      NULL,
      28,
      2.595337,
      NULL,
      49,
      NULL,
      NULL,
      27,
      NULL,
      0.052282,
      6,
      NULL,
      '02142',
      '40442',
      0.131697,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      23.781331,
      17,
      10.724471,
      0.499012,
      11.782199,
      NULL,
      2.838467,
      3.777729,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.510059,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.417025,
      NULL,
      1,
      NULL,
      NULL,
      1.132257,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.016168,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.574182,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.039432,
      1.812309,
      0.002793,
      1.248637,
      3.724434,
      0.217153,
      1.611850,
      1,
      0.804627,
      1,
      NULL,
      0,
      1,
      3.717216,
      0,
      2.834052,
      1.870366,
      1.761165,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.824038,
      NULL,
      4,
      NULL,
      0.735642,
      0.664910,
      1.385931,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.104153,
      0,
      0.737346,
      1.149180,
      3,
      1,
      1.011596,
      NULL,
      NULL,
      7.057912,
      NULL,
      NULL,
      1,
      2.435371,
      1,
      0,
      NULL,
      NULL,
      0,
      2.893735,
      0,
      1.224670,
      NULL,
      NULL,
      0.554751,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      2,
      2.100972,
      4,
      2,
      6.846966,
      4,
      1.976706,
      0,
      NULL,
      NULL,
      2.549787,
      0.559293,
      2.172096,
      1.803359,
      1,
      0,
      2.113523,
      1,
      0,
      5,
      1,
      7.013095,
      0,
      1,
      NULL,
      2.105292,
      3,
      1.166714,
      2,
      0,
      NULL,
      0,
      1,
      3,
      3.739528,
      NULL,
      3.756235,
      2.767692,
      7,
      2,
      2,
      1,
      3,
      1.665049,
      1,
      0.983996,
      1.066086,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156007,
      NULL,
      NULL,
      0.714766,
      NULL,
      NULL,
      1.556138,
      NULL,
      NULL,
      0.406653,
      NULL,
      NULL,
      1.904511,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.920205,
      NULL,
      NULL,
      0.883037,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.029355,
      NULL,
      0.026352,
      NULL,
      NULL,
      NULL,
      3.048380,
      NULL,
      NULL,
      NULL,
      30.834302,
      NULL,
      NULL,
      NULL,
      1.617117,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191586,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.613193,
      NULL,
      NULL,
      NULL,
      1.958538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      23,
      3,
      1,
      3,
      1.263138,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      123,
      NULL,
      1.698754,
      NULL,
      1.259572,
      1,
      1,
      2,
      0,
      0,
      1.605885,
      0.610006,
      0.880033,
      0.585242,
      1.189994,
      3.259459,
      1.532346,
      1.093695,
      NULL,
      2.310337,
      NULL,
      1,
      NULL,
      1.628160,
      NULL,
      3.344275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      187.008645,
      NULL,
      0,
      NULL,
      9,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.373063,
      NULL,
      NULL,
      NULL,
      1.437134,
      NULL,
      1.266626,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.212929,
      NULL,
      1.707172,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.941849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.637522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.978528,
      NULL,
      405,
      NULL,
      NULL,
      NULL,
      1.069156,
      NULL,
      0,
      NULL,
      NULL,
      1.138605,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.888276,
      0.999667,
      NULL,
      1,
      NULL,
      1,
      NULL,
      91,
      NULL,
      NULL,
      NULL,
      1.012677,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.716233,
      NULL,
      0.614700,
      NULL,
      3.397565,
      NULL,
      3,
      NULL,
      1,
      26,
      33.108230,
      2,
      1.629814,
      NULL,
      NULL,
      NULL,
      0,
      3.448154,
      NULL,
      1,
      1.826568,
      NULL,
      4.104549,
      6.733651,
      1.761063,
      3,
      1.116949,
      1.931595,
      1.778158,
      NULL,
      1,
      1,
      0.779190,
      NULL,
      1,
      2.032706,
      1.246615,
      0,
      0,
      0.521475,
      2,
      1,
      3,
      2.962871,
      0.671834,
      NULL,
      0,
      NULL,
      0.008661,
      1.047423,
      0,
      1.767506,
      1.681684,
      NULL,
      1,
      NULL,
      0.691136,
      0,
      0,
      3,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.667613,
      1.784566,
      NULL,
      1.004265,
      1.406477,
      0,
      NULL,
      10,
      5,
      0.963243,
      NULL,
      NULL,
      78.643125,
      41,
      2,
      NULL,
      0,
      NULL,
      '11324',
      '24243',
      1.430222,
      NULL,
      NULL,
      '',
      1.851358,
      '',
      '',
      NULL);
commit;
end;
/


