set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9796819';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      1,
      3.978195,
      1,
      NULL,
      NULL,
      3.307785,
      '124',
      '40210031',
      40,
      67,
      '2001443',
      3.805544,
      0,
      6,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      99,
      NULL,
      NULL,
      1,
      3,
      ' 0-22-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      2.860404,
      NULL,
      NULL,
      ' 0-22-1988',
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      3.364359,
      2.085252,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.879958,
      0,
      0.815056,
      0.010032,
      0,
      1.814706,
      0.947470,
      NULL,
      1,
      5.354002,
      NULL,
      4,
      2,
      5.656353,
      3.713882,
      7.115860,
      1.736614,
      0.667490,
      NULL,
      1,
      NULL,
      2,
      0.034259,
      0.717537,
      1.289159,
      NULL,
      1,
      5,
      0,
      2.881450,
      2.707176,
      0.063939,
      0.786171,
      3,
      0,
      NULL,
      NULL,
      NULL,
      7,
      1.258291,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946751,
      0.626894,
      1,
      5,
      0,
      NULL,
      4.292621,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.589355,
      3.511418,
      7,
      0,
      NULL,
      2,
      1.057031,
      0,
      NULL,
      1,
      1,
      0.539302,
      1.643294,
      4,
      NULL,
      1.622043,
      0.783624,
      1.200698,
      0.401215,
      NULL,
      0.945639,
      1.464094,
      1,
      0.811630,
      0.482511,
      1,
      1,
      NULL,
      1.666044,
      0,
      NULL,
      1,
      1,
      NULL,
      2.398051,
      2.318458,
      2.522925,
      0.355367,
      6.204802,
      6,
      0,
      5.414111,
      2.836591,
      2,
      0.714815,
      NULL,
      1.427819,
      2.341140,
      ' 7-13-1994',
      0,
      '11- 5-1997',
      NULL,
      1.408547,
      1.166439,
      0.275240,
      1,
      5,
      NULL,
      0,
      1,
      3.294369,
      0,
      4.334336,
      6,
      1,
      7,
      7.565722,
      NULL,
      NULL,
      NULL,
      2,
      8.644521,
      2.662599,
      ' 7- 1-1991',
      2,
      ' 7-16-1975',
      3.397856,
      NULL,
      1.201970,
      0,
      0.590953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113657,
      NULL,
      2.067312,
      3.134542,
      NULL,
      0,
      NULL,
      2,
      0.883736,
      NULL,
      0.639786,
      5.922102,
      0.957117,
      3.317270,
      0,
      0,
      2.243485,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.685428,
      0,
      0,
      1,
      NULL,
      1.291915,
      1.456998,
      2,
      NULL,
      0.968491,
      NULL,
      NULL,
      NULL,
      0.686106,
      1.587526,
      1.724871,
      2.952854,
      0.851033,
      1,
      3,
      3.308555,
      0,
      1,
      1,
      1,
      0,
      1.242489,
      2.586028,
      0,
      3,
      0.663929,
      0,
      NULL,
      NULL,
      1,
      0.187210,
      NULL,
      0.276222,
      1,
      0,
      0.556121,
      NULL,
      1.505824,
      0.027470,
      0.404625,
      6.984441,
      6,
      2.332414,
      NULL,
      1,
      5,
      3,
      NULL,
      1,
      2.064584,
      0.585869,
      2,
      49,
      1.218364,
      NULL,
      20,
      NULL,
      NULL,
      45,
      NULL,
      NULL,
      2,
      NULL,
      '',
      '',
      1.504716,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.051769,
      27,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.676811,
      0,
      NULL,
      NULL,
      NULL,
      0.964154,
      NULL,
      NULL,
      3.081563,
      0,
      NULL,
      0.666860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392583,
      362.959156,
      4,
      0,
      0.039874,
      1,
      1,
      0.139033,
      1,
      1.641266,
      0,
      0,
      0.150770,
      1,
      0.144103,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.721631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301374,
      0.897385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565234,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.457479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.130986,
      0.452599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.608850,
      0,
      3.232975,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.380247,
      0.558760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202678,
      1.417999,
      1,
      0,
      1.217998,
      0.689147,
      2,
      NULL,
      1.644455,
      0,
      NULL,
      1,
      0.494148,
      NULL,
      NULL,
      1.256574,
      0,
      NULL,
      0,
      1,
      NULL,
      0.495096,
      1.369679,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365894,
      1.068383,
      NULL,
      1.419986,
      1.670655,
      NULL,
      0,
      0.273789,
      NULL,
      0,
      1.152784,
      NULL,
      0.811562,
      NULL,
      NULL,
      0,
      1.486965,
      NULL,
      0,
      1,
      1.643141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.489139,
      0,
      5,
      0,
      NULL,
      NULL,
      124.845123,
      137,
      3,
      2,
      3,
      '03243',
      NULL,
      '',
      0.431262,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


