set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '4422213',
      NULL,
      1.564844,
      0,
      NULL,
      '0102',
      3,
      1,
      NULL,
      NULL,
      ' 2- 1-1997',
      NULL,
      NULL,
      2.671733,
      1.016499,
      0.406985,
      NULL,
      20,
      1.326746,
      282,
      22,
      3,
      ' 2- 9-1998',
      ' 0- 9-1978',
      ' 6- 8-1982',
      0,
      2,
      2,
      2,
      0,
      3,
      2.535946,
      2.065644,
      NULL,
      NULL,
      NULL,
      9,
      8,
      8.871613,
      NULL,
      6,
      12,
      0.822262,
      1,
      5.250181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.341897,
      3,
      0,
      0,
      9.950369,
      1,
      NULL,
      0,
      1.915882,
      NULL,
      5.942267,
      3.974804,
      0,
      0,
      0,
      1,
      11,
      1,
      NULL,
      0,
      1,
      3,
      5,
      0,
      1,
      2.998359,
      1,
      NULL,
      1,
      1,
      NULL,
      1.466063,
      1.544023,
      1.246575,
      0.667028,
      0.800980,
      3.396362,
      0.012634,
      0,
      1,
      NULL,
      1.576055,
      1,
      1,
      1,
      0.130465,
      0,
      0.916239,
      0,
      7,
      3.660409,
      3,
      3,
      NULL,
      NULL,
      1,
      1.780283,
      NULL,
      NULL,
      0,
      1.239251,
      NULL,
      1,
      5.766357,
      3.025807,
      0,
      1.098533,
      1,
      0.361006,
      2.999990,
      3,
      NULL,
      1.355771,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      3,
      1.088393,
      0.556890,
      5.403844,
      0,
      1,
      NULL,
      0.043925,
      1.928338,
      5.481986,
      3.151278,
      0,
      6.556067,
      1.037514,
      NULL,
      3.126416,
      1,
      1.932572,
      NULL,
      1,
      5,
      2.671144,
      7,
      5.269147,
      2.076514,
      1.682992,
      2,
      ' 6-21-1976',
      46,
      ' 4-14-1997',
      23.233956,
      1.914956,
      0.954767,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      2.923608,
      NULL,
      0.681952,
      4.680811,
      3.187556,
      2,
      11.754740,
      7.916740,
      7,
      11,
      2.374646,
      NULL,
      3,
      NULL,
      3,
      ' 1- 8-1989',
      NULL,
      0,
      5.892593,
      1.298071,
      7.287161,
      NULL,
      5.095551,
      2,
      0.890793,
      3,
      0,
      1,
      0.972123,
      0,
      13.765055,
      10.057937,
      1.966753,
      3.825637,
      0.740605,
      3,
      NULL,
      3.229847,
      NULL,
      5,
      1.199263,
      1,
      1,
      1.654447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7,
      1,
      5,
      ' 0-26-1999',
      1,
      '10- 5-1987',
      NULL,
      NULL,
      NULL,
      0.059091,
      0.375412,
      NULL,
      1,
      2,
      1.196196,
      0.215058,
      NULL,
      1,
      43,
      0.940702,
      0.360130,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      5,
      1,
      3.267010,
      NULL,
      0,
      3,
      1,
      4,
      2,
      0.518730,
      5,
      NULL,
      6.277687,
      1.568331,
      1,
      1.378880,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0.541681,
      1.931811,
      1,
      0,
      6,
      1,
      NULL,
      3.775299,
      7,
      10,
      11,
      3,
      NULL,
      3.724329,
      4,
      3,
      0.826040,
      1.453197,
      5.731497,
      0,
      3,
      NULL,
      6.975930,
      NULL,
      NULL,
      4.289995,
      NULL,
      NULL,
      '03203',
      '41221',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '04324',
      NULL,
      0.335844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426990,
      6.876503,
      NULL,
      3.442908,
      NULL,
      1.190567,
      0.616786,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      7282,
      1338.170433,
      1,
      NULL,
      NULL,
      0,
      0,
      1.880465,
      0,
      1.615047,
      0.228730,
      1.754502,
      1,
      1.963715,
      1,
      0,
      NULL,
      0.511145,
      0,
      3.688720,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.198763,
      NULL,
      NULL,
      3.487172,
      7,
      NULL,
      3,
      NULL,
      3.780664,
      3.836036,
      0.265063,
      1.298832,
      1,
      0.033409,
      1.092867,
      NULL,
      0.885301,
      NULL,
      1.355244,
      1,
      0,
      0,
      NULL,
      1.892497,
      0.113547,
      0,
      NULL,
      0.834846,
      2.302642,
      NULL,
      3,
      NULL,
      0,
      3.189279,
      0,
      0.353518,
      0.993241,
      0.763155,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.086234,
      NULL,
      3,
      1,
      0,
      1,
      2.970524,
      2.458960,
      3,
      1.617722,
      NULL,
      1.754600,
      NULL,
      1.032839,
      3.817714,
      NULL,
      1,
      1,
      0.725253,
      0,
      3,
      3,
      1,
      0,
      2.697001,
      2.041360,
      3,
      0,
      182.564259,
      3.989188,
      NULL,
      0.862473,
      1.351268,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3.590488,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.326850,
      NULL,
      3,
      NULL,
      0.112159,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.126424,
      0.539724,
      1,
      NULL,
      0,
      3,
      7.013624,
      2.092424,
      1.630304,
      NULL,
      NULL,
      NULL,
      60,
      3,
      0.557960,
      0.835571,
      NULL,
      '02311',
      '',
      NULL,
      '',
      NULL,
      '',
      2,
      '22023',
      NULL,
      NULL);
commit;
end;
/


