set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8623016';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '4000401',
      2.923281,
      1,
      0,
      3,
      NULL,
      2,
      0,
      NULL,
      NULL,
      ' 9-26-1996',
      52.961561,
      NULL,
      4.159298,
      2.344757,
      1,
      ' 2-26-2000',
      27,
      1,
      1738.320723,
      NULL,
      NULL,
      ' 0-24-1984',
      ' 8- 9-1993',
      ' 4- 8-1992',
      0,
      NULL,
      2.208378,
      1,
      1,
      1,
      1.917576,
      0.692568,
      NULL,
      NULL,
      NULL,
      10.345078,
      6,
      NULL,
      132.754056,
      5.952200,
      14.331599,
      5,
      2.140856,
      9.867324,
      0.514708,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.555313,
      0,
      1.484408,
      NULL,
      3.171042,
      0.603212,
      1,
      3,
      2,
      NULL,
      1,
      NULL,
      0.631255,
      1.221162,
      0.712183,
      1.014867,
      0.871399,
      0.611257,
      0,
      1.406310,
      1.352982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343014,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996932,
      1.492231,
      1.904774,
      0.555261,
      1,
      0,
      0,
      1.256375,
      1,
      1,
      1,
      0.838538,
      0,
      0.549058,
      0.511606,
      0.437056,
      1.966859,
      0.531856,
      NULL,
      NULL,
      NULL,
      0.567364,
      0.518376,
      0.477832,
      NULL,
      0.038105,
      1,
      NULL,
      1.207033,
      0.807020,
      NULL,
      NULL,
      3,
      0.672665,
      1.684278,
      NULL,
      3.625269,
      NULL,
      3.082653,
      2.530885,
      NULL,
      4,
      NULL,
      6,
      1,
      NULL,
      0,
      3.036805,
      ' 2- 4-1998',
      642,
      NULL,
      197,
      0,
      1,
      0,
      6.329054,
      1.870131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712652,
      0,
      1,
      1.307426,
      1.770627,
      1.094284,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773106,
      1.934216,
      0.558905,
      0.600608,
      0.657024,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.840924,
      1.767375,
      0,
      0.163120,
      NULL,
      0.546722,
      NULL,
      2.569707,
      15.208354,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.370698,
      5.810667,
      3,
      5.605113,
      5,
      1.181326,
      1,
      4.443206,
      3,
      5.814252,
      2.587994,
      4,
      3,
      3.591086,
      0,
      0,
      1.466639,
      0.299828,
      1,
      1.536743,
      0.862763,
      0.330642,
      NULL,
      1,
      0.074717,
      1.425351,
      NULL,
      NULL,
      0.718035,
      0,
      NULL,
      4.923146,
      7.422915,
      0,
      10,
      1.461211,
      1.288199,
      2,
      3.107411,
      0,
      2,
      NULL,
      69.705111,
      NULL,
      3,
      NULL,
      34,
      12,
      NULL,
      4.747934,
      1.820684,
      0.584705,
      '12013',
      NULL,
      '',
      1.855570,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      2.989672,
      34,
      76.819550,
      18,
      3.272406,
      19.133923,
      5.520670,
      11.573484,
      0,
      3.122731,
      0.163540,
      0,
      2.620527,
      2,
      1,
      0,
      NULL,
      0.626753,
      3.868703,
      NULL,
      1.457414,
      0,
      0,
      NULL,
      NULL,
      0,
      2.638584,
      1,
      2.767777,
      1.579234,
      1,
      NULL,
      NULL,
      1,
      0,
      0.213941,
      NULL,
      3.359225,
      1,
      NULL,
      0.969343,
      0,
      NULL,
      NULL,
      NULL,
      9,
      5,
      0.154232,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.716448,
      3.142452,
      1,
      2,
      1,
      3,
      3,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      3,
      NULL,
      3.913324,
      3,
      NULL,
      0.096223,
      0,
      0.727810,
      0,
      1.224155,
      0.519400,
      1.874431,
      NULL,
      NULL,
      1.065492,
      NULL,
      NULL,
      2.819092,
      0,
      1,
      8.300254,
      9.943683,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      3,
      1.355944,
      NULL,
      2.050950,
      0,
      0,
      NULL,
      NULL,
      2.426237,
      1,
      0.618856,
      NULL,
      3,
      1,
      3,
      3.164940,
      1,
      6,
      3,
      1.992346,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.128765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490178,
      0.973066,
      1.175761,
      2.306997,
      NULL,
      1,
      0,
      6,
      1,
      6,
      5,
      5.809505,
      1,
      NULL,
      NULL,
      2.905718,
      0,
      2.138944,
      0,
      NULL,
      0.148882,
      2.958522,
      3,
      NULL,
      11,
      4.607691,
      0.414349,
      3,
      0.038880,
      1.842536,
      3.486190,
      0.858121,
      1,
      3,
      0.521587,
      3,
      13.835960,
      NULL,
      NULL,
      NULL,
      7,
      0,
      2,
      4,
      1.708267,
      0.004834,
      2.885721,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000544,
      NULL,
      NULL,
      1.218358,
      NULL,
      NULL,
      0.974618,
      NULL,
      NULL,
      3.678718,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      0,
      1.743081,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0.312029,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.625399,
      NULL,
      NULL,
      NULL,
      1.169729,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.174757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620620,
      NULL,
      NULL,
      NULL,
      1.790635,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206073,
      NULL,
      NULL,
      NULL,
      0.209581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.114855,
      58,
      1.299281,
      1.419994,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.023389,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1275.629008,
      0.705166,
      1,
      NULL,
      1,
      0.013006,
      NULL,
      0.434056,
      0,
      0.330500,
      1.727516,
      1.265731,
      0.974138,
      0.815473,
      0,
      0.236884,
      0.931914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.744525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224322,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709805,
      0.985296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.097919,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1.467388,
      1.634569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.572492,
      8.507109,
      NULL,
      0.663892,
      NULL,
      19.678258,
      1,
      19,
      3.910810,
      1.174245,
      NULL,
      3.332913,
      0.656142,
      NULL,
      17,
      NULL,
      12,
      7.222473,
      1,
      2.869634,
      4,
      0.209676,
      8,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.416374,
      4,
      14,
      3.792086,
      2.513358,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.080491,
      1,
      3.259406,
      4,
      2.312530,
      0.431888,
      NULL,
      NULL,
      58,
      71.667638,
      2,
      1.779578,
      NULL,
      '02314',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


