set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9506229';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      3.774939,
      1.393474,
      1.987772,
      0,
      NULL,
      2.098899,
      NULL,
      NULL,
      '10401233',
      66.784014,
      NULL,
      '0043344',
      NULL,
      0,
      4,
      NULL,
      '3230',
      0,
      0.620123,
      NULL,
      NULL,
      '11-23-1975',
      159.990208,
      67.674520,
      NULL,
      1.284289,
      0.589154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.097432,
      NULL,
      NULL,
      NULL,
      1.937249,
      1.328784,
      NULL,
      1.055321,
      0,
      NULL,
      NULL,
      NULL,
      1.950914,
      1,
      11,
      14.557394,
      4.092566,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.597825,
      3,
      1.942692,
      1.895146,
      0.558327,
      1,
      NULL,
      1.898298,
      NULL,
      1,
      1.960954,
      0,
      1,
      4.837747,
      2,
      NULL,
      1,
      1.924415,
      4,
      2,
      0,
      8,
      2,
      6,
      0.137861,
      3,
      1.287831,
      8,
      3,
      0.823801,
      5,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.672870,
      1.542294,
      NULL,
      1.212038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335846,
      1,
      3.993114,
      NULL,
      2.110804,
      3,
      2,
      1.050970,
      NULL,
      NULL,
      0.391469,
      NULL,
      NULL,
      5.755151,
      0.565065,
      3.853514,
      0.955333,
      1,
      3.731878,
      4,
      0,
      0.210287,
      NULL,
      1.288094,
      1.189346,
      1,
      3,
      1,
      1.367125,
      NULL,
      1,
      1.987366,
      NULL,
      1.181193,
      1,
      NULL,
      NULL,
      NULL,
      0.656476,
      5.969156,
      5.630932,
      0.202874,
      0.619440,
      4.960768,
      NULL,
      1.534935,
      0,
      1,
      1,
      8.247812,
      6.344797,
      7.571832,
      3,
      NULL,
      7,
      7.990053,
      6.507793,
      2,
      3,
      4.818620,
      3,
      NULL,
      NULL,
      ' 9-10-1986',
      NULL,
      1.056236,
      0,
      3,
      0,
      0.505136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.443749,
      0.692904,
      3.345554,
      2,
      0.949284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.100417,
      NULL,
      NULL,
      2,
      0.270375,
      0.557084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942304,
      3,
      1,
      2.397765,
      0.949911,
      NULL,
      4.159144,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359870,
      2,
      1,
      2,
      1.863190,
      0.754186,
      NULL,
      1.862929,
      13.667510,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      0,
      0.750089,
      NULL,
      4.136220,
      5.959887,
      1,
      2,
      1.375791,
      NULL,
      NULL,
      NULL,
      NULL,
      0.287046,
      NULL,
      1,
      1,
      3,
      1.004211,
      1,
      2,
      NULL,
      1,
      1,
      0,
      NULL,
      1.686007,
      NULL,
      NULL,
      1.258669,
      5,
      0.731462,
      1,
      1,
      7.278567,
      6,
      NULL,
      6,
      2.234420,
      3,
      7,
      3,
      3.213232,
      0.619449,
      36,
      0.317488,
      1,
      NULL,
      NULL,
      34,
      21.504975,
      4,
      2.605424,
      2.890294,
      '2223',
      NULL,
      '21442',
      NULL,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      2,
      18.075455,
      0,
      17,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.446843,
      NULL,
      NULL,
      3,
      3.513839,
      3,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.080244,
      NULL,
      3,
      1.552527,
      3,
      2,
      3,
      1.757980,
      NULL,
      NULL,
      3,
      1,
      1.378365,
      1.550712,
      NULL,
      NULL,
      3,
      NULL,
      1.959366,
      3.925014,
      0.715143,
      NULL,
      NULL,
      NULL,
      1.961220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302901,
      NULL,
      NULL,
      0.597430,
      NULL,
      NULL,
      0.403485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.493361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330431,
      NULL,
      NULL,
      1.483251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355931,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.734336,
      2,
      0.051489,
      1,
      NULL,
      NULL,
      4.734228,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.609324,
      NULL,
      NULL,
      1.856574,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.843994,
      NULL,
      NULL,
      1,
      3,
      1.049253,
      2,
      5.361768,
      0,
      5.072823,
      3.640207,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.285971,
      0,
      3.961935,
      0.636943,
      0.678890,
      3,
      1.660740,
      4.513336,
      0.029697,
      7,
      0.256299,
      3.847512,
      0.950302,
      1.650136,
      3,
      3.673059,
      2,
      3,
      NULL,
      0.981645,
      3,
      2,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      1.881932,
      1,
      4.278784,
      NULL,
      1,
      1.656623,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.999931,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.513309,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      3.678720,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.696939,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.883003,
      NULL,
      NULL,
      NULL,
      7.111208,
      NULL,
      NULL,
      NULL,
      0.849035,
      NULL,
      NULL,
      NULL,
      1,
      0.825107,
      0,
      2.049569,
      1.232449,
      0,
      1.790631,
      NULL,
      NULL,
      0,
      0.188328,
      1.467636,
      NULL,
      NULL,
      NULL,
      1.924765,
      NULL,
      NULL,
      0.536880,
      NULL,
      0.107050,
      91.534209,
      1.448524,
      0,
      0,
      1.872637,
      2,
      NULL,
      1.362712,
      0.659702,
      2,
      0.749118,
      0.917769,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1.146312,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.515436,
      NULL,
      1.675908,
      NULL,
      3,
      NULL,
      11.889546,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      0,
      NULL,
      NULL,
      0.404593,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.269344,
      NULL,
      1.328815,
      NULL,
      0.348919,
      NULL,
      1,
      NULL,
      0.258508,
      NULL,
      1.982468,
      NULL,
      1.072728,
      NULL,
      0.567819,
      2.031540,
      NULL,
      0.793424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640113,
      0.114387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.400467,
      NULL,
      0.204021,
      NULL,
      NULL,
      NULL,
      3.478219,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.848179,
      NULL,
      0.058493,
      NULL,
      1.634367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.066476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.885572,
      NULL,
      2,
      NULL,
      42,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.866756,
      NULL,
      0.084268,
      0,
      5,
      NULL,
      0.351210,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1.564618,
      1.104066,
      3,
      3,
      0.333651,
      NULL,
      2,
      2.654073,
      NULL,
      2,
      3.305832,
      NULL,
      NULL,
      0.864771,
      NULL,
      2,
      2.556842,
      NULL,
      0,
      NULL,
      NULL,
      0.370175,
      NULL,
      NULL,
      1,
      0.857678,
      NULL,
      1.541201,
      1,
      NULL,
      1.995979,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.846150,
      NULL,
      1,
      1.812580,
      NULL,
      1,
      0.271118,
      0.879175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.165705,
      NULL,
      7.329697,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      16,
      7,
      5,
      4,
      NULL,
      '3424',
      '13030',
      NULL,
      1.737123,
      '',
      '',
      '',
      1.829206,
      '',
      '',
      '');
commit;
end;
/


