set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8928591';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      0.023541,
      1,
      NULL,
      1,
      '1432',
      1,
      0,
      NULL,
      NULL,
      ' 5-19-1989',
      32,
      NULL,
      1.284193,
      3,
      NULL,
      NULL,
      52.891698,
      3,
      41.364039,
      126,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874621,
      NULL,
      NULL,
      1.417595,
      0.706108,
      0.381553,
      8,
      0,
      1.304437,
      NULL,
      9,
      NULL,
      8,
      NULL,
      18.940138,
      3,
      15,
      NULL,
      3,
      9,
      0.006646,
      NULL,
      0,
      1,
      1,
      0,
      0,
      3.817998,
      1.568903,
      0.239766,
      0,
      3.506751,
      5.872956,
      3,
      NULL,
      NULL,
      1,
      1.758026,
      1,
      7,
      0,
      3.425382,
      1,
      0.014634,
      0.821967,
      1.757885,
      0,
      6,
      1.215637,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.675257,
      0,
      0.981165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.426264,
      5.468183,
      7.516275,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      3.063423,
      NULL,
      0.556534,
      NULL,
      0.362426,
      0.364959,
      0.898689,
      0.825370,
      NULL,
      3,
      2,
      NULL,
      6,
      1,
      NULL,
      NULL,
      1.009261,
      0,
      NULL,
      1.529750,
      5.859156,
      3.508168,
      3,
      NULL,
      1,
      2,
      0.260789,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.105338,
      NULL,
      0,
      9,
      0,
      4.088076,
      2.926157,
      7.977542,
      5,
      9.962927,
      4.483288,
      NULL,
      0.867147,
      5,
      3.593514,
      ' 0-17-2003',
      125.749916,
      ' 0-27-1992',
      1697,
      3.608711,
      4.854141,
      0.839008,
      2.095542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.318984,
      0,
      0,
      0.457158,
      3.796495,
      1,
      1.268780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219341,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.856342,
      1,
      0,
      0.707109,
      1.016148,
      0,
      1.959966,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.691821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.777095,
      1.448079,
      0.258470,
      1.986973,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      3.888386,
      1.423870,
      2,
      1.881897,
      3.518408,
      2,
      0,
      0,
      2,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.505074,
      1,
      0.084404,
      0.247409,
      1.696225,
      0.291108,
      1,
      0,
      2,
      0,
      9.455799,
      10.505196,
      5,
      10.123615,
      4.636840,
      4,
      NULL,
      3,
      6.980815,
      3,
      0.615592,
      2,
      41,
      0.000618,
      0.713809,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.571681,
      2.667915,
      '23422',
      '',
      '',
      0.114098,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1.033303,
      NULL,
      542.496680,
      NULL,
      NULL,
      12,
      19.648898,
      26,
      5,
      0,
      1,
      NULL,
      10.679024,
      NULL,
      NULL,
      1.956816,
      NULL,
      0,
      3,
      0.265714,
      0,
      3,
      2.382432,
      NULL,
      1.705138,
      NULL,
      NULL,
      NULL,
      NULL,
      2.938138,
      NULL,
      1,
      NULL,
      2,
      12.622354,
      0,
      3,
      8,
      19.873417,
      0,
      1.476335,
      NULL,
      3,
      NULL,
      NULL,
      6,
      NULL,
      3.251941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0.167323,
      0.944811,
      NULL,
      0,
      17.680764,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2.491709,
      2.612214,
      1,
      0.388017,
      1,
      1.998455,
      1,
      NULL,
      0,
      1.400657,
      NULL,
      1.341643,
      NULL,
      1.574776,
      1,
      0,
      3,
      16,
      NULL,
      15.393659,
      NULL,
      NULL,
      0,
      1.667514,
      2.671899,
      6,
      1.799395,
      5,
      2,
      0.290446,
      NULL,
      NULL,
      NULL,
      3.996077,
      NULL,
      NULL,
      NULL,
      2,
      0.622316,
      2,
      1.848255,
      3.395259,
      0.119667,
      NULL,
      NULL,
      1,
      3,
      2,
      0,
      1,
      7.329747,
      NULL,
      1.890012,
      NULL,
      NULL,
      3.088494,
      3.879423,
      1.205891,
      1,
      NULL,
      NULL,
      0.977602,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.676237,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.609392,
      NULL,
      NULL,
      0.376672,
      5.605783,
      10,
      NULL,
      2,
      2,
      6,
      3.274120,
      NULL,
      11,
      3.564956,
      6.308871,
      11.330087,
      NULL,
      5,
      0.643709,
      2,
      2.630643,
      2.530450,
      1,
      3.623895,
      2,
      5.117074,
      NULL,
      3,
      9.218065,
      8,
      2.439786,
      13,
      0,
      1,
      NULL,
      2.592268,
      0,
      NULL,
      NULL,
      2.306723,
      5,
      0.379385,
      3.009288,
      NULL,
      2,
      0.894165,
      0,
      0,
      1.459304,
      1,
      0.904369,
      1,
      0.083715,
      NULL,
      1,
      1.929906,
      0.764709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.806063,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      0.805811,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      13.208714,
      NULL,
      NULL,
      0.751290,
      NULL,
      NULL,
      1.047401,
      NULL,
      NULL,
      0.492107,
      2,
      3,
      3,
      0.055106,
      NULL,
      0,
      2.583791,
      0,
      3,
      NULL,
      4.262800,
      5.952736,
      0,
      NULL,
      0.556574,
      NULL,
      1.161307,
      NULL,
      0.531510,
      0.981036,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.624796,
      0.010176,
      0.463927,
      NULL,
      NULL,
      1.118746,
      3,
      NULL,
      3.193545,
      2.433874,
      2,
      NULL,
      0.547909,
      4.601106,
      17.679496,
      NULL,
      2.772471,
      7.044344,
      16.225848,
      NULL,
      19,
      3.505056,
      17.598523,
      NULL,
      0,
      1.843691,
      NULL,
      NULL,
      0.859708,
      1.056350,
      1,
      NULL,
      1.870456,
      NULL,
      0,
      NULL,
      0.348582,
      0,
      18,
      NULL,
      NULL,
      1.438005,
      NULL,
      NULL,
      2,
      1,
      9.981660,
      NULL,
      NULL,
      2,
      2.139577,
      NULL,
      3.728374,
      NULL,
      0,
      NULL,
      0,
      NULL,
      4,
      NULL,
      0,
      NULL,
      1.797219,
      7,
      NULL,
      3.986506,
      NULL,
      157,
      78.963156,
      NULL,
      1.865763,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.538923,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.867207,
      NULL,
      0.656971,
      NULL,
      0.475690,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.629854,
      0.263715,
      0.237915,
      0,
      1.034516,
      1,
      0,
      NULL,
      0,
      0.833442,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.889740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.063408,
      1,
      NULL,
      2.379647,
      NULL,
      0,
      0.157690,
      6,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      0.245234,
      7.344944,
      NULL,
      1,
      15,
      NULL,
      NULL,
      2.067623,
      NULL,
      0.968147,
      1.175114,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.460507,
      NULL,
      1.476285,
      NULL,
      NULL,
      3.238210,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357038,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.298866,
      4.443620,
      2.048532,
      NULL,
      NULL,
      36,
      56.415611,
      3.405566,
      0.122316,
      NULL,
      NULL,
      NULL,
      '',
      1.563375,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


