set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678963';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      3,
      1,
      3,
      NULL,
      2,
      2.457473,
      NULL,
      '431',
      '33202004',
      25,
      63.592641,
      '4344222',
      0,
      NULL,
      0,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      ' 0-18-1984',
      258,
      110,
      NULL,
      0,
      1.595257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 2- 3-1990',
      ' 4- 2-1976',
      ' 3-16-1986',
      2,
      1,
      1,
      1,
      0,
      0,
      5,
      NULL,
      0,
      6.050346,
      4.068528,
      1.033514,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      2.871726,
      2,
      0.840600,
      NULL,
      0,
      0.564282,
      1,
      0,
      3.706282,
      NULL,
      0,
      3.125602,
      5.986037,
      NULL,
      NULL,
      1,
      4,
      1,
      8.617471,
      1.452206,
      2.256575,
      NULL,
      1,
      1.372418,
      9.610578,
      0,
      0,
      1,
      0.700072,
      1.088818,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.308506,
      NULL,
      8,
      2,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1.256086,
      NULL,
      3.975807,
      0,
      1,
      1,
      1.432245,
      1.687121,
      1.665280,
      NULL,
      0,
      1,
      6,
      1,
      4.053260,
      0,
      0.117568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.421502,
      4,
      1,
      1.910841,
      1,
      3.574947,
      1,
      1.321804,
      0.187975,
      0.548449,
      5,
      0,
      1,
      NULL,
      1,
      0.431215,
      NULL,
      1,
      0,
      1,
      1.197274,
      1,
      0,
      1,
      NULL,
      2.520486,
      NULL,
      NULL,
      NULL,
      6.919582,
      NULL,
      0,
      2,
      3,
      0.296011,
      9,
      7,
      NULL,
      1.745431,
      4.423516,
      7,
      1,
      4.746959,
      3.442012,
      3,
      ' 7-22-1988',
      0,
      ' 1- 0-1992',
      2,
      NULL,
      NULL,
      NULL,
      5.336064,
      0.178351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.692984,
      NULL,
      1.496105,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177754,
      1,
      1.154040,
      1.988458,
      NULL,
      1,
      1.146837,
      4,
      1.345257,
      3,
      3.312040,
      2,
      2.668579,
      NULL,
      NULL,
      NULL,
      1,
      5.741547,
      0.644834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.786581,
      NULL,
      0,
      0,
      1.820129,
      0.311472,
      1.110904,
      1.250295,
      6,
      0.364993,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.031878,
      0.541589,
      2.953275,
      3.342630,
      1.422984,
      NULL,
      0,
      1.100978,
      1.305366,
      1,
      1,
      0,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      1.544757,
      0,
      3.564417,
      NULL,
      3,
      NULL,
      0,
      2,
      7,
      NULL,
      8,
      NULL,
      0.646443,
      2,
      5,
      NULL,
      2,
      0,
      59.769355,
      0.645863,
      3,
      37,
      NULL,
      10,
      31,
      NULL,
      3.638839,
      2.965167,
      '11213',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.979031,
      35.824124,
      254,
      2.930518,
      0.532931,
      27,
      4.015079,
      NULL,
      0,
      0,
      0.968161,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.099948,
      NULL,
      NULL,
      1.899066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.602789,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.692941,
      0,
      1.344847,
      NULL,
      NULL,
      2,
      1.713588,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.826080,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771047,
      NULL,
      1.903913,
      0.159489,
      2.949966,
      3.759386,
      1.581189,
      3,
      3,
      2.043541,
      1.739589,
      2,
      0,
      0.654449,
      1.690951,
      1.496637,
      2,
      1,
      1,
      1,
      0,
      0.488601,
      0.997766,
      2,
      1.299722,
      1.965941,
      NULL,
      2.149994,
      1.390902,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166788,
      NULL,
      NULL,
      5.511770,
      5,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.835128,
      2.635213,
      1.295798,
      NULL,
      NULL,
      0.097623,
      NULL,
      NULL,
      2,
      0.274100,
      1.912888,
      1,
      NULL,
      NULL,
      0.707946,
      NULL,
      NULL,
      0.762328,
      1,
      0,
      0,
      NULL,
      NULL,
      3.686574,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.098653,
      NULL,
      NULL,
      0.760266,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.998034,
      0.968654,
      0.075055,
      NULL,
      NULL,
      0.129241,
      NULL,
      NULL,
      2,
      0.960446,
      0,
      NULL,
      0,
      0.066462,
      8.302880,
      1.503917,
      0.414926,
      3,
      NULL,
      2.623382,
      3,
      0.676190,
      NULL,
      1.887733,
      NULL,
      NULL,
      3,
      0,
      NULL,
      9.519083,
      1,
      4.970966,
      NULL,
      0,
      1,
      0,
      NULL,
      3.946121,
      0,
      0.291475,
      0.397978,
      1,
      0.293891,
      1.152433,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874530,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.528209,
      NULL,
      NULL,
      0.057707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.309439,
      NULL,
      NULL,
      2.489630,
      NULL,
      NULL,
      2,
      3.845294,
      0.266769,
      NULL,
      3.504715,
      2,
      2.976764,
      NULL,
      NULL,
      0.798750,
      2,
      NULL,
      3.621027,
      0.580217,
      NULL,
      NULL,
      2.099407,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1.310807,
      0.055064,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      2.917209,
      0.554825,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.472623,
      NULL,
      NULL,
      0.526257,
      0.456816,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1.296500,
      NULL,
      1,
      3,
      2.383823,
      NULL,
      1.054291,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.835496,
      0,
      0,
      NULL,
      0,
      0,
      1.334236,
      NULL,
      NULL,
      7,
      4,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.526494,
      18.961476,
      0.717160,
      0,
      10,
      0.026726,
      1,
      NULL,
      NULL,
      0.834679,
      4,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.351656,
      NULL,
      1,
      117.900635,
      NULL,
      1.068132,
      2.910435,
      1,
      0.319292,
      1,
      0.279689,
      0,
      NULL,
      0,
      2.943055,
      0.837596,
      NULL,
      1.618333,
      0.780230,
      1,
      0.877881,
      1,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.389351,
      NULL,
      NULL,
      NULL,
      2.447175,
      NULL,
      41,
      NULL,
      2.006432,
      19.957376,
      18.053183,
      NULL,
      1.400859,
      4,
      NULL,
      0,
      NULL,
      0.675380,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.033058,
      NULL,
      0.017098,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.988938,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359536,
      1,
      0,
      1.100801,
      NULL,
      0,
      1.496090,
      0,
      4.038285,
      2.129026,
      2,
      0,
      1.747278,
      0.963101,
      1.816837,
      3.968150,
      1.357647,
      2.905982,
      0.510858,
      1.884619,
      0,
      2.261778,
      1.879792,
      1.363843,
      NULL,
      1,
      1,
      1.002811,
      0,
      NULL,
      NULL,
      0.785027,
      1.073246,
      1,
      0,
      0,
      0.089599,
      0.507619,
      0.786147,
      1.333841,
      NULL,
      1.857601,
      0.648149,
      1.684633,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.958961,
      1.091458,
      1,
      1,
      3,
      4.808314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93,
      4,
      3,
      1,
      '31420',
      '40212',
      '',
      1,
      '',
      NULL,
      '',
      1.803994,
      '',
      '',
      '');
commit;
end;
/


