set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9519085';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '1134203',
      1,
      1,
      NULL,
      NULL,
      '4414',
      1,
      NULL,
      NULL,
      NULL,
      ' 6-26-1982',
      52,
      NULL,
      3.753954,
      1.291925,
      2.260127,
      NULL,
      10,
      4.005581,
      NULL,
      34.465293,
      1,
      ' 4-18-1989',
      ' 2-16-2002',
      ' 8-12-1990',
      NULL,
      0,
      3.965492,
      2.322152,
      NULL,
      1,
      7.630896,
      2.168283,
      NULL,
      NULL,
      NULL,
      1,
      2.934226,
      4,
      6,
      0.764863,
      2.562276,
      2.975471,
      0,
      4.497813,
      3.056127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.980414,
      3.235756,
      0,
      NULL,
      1.035020,
      0,
      0,
      1.093449,
      7,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.386292,
      2,
      1.821423,
      NULL,
      0,
      3.267882,
      1,
      NULL,
      NULL,
      1.605605,
      NULL,
      NULL,
      2.396619,
      0,
      0.581867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.931922,
      1.043507,
      0.749592,
      2,
      NULL,
      NULL,
      NULL,
      0.215109,
      NULL,
      NULL,
      1.336697,
      NULL,
      NULL,
      NULL,
      4.636981,
      0.204726,
      1,
      0,
      2,
      7,
      1,
      0,
      6,
      NULL,
      5,
      NULL,
      1,
      0.102626,
      0.870943,
      0,
      NULL,
      0,
      NULL,
      1,
      1.746539,
      1.456369,
      2.560883,
      3,
      3.363942,
      1.323961,
      1,
      1,
      2.430276,
      5,
      NULL,
      NULL,
      5,
      4.466892,
      NULL,
      NULL,
      5,
      NULL,
      2.824709,
      7.205267,
      7.276092,
      NULL,
      4,
      1,
      1.553752,
      NULL,
      3,
      NULL,
      3,
      ' 8-26-1990',
      7,
      3,
      0,
      0.099188,
      3,
      1.164096,
      NULL,
      0,
      0,
      1,
      0.317077,
      0.854292,
      NULL,
      0,
      2.904665,
      1.454226,
      2.757965,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888734,
      NULL,
      3.314662,
      NULL,
      0.735611,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155687,
      0.231346,
      1.065816,
      4,
      1,
      NULL,
      1.434629,
      NULL,
      NULL,
      NULL,
      1.242600,
      1.865504,
      1.037729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098480,
      1,
      1.240674,
      NULL,
      0,
      0.638064,
      1.459898,
      1.792174,
      3.247190,
      0.258637,
      1,
      NULL,
      NULL,
      NULL,
      2.584539,
      0,
      1.345378,
      0.292009,
      3.568705,
      3.979396,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1,
      1,
      0.011968,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1.617916,
      1.558898,
      0.645394,
      18.879708,
      0,
      NULL,
      NULL,
      1,
      1.640435,
      10.386754,
      5,
      5.441391,
      2,
      3.623741,
      3.542862,
      2,
      1.623915,
      25,
      0.899727,
      3.548273,
      NULL,
      58,
      49,
      36.769361,
      1.191565,
      4,
      2,
      '31101',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      0.720860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.110281,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.354232,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      10.521913,
      0,
      0.786081,
      0,
      1.384976,
      0.365838,
      1.545516,
      1.560723,
      NULL,
      NULL,
      1.865857,
      1.725111,
      NULL,
      1.404287,
      0.254155,
      1.906790,
      1.048264,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.159095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.415374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122267,
      0.002219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711121,
      1.996443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968384,
      1.616890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.579240,
      NULL,
      1.210668,
      NULL,
      NULL,
      NULL,
      0.267865,
      NULL,
      1.330648,
      NULL,
      NULL,
      1.907442,
      0.503725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719128,
      2.065815,
      1.701972,
      NULL,
      NULL,
      3,
      2.639191,
      NULL,
      3.165315,
      0.421089,
      2,
      0.548653,
      2.681300,
      2.128159,
      NULL,
      NULL,
      0.453005,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1.595885,
      0,
      NULL,
      0,
      3,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.016398,
      NULL,
      1.101823,
      1,
      NULL,
      2,
      1.646095,
      1.583660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515307,
      NULL,
      1,
      NULL,
      0.431791,
      NULL,
      0.466509,
      NULL,
      1,
      0.297245,
      NULL,
      NULL,
      NULL,
      97.081729,
      5.282007,
      2,
      0,
      '10313',
      '',
      '',
      3.395213,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


