set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9830316';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.376770,
      2.702572,
      1,
      3,
      0.367760,
      1,
      NULL,
      1,
      '301',
      '21424134',
      55.313601,
      64,
      '0001111',
      3.316110,
      0.473443,
      0,
      2,
      '2022',
      0.516057,
      0,
      NULL,
      NULL,
      ' 4- 7-1986',
      7,
      21.362179,
      NULL,
      3.554615,
      3,
      ' 2-24-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 8-15-1995',
      0.892174,
      0.371894,
      1.784590,
      1,
      NULL,
      2,
      1.820010,
      3,
      NULL,
      NULL,
      NULL,
      9.079285,
      5.235044,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.110953,
      NULL,
      0,
      5.483899,
      1,
      0,
      0,
      1,
      NULL,
      0.503067,
      0,
      1,
      0,
      0,
      0.623112,
      2.345807,
      1,
      NULL,
      0,
      4,
      0.159776,
      0,
      0.774484,
      NULL,
      1.592431,
      1.091598,
      1,
      3,
      1,
      4.213414,
      0.476517,
      0.761486,
      0.049741,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978548,
      NULL,
      2.094202,
      NULL,
      1.252264,
      1,
      1.678102,
      1,
      0.295967,
      3.115221,
      1,
      0,
      NULL,
      0,
      2.406351,
      2.271347,
      2,
      0,
      1.402345,
      1.058667,
      NULL,
      1.723462,
      1.813080,
      0.694159,
      0.169739,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.433894,
      1.131444,
      0,
      1,
      0.298695,
      0,
      0,
      0.049338,
      1.206677,
      0,
      1,
      0,
      NULL,
      0.998203,
      0,
      0.567447,
      0,
      0.654596,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.993742,
      0,
      NULL,
      1.365370,
      0,
      0,
      1.661282,
      0,
      2.194078,
      5,
      0.677072,
      0.812467,
      2,
      3.182527,
      3,
      0.771497,
      0,
      1,
      1.098934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.905206,
      1,
      0.246724,
      1.095064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067094,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.999869,
      0.083527,
      NULL,
      NULL,
      NULL,
      1.674451,
      0.587970,
      1.934272,
      0.114630,
      NULL,
      2.511179,
      0.577063,
      NULL,
      NULL,
      NULL,
      NULL,
      4.794553,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177552,
      1,
      1,
      NULL,
      0.768013,
      1,
      1.351047,
      0.857706,
      NULL,
      NULL,
      0.150956,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.533207,
      2.619214,
      2.036755,
      2,
      1,
      3.191263,
      NULL,
      NULL,
      1,
      2.944578,
      0.190780,
      3,
      0.052163,
      3.917179,
      1.046369,
      1,
      1.357359,
      0.636984,
      1.225044,
      1.768707,
      0,
      1.068481,
      0,
      1,
      NULL,
      0,
      0.784756,
      0,
      5,
      1.695671,
      3.264310,
      10,
      4,
      10,
      11,
      0.724312,
      4.678061,
      3.665890,
      1.246503,
      2.763051,
      0,
      2,
      50,
      2,
      0,
      79.641790,
      NULL,
      NULL,
      NULL,
      1.580066,
      0,
      3.516345,
      '01102',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.407466,
      NULL,
      '',
      '',
      0.964709,
      0,
      11.625917,
      32.083540,
      3,
      NULL,
      2,
      0,
      4,
      NULL,
      1.817220,
      1.604946,
      1.995331,
      NULL,
      NULL,
      1.889980,
      2.601800,
      0.885138,
      1.446214,
      NULL,
      NULL,
      0.013431,
      NULL,
      NULL,
      0.352987,
      NULL,
      NULL,
      2,
      1.709122,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.700042,
      3,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      6.747056,
      NULL,
      NULL,
      3.456821,
      1.000981,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      2.600789,
      3.446291,
      1.415606,
      2,
      0.856964,
      NULL,
      NULL,
      1.215022,
      NULL,
      NULL,
      NULL,
      1.748167,
      1.157026,
      0,
      1,
      3,
      1.499236,
      1,
      NULL,
      1,
      1.800995,
      1,
      0,
      NULL,
      2,
      0.690432,
      0,
      NULL,
      NULL,
      0.345867,
      NULL,
      NULL,
      1.596454,
      NULL,
      NULL,
      NULL,
      1.901793,
      5.406238,
      2,
      0.845976,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.463927,
      2,
      0.506088,
      NULL,
      NULL,
      1.473801,
      3.636222,
      1.026018,
      3.919983,
      2,
      0.915572,
      0,
      NULL,
      NULL,
      NULL,
      5.712452,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.874770,
      NULL,
      NULL,
      0.309746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.396602,
      3.115929,
      NULL,
      3,
      3,
      NULL,
      1.182196,
      5.833951,
      3.069405,
      4.483532,
      1.410299,
      0.053939,
      NULL,
      3,
      1.665905,
      2.136778,
      1,
      1.953662,
      0,
      NULL,
      0.526179,
      NULL,
      2,
      1,
      NULL,
      8.156434,
      NULL,
      NULL,
      2.281980,
      0.905885,
      NULL,
      1.541168,
      NULL,
      0,
      2.775840,
      1,
      2.563709,
      2,
      1,
      0.775605,
      6,
      0.838783,
      NULL,
      NULL,
      6.349517,
      2.693222,
      0.576931,
      NULL,
      1,
      1.633974,
      0,
      0.963853,
      0.471816,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035346,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.309822,
      NULL,
      NULL,
      1.467006,
      NULL,
      NULL,
      0.307884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.577172,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.567890,
      3,
      1,
      0,
      1.647398,
      NULL,
      NULL,
      NULL,
      NULL,
      9.061148,
      1,
      NULL,
      NULL,
      5.065860,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      1.279249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1.215778,
      NULL,
      NULL,
      0.004173,
      1,
      NULL,
      NULL,
      1.052652,
      1,
      NULL,
      NULL,
      NULL,
      3.831968,
      NULL,
      NULL,
      0.265207,
      0.679598,
      NULL,
      NULL,
      1.714941,
      0.093965,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.955818,
      NULL,
      NULL,
      1,
      1.522499,
      NULL,
      NULL,
      2.395020,
      0,
      NULL,
      NULL,
      3,
      0.951486,
      NULL,
      NULL,
      2,
      5.652082,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.693000,
      1,
      0.858747,
      1.451579,
      0.399533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310408,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.945388,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.793030,
      0.640346,
      1.941613,
      1.034878,
      0.913579,
      2.332842,
      0,
      0.701967,
      1,
      1.622101,
      0,
      NULL,
      0,
      1.854477,
      0,
      0.945918,
      NULL,
      0.572968,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.986273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.562498,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.004860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657482,
      0.871769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.910456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.009588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293319,
      1.140583,
      NULL,
      3.341177,
      NULL,
      0.902101,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.967552,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.280645,
      1,
      1,
      NULL,
      0,
      1.608220,
      2,
      2.139785,
      1.908812,
      NULL,
      2.290747,
      0.885560,
      NULL,
      NULL,
      NULL,
      1,
      2.972509,
      0,
      1,
      1,
      0.752803,
      0,
      0.090758,
      0,
      0.704320,
      0.620966,
      1.483147,
      0,
      NULL,
      1.740712,
      1.878502,
      1.614931,
      1.991830,
      0,
      0,
      NULL,
      1.091751,
      1.507482,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      2.187326,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.794293,
      NULL,
      4,
      1.100977,
      4.858468,
      NULL,
      NULL,
      NULL,
      70.184549,
      16,
      2.693139,
      4.144159,
      2.464629,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


