set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502207';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1444434',
      3,
      0,
      3,
      0,
      '4222',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-16-1988',
      NULL,
      NULL,
      4.425110,
      0,
      3.574862,
      ' 2- 5-1998',
      5.221374,
      1,
      343,
      110,
      1.068295,
      ' 8- 4-2003',
      NULL,
      ' 0-26-1993',
      1.058807,
      1,
      2,
      0,
      NULL,
      2.232645,
      NULL,
      2.918490,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      2,
      4.956014,
      22.978785,
      5,
      NULL,
      5.508693,
      0,
      NULL,
      NULL,
      1.770641,
      0,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      5,
      3,
      1,
      3,
      0,
      0.543183,
      1.192135,
      NULL,
      NULL,
      0.550091,
      NULL,
      NULL,
      5.856023,
      0.946510,
      0.499668,
      3.538199,
      9,
      0,
      5,
      0.666522,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.870428,
      4,
      1.520362,
      NULL,
      1.161608,
      2.162982,
      1,
      1,
      3,
      1.282520,
      0,
      0,
      1.509468,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.309976,
      5.320801,
      5.502546,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      2,
      0.912954,
      2,
      0,
      NULL,
      NULL,
      1.842509,
      NULL,
      2.963365,
      3,
      0,
      3.144611,
      1.730349,
      1,
      0,
      1.411479,
      NULL,
      NULL,
      NULL,
      3.883919,
      1,
      1.099073,
      NULL,
      1.141572,
      0,
      0,
      0.956675,
      3,
      1.302067,
      3,
      1,
      0.213208,
      0.501764,
      7.168423,
      8.037862,
      3.754369,
      1.432037,
      7.116553,
      5,
      5,
      4.205803,
      6.933507,
      NULL,
      4.619918,
      1,
      NULL,
      ' 3- 2-1985',
      179,
      ' 0-12-1993',
      207,
      NULL,
      0.874932,
      0.524774,
      0.612373,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.407319,
      3.415665,
      0,
      1,
      2,
      1.974161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540571,
      1,
      0,
      2,
      0.457908,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.289667,
      NULL,
      1.842620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.053872,
      0,
      0.023334,
      2.652539,
      0,
      NULL,
      1.552469,
      0,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.003092,
      1.915518,
      3.691098,
      1,
      1.136356,
      2.384017,
      2,
      1,
      0,
      1,
      NULL,
      0,
      2.099819,
      0,
      NULL,
      3,
      4,
      0.206049,
      0,
      0.578499,
      NULL,
      0,
      0,
      NULL,
      1.137063,
      0.715439,
      NULL,
      0,
      0.438381,
      0,
      2.771836,
      1,
      NULL,
      6,
      NULL,
      1,
      0,
      2.286166,
      3.453465,
      3,
      0.776165,
      0.836380,
      2.743684,
      0.823224,
      42,
      0.111179,
      1,
      NULL,
      47,
      10.456326,
      NULL,
      5,
      NULL,
      0.938216,
      NULL,
      '',
      '',
      0.503370,
      '0134',
      '',
      NULL,
      0.909055,
      '',
      '',
      '',
      2,
      17,
      87,
      1.509963,
      NULL,
      14.342559,
      NULL,
      1,
      3.088178,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.107692,
      NULL,
      1.440008,
      0,
      NULL,
      NULL,
      0,
      1.112709,
      1,
      1.244118,
      1,
      3.172118,
      1,
      1.349485,
      1,
      NULL,
      0.354970,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      2.221911,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542121,
      NULL,
      NULL,
      NULL,
      1,
      0.854204,
      3.443165,
      NULL,
      1.056821,
      1.778681,
      3,
      1,
      1,
      0,
      0.700228,
      NULL,
      NULL,
      1.532586,
      NULL,
      NULL,
      2.593740,
      0.920962,
      NULL,
      NULL,
      0.344366,
      NULL,
      0.092087,
      0.969002,
      2,
      0.236524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      1,
      0.979592,
      1.046144,
      1.881983,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.301241,
      NULL,
      NULL,
      2.325541,
      1,
      2.623314,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.674300,
      5,
      5.326203,
      1,
      NULL,
      NULL,
      1.935810,
      NULL,
      3,
      4.220980,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501318,
      NULL,
      NULL,
      1.000534,
      NULL,
      NULL,
      1.441104,
      NULL,
      NULL,
      3,
      1,
      2.779226,
      1.265033,
      NULL,
      NULL,
      0.181662,
      1.580306,
      NULL,
      NULL,
      0,
      1,
      1.301355,
      NULL,
      NULL,
      1.981720,
      NULL,
      0.554702,
      NULL,
      NULL,
      NULL,
      3,
      1.321844,
      0.406598,
      3.515629,
      3,
      NULL,
      1.737724,
      0,
      3,
      NULL,
      1,
      3,
      NULL,
      1.378393,
      3,
      0.736310,
      3.523069,
      1.024675,
      2.090156,
      4.675481,
      6,
      0.344117,
      NULL,
      NULL,
      1.265555,
      3.978212,
      NULL,
      1,
      0,
      1,
      1.504209,
      0,
      2.438527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.840431,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.309011,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      2.868726,
      1,
      NULL,
      NULL,
      1.790180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856583,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.071168,
      NULL,
      1.102508,
      5.070885,
      0.309477,
      NULL,
      NULL,
      1.516987,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      644.788560,
      2.682546,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.039468,
      NULL,
      3.404333,
      1.119184,
      NULL,
      1.691841,
      1.559690,
      0,
      1,
      1.863142,
      1.393880,
      NULL,
      2,
      NULL,
      0.412655,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.548614,
      NULL,
      0.031581,
      NULL,
      2.026155,
      27,
      27,
      0,
      1.743650,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665320,
      NULL,
      0.998098,
      NULL,
      1,
      NULL,
      1.478237,
      NULL,
      0,
      NULL,
      1.265458,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504454,
      0.152862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.110106,
      NULL,
      1.433233,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.411180,
      NULL,
      0,
      NULL,
      0,
      1.888439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.258835,
      1.399711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888919,
      1.189157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.997450,
      0,
      NULL,
      3,
      NULL,
      1.360912,
      NULL,
      54,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.976464,
      3,
      21.246644,
      10.420224,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662842,
      NULL,
      0.722321,
      0.105712,
      1,
      NULL,
      0,
      4,
      3.309983,
      1.729935,
      2,
      1.058863,
      0,
      1.234052,
      NULL,
      0,
      1.698897,
      NULL,
      1.136991,
      1.898719,
      NULL,
      NULL,
      0.436470,
      NULL,
      1.041067,
      1.029354,
      NULL,
      1,
      0,
      NULL,
      1,
      0.690655,
      NULL,
      1,
      0.006213,
      NULL,
      0.741801,
      0.236003,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.550101,
      1.558589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.179754,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      4.213496,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      28.274101,
      3.163805,
      5,
      NULL,
      '22443',
      NULL,
      NULL,
      2.469685,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


