set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '3443302',
      1.034451,
      NULL,
      2,
      0,
      '0343',
      1,
      0,
      NULL,
      NULL,
      '11- 5-1990',
      39,
      NULL,
      0.418367,
      3,
      3.426068,
      ' 9-12-1983',
      1,
      NULL,
      23.856142,
      155,
      2.718681,
      NULL,
      ' 1- 9-1995',
      ' 8-26-1977',
      2.052126,
      NULL,
      NULL,
      3,
      0.918776,
      NULL,
      2.236150,
      0,
      1.811121,
      51,
      NULL,
      11,
      3,
      NULL,
      9,
      1,
      18,
      2.480123,
      3,
      NULL,
      1.139337,
      1,
      1,
      NULL,
      NULL,
      0.190690,
      NULL,
      1.391033,
      0,
      0.245548,
      1.614488,
      1.254474,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.905165,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1.261702,
      3.251368,
      1,
      5.094555,
      0,
      0,
      0.892605,
      NULL,
      NULL,
      1.112742,
      NULL,
      NULL,
      1,
      0.469153,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.375110,
      1.285565,
      1.739175,
      3.233402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.514138,
      0,
      6.817540,
      0.176342,
      NULL,
      0.768832,
      5,
      1,
      2.726092,
      1,
      0,
      1,
      0,
      1.632737,
      1.349018,
      0.503813,
      0.370403,
      1.132497,
      1.859921,
      NULL,
      0.458235,
      1,
      1,
      0,
      0,
      0,
      5.264859,
      1.739418,
      0.488628,
      0,
      1.799833,
      0,
      1,
      5,
      NULL,
      NULL,
      0.363534,
      3,
      NULL,
      4.122734,
      3,
      NULL,
      4.149165,
      NULL,
      0,
      0,
      3,
      2.937518,
      NULL,
      63.252408,
      '11-26-1980',
      51,
      1,
      1.194583,
      NULL,
      7.564931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.250781,
      0.691848,
      NULL,
      1.674036,
      2.336612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.099437,
      1,
      NULL,
      0,
      NULL,
      0.137483,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      0,
      NULL,
      1.273986,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.392449,
      0.865369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.208587,
      1,
      1,
      0.378114,
      0,
      0.893863,
      NULL,
      14,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.243142,
      NULL,
      2.904857,
      1.377136,
      NULL,
      2,
      NULL,
      3,
      2,
      NULL,
      0.422738,
      NULL,
      3.107313,
      3.631397,
      0.677557,
      2,
      NULL,
      0,
      0,
      NULL,
      3.714104,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      2,
      1,
      1,
      1,
      0.788512,
      NULL,
      1,
      8.633462,
      4,
      2.717367,
      3.079966,
      0,
      2,
      1,
      3,
      69.503656,
      0.675638,
      2.011908,
      NULL,
      NULL,
      54,
      0.165541,
      1,
      0,
      7,
      '03104',
      '30001',
      '04330',
      1.149976,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.838705,
      NULL,
      118.375975,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165448,
      1.497416,
      0,
      NULL,
      NULL,
      NULL,
      2.492424,
      0,
      1.206471,
      0.787464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.938248,
      0,
      NULL,
      1.829476,
      1,
      1,
      1,
      1.099739,
      1.690243,
      2.205167,
      1,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      6.907763,
      2,
      0.263269,
      0,
      NULL,
      NULL,
      NULL,
      0.686779,
      3.482450,
      3,
      NULL,
      3.181180,
      1.012422,
      NULL,
      0,
      NULL,
      NULL,
      3.867113,
      0,
      0,
      0.198528,
      0.510845,
      NULL,
      3,
      0,
      NULL,
      2.209820,
      0,
      1.820399,
      NULL,
      3,
      NULL,
      1.226491,
      1,
      NULL,
      0.295493,
      0.658824,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.605855,
      NULL,
      NULL,
      1.234647,
      0,
      NULL,
      0.595384,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.821171,
      NULL,
      NULL,
      0,
      1,
      0.783432,
      NULL,
      0,
      3,
      1.111508,
      NULL,
      NULL,
      6.928966,
      2,
      2.988320,
      NULL,
      NULL,
      NULL,
      3.512155,
      NULL,
      1.593996,
      1.299660,
      1.606892,
      0.190524,
      1.118052,
      NULL,
      NULL,
      1.064379,
      NULL,
      NULL,
      0.209669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.063392,
      1,
      5,
      1,
      1,
      1.036383,
      1.062310,
      2,
      0.172012,
      NULL,
      NULL,
      1,
      1,
      0.395153,
      NULL,
      3,
      NULL,
      3.441212,
      1.989173,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3,
      0,
      0.546459,
      2.810002,
      0,
      1,
      0.096015,
      0,
      0.363361,
      2.017904,
      NULL,
      0.406518,
      3.932753,
      1,
      2,
      0,
      3,
      NULL,
      1.943161,
      1.989572,
      0.645600,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.065838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.662581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.834931,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.572197,
      NULL,
      NULL,
      0.622548,
      2.575422,
      3,
      2,
      NULL,
      1,
      1.754537,
      5,
      NULL,
      3.420500,
      0.320002,
      8,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.832944,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      1,
      NULL,
      0.185780,
      NULL,
      3.750911,
      NULL,
      NULL,
      NULL,
      2.292321,
      NULL,
      2,
      3.048963,
      0.226069,
      NULL,
      1,
      1.710004,
      1,
      NULL,
      1.133423,
      NULL,
      NULL,
      NULL,
      1.974653,
      1.217378,
      3,
      NULL,
      0,
      2.133731,
      NULL,
      NULL,
      1,
      3,
      0.438252,
      NULL,
      NULL,
      0.352877,
      NULL,
      NULL,
      1.091593,
      0,
      NULL,
      NULL,
      1.688085,
      0.359633,
      NULL,
      NULL,
      0.158314,
      0.874378,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.126077,
      4.671173,
      NULL,
      13,
      NULL,
      3.403053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.586682,
      NULL,
      0,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      215,
      0,
      NULL,
      NULL,
      3.052246,
      0.250979,
      2.726114,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.332168,
      1.830056,
      1,
      0,
      1,
      NULL,
      1.085276,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3.051560,
      NULL,
      3.860275,
      NULL,
      35.464990,
      NULL,
      1,
      19,
      37.243742,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.538403,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738972,
      NULL,
      0.702044,
      NULL,
      0.555592,
      NULL,
      NULL,
      1,
      1.801799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201745,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.546478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.628814,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934382,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      13,
      NULL,
      1.653696,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      31,
      11.301775,
      1.127556,
      NULL,
      NULL,
      NULL,
      1.280235,
      1,
      2.653684,
      2,
      0,
      0.149547,
      0.790753,
      NULL,
      3,
      2,
      0.180870,
      2,
      0,
      1.322863,
      1.801181,
      0,
      0.010608,
      NULL,
      1,
      1.353215,
      NULL,
      1.536718,
      1.005330,
      NULL,
      NULL,
      NULL,
      0,
      1.562098,
      1,
      0.591088,
      0.935565,
      1.046851,
      0.656178,
      1,
      NULL,
      1.389657,
      NULL,
      1,
      0.284578,
      1,
      1.616422,
      2.743097,
      0.560501,
      NULL,
      0.939292,
      NULL,
      2.651305,
      NULL,
      NULL,
      0.676059,
      NULL,
      0.861197,
      1,
      0,
      NULL,
      0.389817,
      0,
      1.728177,
      1.697650,
      0,
      NULL,
      3,
      0.518529,
      NULL,
      0.418411,
      0,
      1,
      2,
      NULL,
      1,
      2,
      NULL,
      2,
      0.524619,
      NULL,
      0,
      93.636147,
      1,
      0,
      2.439444,
      1.821986,
      3.544765,
      NULL,
      1,
      NULL,
      1,
      0.903622,
      NULL,
      1,
      1.261044,
      3.762512,
      1,
      0,
      1,
      3,
      1.971230,
      2.826791,
      1.996018,
      1,
      0.543311,
      1,
      0.384620,
      3.599622,
      2,
      NULL,
      0,
      874.239448,
      NULL,
      0.421553,
      0,
      0,
      0,
      1.634805,
      NULL,
      2.675726,
      1.865494,
      0,
      NULL,
      NULL,
      85,
      26.867671,
      NULL,
      0.828391,
      NULL,
      '44401',
      '33310',
      '01120',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


