set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9839660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3.435597,
      NULL,
      2,
      2.650218,
      2,
      1,
      NULL,
      '344',
      '10033213',
      71,
      66.161055,
      '3431312',
      2,
      0.544086,
      NULL,
      3,
      '3112',
      NULL,
      0.299073,
      NULL,
      NULL,
      ' 8-22-1994',
      154.706402,
      3.267900,
      NULL,
      2.654832,
      3,
      ' 5-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 3-18-1996',
      '10-10-1995',
      ' 8-15-1998',
      0,
      NULL,
      3,
      2,
      1,
      NULL,
      0.943390,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.482409,
      NULL,
      0,
      0.991902,
      0.428180,
      0.305453,
      1.234619,
      0.263396,
      NULL,
      1.217860,
      0,
      1,
      0,
      NULL,
      0.731668,
      2,
      1,
      10,
      0,
      0,
      0.692236,
      1.947093,
      0,
      6.770176,
      NULL,
      3.203951,
      5,
      NULL,
      3,
      11,
      0.023624,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.975594,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.029090,
      0.430315,
      1,
      0.430733,
      NULL,
      NULL,
      NULL,
      3,
      2.240194,
      1,
      2.175388,
      0,
      1,
      0.035024,
      2,
      2,
      1,
      1.956953,
      0.494497,
      NULL,
      1,
      4,
      0,
      0,
      NULL,
      NULL,
      0.316203,
      NULL,
      NULL,
      0,
      1.991852,
      0,
      0.435625,
      1.901740,
      0,
      0,
      0.679107,
      0.496594,
      0,
      1,
      0.470382,
      0.533358,
      1.848581,
      NULL,
      0.815291,
      1.534427,
      1.820719,
      0.135636,
      NULL,
      NULL,
      1,
      1.149688,
      2,
      3,
      0.493150,
      NULL,
      NULL,
      7.481696,
      6,
      NULL,
      9.857084,
      5,
      11,
      0.332184,
      1.700033,
      2.873739,
      8,
      9,
      0,
      7.930628,
      6.058881,
      5.573251,
      4.295589,
      0,
      0,
      1,
      1,
      '11-23-1976',
      NULL,
      ' 6- 0-1987',
      65.773338,
      2.676282,
      0.764559,
      0.445707,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377543,
      1,
      NULL,
      0.124325,
      0.922752,
      0.165224,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.176280,
      1,
      0,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.933359,
      0,
      1.127937,
      2,
      5,
      0.685612,
      NULL,
      NULL,
      NULL,
      5,
      1.075381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.084017,
      1,
      NULL,
      0,
      NULL,
      1.176464,
      1,
      1,
      16.154046,
      2.263889,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.915791,
      0.445397,
      1,
      6.866949,
      NULL,
      3.742157,
      2.170378,
      2.161652,
      3.455222,
      NULL,
      3,
      NULL,
      3.779564,
      0,
      1.983980,
      2,
      0.408731,
      1,
      1.517262,
      0,
      1.466651,
      1,
      0.642377,
      1.753623,
      1,
      0,
      1,
      1.178967,
      0,
      1,
      NULL,
      9.419816,
      NULL,
      2,
      0.716073,
      NULL,
      NULL,
      3,
      NULL,
      6,
      NULL,
      0,
      2.712493,
      70,
      1,
      1,
      9.627322,
      NULL,
      9.951730,
      25.413930,
      2.050410,
      0.977824,
      1.683689,
      '23044',
      '',
      '',
      1.173442,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      27.716666,
      NULL,
      11.036365,
      1.499140,
      0,
      4,
      1.514579,
      NULL,
      0.927455,
      1,
      NULL,
      NULL,
      1.878369,
      NULL,
      NULL,
      1.044238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.907573,
      NULL,
      NULL,
      2,
      0.873438,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.437695,
      0,
      NULL,
      0.638649,
      1,
      1.004743,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.325794,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.617507,
      1.971329,
      0,
      0.834300,
      3.953093,
      NULL,
      0.145881,
      0,
      0,
      3.425222,
      0.400290,
      1,
      NULL,
      NULL,
      3,
      2,
      1,
      1,
      3,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      0.122584,
      NULL,
      NULL,
      0.980187,
      NULL,
      NULL,
      NULL,
      7,
      0,
      1.192260,
      0,
      NULL,
      NULL,
      NULL,
      0.629147,
      NULL,
      NULL,
      NULL,
      1,
      0.284621,
      0,
      1,
      0,
      0,
      1.128512,
      NULL,
      NULL,
      0.666988,
      NULL,
      NULL,
      7.838945,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.250385,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.657825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.465344,
      2,
      1.284127,
      NULL,
      NULL,
      1.728625,
      5.990737,
      1,
      NULL,
      4.804971,
      2.815898,
      1.703481,
      NULL,
      NULL,
      NULL,
      1.547595,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      3.671020,
      3.063219,
      NULL,
      2,
      1,
      3,
      NULL,
      2.907147,
      NULL,
      2,
      NULL,
      0.915956,
      3.966441,
      2.333188,
      0.097441,
      0,
      2,
      NULL,
      1,
      2,
      NULL,
      NULL,
      2,
      2,
      6,
      0,
      NULL,
      1,
      NULL,
      1.812346,
      2.953815,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.657657,
      NULL,
      NULL,
      1.381353,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.693085,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.378120,
      1,
      1.180558,
      1.432510,
      NULL,
      NULL,
      0.493487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807670,
      NULL,
      NULL,
      NULL,
      3,
      5.075239,
      2,
      1.356642,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772666,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.686038,
      NULL,
      0.285092,
      75.809715,
      0,
      NULL,
      0.683428,
      1,
      0.707246,
      NULL,
      0,
      NULL,
      0.498135,
      0.635497,
      NULL,
      0.737171,
      1.324957,
      1.026770,
      NULL,
      1.999768,
      0,
      0,
      1.312323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688518,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.842501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.523165,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.779573,
      1.774519,
      NULL,
      NULL,
      1,
      2,
      1,
      6.883618,
      2,
      1.923351,
      0,
      NULL,
      1.713840,
      NULL,
      0.423711,
      1.995446,
      NULL,
      1.732688,
      0,
      NULL,
      0.077199,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      2.381415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.801322,
      NULL,
      1.202372,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      3.089932,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.150166,
      NULL,
      NULL,
      0,
      2.880931,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.962944,
      0.029676,
      '12033',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.652572,
      '',
      '',
      NULL);
commit;
end;
/


